/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.users;

/*
 * #%L
 * dw-users
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.json.JSONObject;

import fr.emac.gind.gov.system_gov.FaultMessage;
import fr.emac.gind.gov.system_gov.GJaxbUpdateUser;
import fr.emac.gind.gov.system_gov.SystemGov;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;

public class DWUser implements Principal {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Map<String, GJaxbNode> USER_REGISTRY = Collections.synchronizedMap(new HashMap<String, GJaxbNode>());

	private String userId = null;
	private boolean isFake = false;

	private SystemGov systemClient = null;

	public DWUser(GJaxbNode user, SystemGov systemClient) {
		this.userId = user.getId();
		USER_REGISTRY.put(userId, user);
		this.systemClient = systemClient;
	}

	public DWUser(GJaxbNode user, boolean isFake, SystemGov systemClient) {
		this.userId = user.getId();
		USER_REGISTRY.put(userId, user);
		this.isFake = isFake;
		this.systemClient = systemClient;
	}

	public boolean isFake() {
		return isFake;
	}

	public String getUserId() {
		return userId;
	}

	@Override
	public String getName() {
		return GenericModelHelper.findProperty("firstName", USER_REGISTRY.get(userId).getProperty()).getValue() + " "
				+ GenericModelHelper.findProperty("lastName", USER_REGISTRY.get(userId).getProperty()).getValue();
	}

	public GJaxbNode getUser() {
		return USER_REGISTRY.get(userId);
	}

	public void setUser(GJaxbNode user) throws Exception {
		if (userId.equals(user.getId())) {
			USER_REGISTRY.put(userId, user);
			GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
			reqUser.setNode(user);
			this.systemClient.updateUser(reqUser);
		} else {
			throw new Exception("Invalid User Id !!!");
		}
	}

	public boolean isAdmin() {
		JSONObject roles = new JSONObject(
				GenericModelHelper.findProperty("roles", USER_REGISTRY.get(userId).getProperty()).getValue());
		return roles.getJSONObject("admin").getBoolean("checked");
	}

	public String getPassword() {
		return GenericModelHelper.findProperty("password", USER_REGISTRY.get(userId).getProperty()).getValue();
	}

	public String getEmail() {

		return GenericModelHelper.findProperty("email", USER_REGISTRY.get(userId).getProperty()).getValue();
	}

	public String getPropertyValue(String propertyName) {
		return GenericModelHelper.findProperty(propertyName, USER_REGISTRY.get(userId).getProperty(), true).getValue();
	}

	public String getCurrentCollaborationName() {
		return GenericModelHelper.findProperty("currentCollaborationName",
				USER_REGISTRY.get(userId).getProperty()) != null ? GenericModelHelper
						.findProperty("currentCollaborationName", USER_REGISTRY.get(userId).getProperty()).getValue()
						: null;
	}

	public String getCurrentKnowledgeSpaceName() {
		return GenericModelHelper.findProperty("currentKnowledgeSpaceName",
				USER_REGISTRY.get(userId).getProperty()) != null ? GenericModelHelper
						.findProperty("currentKnowledgeSpaceName", USER_REGISTRY.get(userId).getProperty()).getValue()
						: null;
	}

	public void setCurrentCollaborationName(String collab) throws Exception {
		GenericModelHelper.findProperty("currentCollaborationName", USER_REGISTRY.get(userId).getProperty(), true)
				.setValue(collab);
		if (!this.isFake) {
			GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
			reqUser.setNode(USER_REGISTRY.get(userId));
			this.systemClient.updateUser(reqUser);
		}
	}

	public void setCurrentKnowledgeSpaceName(String knowledge) throws Exception {
		GenericModelHelper.findProperty("currentKnowledgeSpaceName", USER_REGISTRY.get(userId).getProperty(), true)
				.setValue(knowledge);
		if (!this.isFake) {
			GJaxbUpdateUser reqUser = new GJaxbUpdateUser();
			reqUser.setNode(USER_REGISTRY.get(userId));
			this.systemClient.updateUser(reqUser);
		}
	}

	public static GJaxbNode getAlreadyLoggedUser(String userId) {
		return USER_REGISTRY.get(userId);
	}
}
