/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.utils;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2016 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.ArrayList;
import java.util.List;

import fr.emac.gind.application.model.GJaxbHeaderMenuBar;
import fr.emac.gind.application.model.GJaxbItem;
import fr.emac.gind.application.model.GJaxbMenuType;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class ApplicationHelper {
  
  public static GJaxbMenuType getMenu(String title, GJaxbHeaderMenuBar appMB) {
    for(GJaxbMenuType menu: appMB.getHeaderMenu()) {
      if(menu.getTitle().equals(title)) {
        return menu;
      }
    }
    return null;
  }
  
  public static GJaxbItem getMenuItem(String title, GJaxbMenuType appM) {
    for(GJaxbItem item: appM.getItem()) {
      if(item.isSetMenuItem() && item.getMenuItem().getTitle().equals(title)) {
        return item;
      }
    }
    return null;
  }

  public static List<GJaxbItem> getMenuItems(GJaxbMenuType appM) {
    List<GJaxbItem> res = new ArrayList<GJaxbItem>(); 
    for(GJaxbItem item: appM.getItem()) {
      if(item.isSetMenuItem() ) {
        res.add(item);
      }
    }
    return res;
  }
  
}
