/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.utils;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2016 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import io.dropwizard.core.setup.Environment;

public class RestResourceManager {

  private Environment env = null;
  private List<Object> resources = Collections.synchronizedList(new ArrayList<Object> ());

  public RestResourceManager(Environment env) {
    this.env = env;
  }

  public <T> T findResource(Class<T> clazz) {
    for(Object resource: this.resources) {
      if(resource.getClass().getName().equals(clazz.getName())) {
        return (T)resource;
      }
    }
    return null;
  }

  public void addResource(Object resource, boolean force) {
    if(force) {
      resources.add(resource);
    } else {
      Object existingResource = containsEquivalentResource(resource);
      if(existingResource != null) {
        resources.remove(existingResource);
      }
      resources.add(resource);
    }
  }

  public void addResource(Object resource) {
    addResource(resource, false);
  }

  public void registerAllResources() {
    for(Object resource: this.resources) {
      env.jersey().register(resource);
    }
  }

  private Object containsEquivalentResource(Object resource) {
    List<Class> classes1 = new ArrayList<Class>();
    classes1.addAll(ReflectionHelper.findAllSuperClasses(resource.getClass()));
    classes1.add(resource.getClass());
    for(Object rsc: this.getResources()) {
      List<Class> classes2 = new ArrayList<Class>();
      classes2.addAll(ReflectionHelper.findAllSuperClasses(rsc.getClass()));
      classes2.add(rsc.getClass());
      for(Class c1:classes1) {
        for(Class c2:classes2) {
          if(!c1.getName().equals("java.lang.Object") && c1.getName().equals(c2.getName())) {
            return rsc;
          }
        }
      }
    }
    return null;
  }

  public List<Object> getResources() {
    return resources;
  }

  //  public boolean hasAlreadyResource(Environment env, Object ref) {
  //    ReflectionHelper.findAllImplementedInterfaces(clazz)
  //    for(Object obj: env.jersey().getResourceConfig().getSingletons()) {
  //      
  //      
  //      if(obj instanceof ref.getClass()) {
  //        return true;
  //      }
  //    }
  //    return false;
  //  }
}
