/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.ApplicationContext;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.utils.svg.SVGGenerator;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/generic-application/context")
//@Api("/context")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class DWApplicationContextResource {


  private CoreResource core = null;
  private GJaxbEffectiveMetaModel system = null;
  private GJaxbEffectiveMetaModel uml = null;
  protected ApplicationContext applicationContext = null;


  public DWApplicationContextResource(DWApplicationService dwApplicationService, ApplicationContext applicationContext, Configuration conf, CoreResource core) throws Exception  {
    this.applicationContext = applicationContext;
    this.core = core;

    GJaxbMetaModel coreMM = XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/core_meta_model/Core_MetaModel.xml"), GJaxbMetaModel.class);
    GJaxbEffectiveMetaModel effCoreMM = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(coreMM); 
    DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), effCoreMM, dwApplicationService.getName());
    applicationContext.setCore(effCoreMM);
    
    
    GJaxbMetaModel projectMM = XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/project/Project_MetaModel.xml"), GJaxbMetaModel.class);
    GJaxbEffectiveMetaModel effProjectMM = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(projectMM); 
    DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), effProjectMM, dwApplicationService.getName());
    applicationContext.setProject(effProjectMM);
    

    GJaxbMetaModel sysMM = XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/system/System_MetaModel.xml"), GJaxbMetaModel.class);
    system = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(sysMM); 
    DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), system, dwApplicationService.getName());
    applicationContext.setSystem(system);
    
    
    GJaxbMetaModel umlMM = XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/uml_meta_model/UML_MetaModel.xml"), GJaxbMetaModel.class);
    uml = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(umlMM); 
    DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), uml, dwApplicationService.getName());
    applicationContext.setUml(uml);

  }


  public GJaxbEffectiveMetaModel getSystem() {
    return system;
  }


  @GET @Path("/applicationContext")
  public String getApplicationContext() throws Exception {
    String res = null;
    try {
      res = this.applicationContext.toJSON().toString();
    } catch(Exception e) {
      e.printStackTrace();
      GindWebApplicationException.manageError(e, this);
    }
    return res;
  }


  public static void changeApplicationNameOnEffectiveMetaModel(
      SVGGenerator svgGenerator, GJaxbEffectiveMetaModel effMModel, String applicationName) throws Exception {
//    if(effMModel.isSetIcon()) {
//      effMModel.setIcon(effMModel.getIcon().trim().replace("##application_name##", applicationName));
//    }

    effMModel.getEffectiveConcept().forEach(n -> {
      if(n.isSetNodeMetaModeling() && n.getNodeMetaModeling().isSetModelingViewDefinition() && n.getNodeMetaModeling().getModelingViewDefinition().isSetView()) {
        n.getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(n.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl().trim().replace("##application_name##", applicationName));
        
        // calculate size of svg
        try {
          svgGenerator.setSizeOnView(n);
        } catch (Exception e) {
          throw new RuntimeException(e);
        }
      }
      n.getMetaProperty().forEach(p -> {
        changeApplicationNameInProperty(p, applicationName);
      });
    });
    effMModel.getRelation().forEach(e -> {
      if(e.isSetEdgeMetaModeling() && e.getEdgeMetaModeling().getModelingEdgeViewDefinition().isSetIcon()) {
        e.getEdgeMetaModeling().getModelingEdgeViewDefinition().setIcon(e.getEdgeMetaModeling().getModelingEdgeViewDefinition().getIcon().trim().replace("##application_name##", applicationName));
      }
      e.getMetaProperty().forEach(p -> {
        changeApplicationNameInProperty(p, applicationName);
      });
    });
  }


  public static void changeApplicationNameInProperty(GJaxbMetaProperty p, String applicationName) {
    if(p.isSetButtons()) {
      p.getButtons().getButton().forEach(b -> {
        if(b.isSetButtonIcon()) {
          b.setButtonIcon(b.getButtonIcon().trim().replace("##application_name##", applicationName));
        }
      });
    }
    if(p.isSetValues() && p.getValues().isSetFixedValues()) {
      p.getValues().getFixedValues().getValue().forEach(v -> {
        if(v.isSetIcon()) {
          v.setIcon(v.getIcon().trim().replace("##application_name##", applicationName));
        }
      });
    }
  }

}
