/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import java.io.File;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.io.FileUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.UploadUtil;
import fr.emac.gind.commons.utils.lang.ArrayHelper;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;


@Path("/{app}/generic-application/file")
//@Api("/file")
public class FileResource {

	private static Logger LOG = LoggerFactory.getLogger(FileResource.class.getName());



	private String applicationName = null;

	public FileResource(String applicationName) {
		this.applicationName = applicationName;
	}


	@GET @Path("/download")
	public String download(@Auth DWUser user, @QueryParam("resourceUrl") String resourceUrl) throws Exception {
		String validUrl = resourceUrl;
		try {
			if(resourceUrl.indexOf(RIOConstant.WEBJARS_RESOURCES_FOLDER) >= 0) {
				validUrl = resourceUrl.substring(resourceUrl.indexOf(RIOConstant.WEBJARS_RESOURCES_FOLDER) + RIOConstant.WEBJARS_RESOURCES_FOLDER.length(), resourceUrl.length());

				if(resourceUrl.indexOf("share" + "/") >= 0) {
					validUrl = resourceUrl.substring(resourceUrl.indexOf("share" + "/"));
					validUrl = RIOConstant.RESOURCES_FOLDER + "/" + validUrl;
				} else if(validUrl.contains(RegExpHelper.toRegexFriendlyName(user.getCurrentCollaborationName()))) {
					validUrl = RIOConstant.RESOURCES_FOLDER + "/" + validUrl;
				} else {
					validUrl = RIOConstant.RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName(user.getCurrentCollaborationName()) + "/" + validUrl;
				}
			}

			File rsc = new File(validUrl);

			String buffer = null;
			if(rsc.exists()) {
				buffer = FileUtil.getContents(rsc);
			}
			return buffer;
		} catch(Exception e) {
			e.printStackTrace();
			GindWebApplicationException.manageError(e, this);
		}
		return validUrl;
	}


	@POST @Path("/upload")
	@Consumes(MediaType.MULTIPART_FORM_DATA)
	public String upload(@Auth DWUser user, @FormDataParam("file") InputStream is,
			@FormDataParam("file") FormDataContentDisposition fileDetail, @QueryParam("data") String data) throws Exception {
		LOG.debug("\n\n*************************** upload *******************\n\n");
		String url = null;
		try {
			String collaborationName = null;
			String knowledgeSpaceName = null;
			
			if(user != null) {
				collaborationName = user.getCurrentCollaborationName();
				knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
			}
			
			String fileName = fileDetail != null ? fileDetail.getFileName() : null;

		
			url = UploadUtil.upload(fileName, is, data != null ? new JSONObject(data) : null, collaborationName, knowledgeSpaceName, this.applicationName,  user != null ? user.getUserId() : null);

		} catch(Exception e) {
			GindWebApplicationException.manageError(e, this);;
		}
		
		return url;
	}




}
