/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.GJaxbUpdateResponse;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.storage.Storage;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
*
*
* @author Nicolas Salatge
*/
@Path("/{app}/generic-application/storage")
//@Api("storage")
public class StorageResource {

  private Configuration conf = null;
  private Storage storageClient = null;

  public StorageResource(Configuration configuration) throws Exception {
    this.conf = configuration;
    this.storageClient = StorageClient.createClient(this.conf.getMapObjects().get("storage").toString());
    
  }
  
  @POST @Path("/query")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public GJaxbQueryResponse query(@Auth DWUser user, GJaxbQuery query) throws Exception {
    GJaxbQueryResponse responseQuery =  null;
    try {

      responseQuery = this.storageClient.query(query);

    } catch(Exception e) {
      e.printStackTrace();
      GindWebApplicationException.manageError(e, this);;
    }
    return responseQuery;
  }
  
  @POST @Path("/update")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public GJaxbUpdateResponse update(@Auth DWUser user, GJaxbUpdate updateReq) throws Exception {
	GJaxbUpdateResponse updateResp =  null;
    try {

      updateResp = this.storageClient.update(updateReq);

    } catch(Exception e) {
      e.printStackTrace();
      GindWebApplicationException.manageError(e, this);;
    }
    return updateResp;
  }
  
}
