/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources.gov;

import java.util.Map;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.meta.models.client.MetaModelsGovClient;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.GJaxbPublishSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.GJaxbUnpublishSyncEffectiveDomain;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.meta_models_gov.MetaModelsGov;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.websocket.command.WebsocketCommand;

/*
 * #%L
 * dw-users
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/generic-application/metamodels")
//@Api("metamodels")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class MetaModelsResource {

  private static Logger LOG = LoggerFactory.getLogger(MetaModelsResource.class.getName());


  private EffectiveMetaModelManager effMM = null;


  private MetaModelsGov metaModelsClient = null;
  private CoreGov coreClient = null;
  private Storage storageClient = null;

  private Configuration conf = null;

  public static SPIWebServicePrimitives ASYNC_PUBLISH_EXTRACT_CONSUMER = null;
  protected WebsocketCommand wEB_SOCKET_COMMAND = null;

  public MetaModelsResource(Configuration conf, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
    this.metaModelsClient = MetaModelsGovClient.createClient(conf.getProperties().get("governance").replace("/gov", "/GovMetaModels"));
    this.coreClient   = CoreGovClient.createClient(conf.getProperties().get("governance").replace("/gov", "/GovCore"));
    this.storageClient = StorageClient.createClient(conf.getProperties().get("storage"));
    this.conf = conf;
    this.wEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
    Map<QName, GJaxbEffectiveMetaModel> allMetaModels = EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromMetaModelByQNameMap();
    this.effMM = new EffectiveMetaModelManager(allMetaModels.values().toArray(new GJaxbEffectiveMetaModel[allMetaModels.values().size()]));

  }


  public MetaModelsGov getMetaModelsClient() {
    return metaModelsClient;
  }

  @GET @Path("/getUMLEffectiveDomain")
  public GJaxbEffectiveDomain getUMLEffectiveDomain(@Auth DWUser user) throws Exception {
    GJaxbEffectiveDomain uml = new GJaxbEffectiveDomain();
    return EffectiveMetaModelPluginManager.getInstance().getUmlEffectiveDomain();
  }

  @POST @Path("/publishSyncEffectiveDomain")
  public fr.emac.gind.gov.meta_models_gov.GJaxbPublishUnpublishResultType publishSyncEffectiveDomain(@Auth DWUser user, GJaxbPublishSyncEffectiveDomain model) throws Exception {
    fr.emac.gind.gov.meta_models_gov.GJaxbPublishUnpublishResultType response = this.metaModelsClient.publishSyncEffectiveDomain(model);
    return response;
  }

  @POST @Path("/unpublishSyncEffectiveDomain")
  public fr.emac.gind.gov.meta_models_gov.GJaxbPublishUnpublishResultType unpublishSyncEffectiveDomain(@Auth DWUser user, GJaxbUnpublishSyncEffectiveDomain model) throws Exception {
    fr.emac.gind.gov.meta_models_gov.GJaxbPublishUnpublishResultType response = this.metaModelsClient.unpublishSyncEffectiveDomain(model);
    return response;
  }
  
  @POST @Path("/extractSyncEffectiveDomain")
  public fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomainResponse extractSyncEffectiveDomain(@Auth DWUser user, GJaxbExtractSyncEffectiveDomain model) throws Exception {
    fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomainResponse response = this.metaModelsClient.extractSyncEffectiveDomain(model);
    return response;
  }

}
