/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.Neo4JClient;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.neo4j.GJaxbQuery;
import fr.emac.gind.neo4j.GJaxbQueryResponse;
import fr.emac.gind.neo4j.Neo4J;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/generic-application/neo4j")
//@Api("neo4j")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class Neo4JResource {

  private Neo4J neo4jClient = null;

  public Neo4JResource(Configuration conf) throws Exception {
    this.neo4jClient   = Neo4JClient.createClient(conf.getProperties().get("governance").replace("/gov", "/GovNeo4J"));
  }

  @POST @Path("/query")
  public GJaxbQueryResponse query(@Auth DWUser user, GJaxbQuery query) throws Exception {
    assert user != null;
    GJaxbQueryResponse response = null;
    try {
      response = this.neo4jClient.query(query);

      
    } catch(Exception e) {
      GindWebApplicationException.manageError(e, this);
    }

    return response;
  }
}
