/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources.gov;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.gov.models_gov.GJaxbCloneASyncModelFromStatusCallBack;
import fr.emac.gind.gov.models_gov.GJaxbCloneASyncModelFromStatusCallBackResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelCallBackResponse;
import fr.emac.gind.gov.models_gov.GJaxbFreezeASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbFreezeASyncModelCallBackResponse;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModelCallBackResponse;
import fr.emac.gind.gov.models_gov.GJaxbSendCallbackError;
import fr.emac.gind.gov.models_gov.GJaxbSendCallbackErrorResponse;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishASyncModelCallBackResponse;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.gov.models_gov.FaultMessage;
import fr.emac.gind.gov.models_gov.ModelsGovCallback;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;

@WebService(portName = "models_govCallBackSOAP", serviceName = "models_gov_callback", targetNamespace = "http://www.gind.emac.fr/gov/models_gov/", wsdlLocation = "wsdl/models-gov.wsdl", endpointInterface = "fr.emac.gind.gov.models_gov.ModelsGovCallback")
@BindingType("http://schemas.xmlsoap.org/wsdl/soap/http")
public class RIOGAModelsGovCallBackImpl implements ModelsGovCallback {

	private static Logger LOG = LoggerFactory.getLogger(RIOGAModelsGovCallBackImpl.class.getName());

	protected WebsocketCommand wEB_SOCKET_COMMAND = null;

	public RIOGAModelsGovCallBackImpl(WebsocketCommand wEB_SOCKET_COMMAND) {
		this.wEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
	}

	@Override
	public GJaxbUnpublishASyncModelCallBackResponse unpublishASyncModelCallBack(
			GJaxbUnpublishASyncModelCallBack parameters) throws FaultMessage {
		throw new FaultMessage("Not Implemented !!", null);
	}

	@Override
	public GJaxbPublishASyncModelCallBackResponse publishASyncModelCallBack(GJaxbPublishASyncModelCallBack parameters)
			throws FaultMessage {
		try {
			GJaxbGetResult result = new GJaxbGetResult();
			result.setWebsocketId(parameters.getRequestTopicId());
			result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement(parameters));

			wEB_SOCKET_COMMAND.getResult(result);
		} catch (Exception e) {
			e.printStackTrace();
			throw new FaultMessage(e.getMessage(), null, e);
		}

		return new GJaxbPublishASyncModelCallBackResponse();
	}

	@Override
	public GJaxbCloneASyncModelFromStatusCallBackResponse cloneASyncModelFromStatusCallBack(
			GJaxbCloneASyncModelFromStatusCallBack parameters) throws FaultMessage {
		throw new FaultMessage("Not Implemented !!", null);
	}

	@Override
	public GJaxbSendCallbackErrorResponse sendCallbackError(GJaxbSendCallbackError parameters) {
		LOG.error("request topic id: " + parameters.getRequestTopicId());
		LOG.error("fault message: " + parameters.getFault().getMessage());
		LOG.error("fault stacktrace: " + parameters.getFault().getStacktrace());
		throw new RuntimeException(parameters.getFault().getMessage());
	}

	@Override
	public GJaxbFreezeASyncModelCallBackResponse freezeASyncModelCallBack(GJaxbFreezeASyncModelCallBack parameters)
			throws FaultMessage {
		throw new FaultMessage("Not Implemented !!", null);
	}

	@Override
	public GJaxbExtractASyncModelCallBackResponse extractASyncModelCallBack(GJaxbExtractASyncModelCallBack parameters)
			throws FaultMessage {
		try {
			GJaxbGetResult result = new GJaxbGetResult();
			result.setWebsocketId(parameters.getRequestTopicId());
			result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement(parameters));

			wEB_SOCKET_COMMAND.getResult(result);

		} catch (Exception e) {
			e.printStackTrace();
			throw new FaultMessage(e.getMessage(), null, e);
		}

		return new GJaxbExtractASyncModelCallBackResponse();
	}

}
