/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources.gov;

import java.util.HashMap;
import java.util.Map;

import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.launcher.Configuration;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/user")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class UserResource  {

	private Configuration conf = null;
	private Humantask htClient = null;
	private String callbackAddress = null;

	private CoreGov coreClient = null;
	private ModelsGov modelsClient = null;

	private SystemResource system = null;

	private Map<String, String> subscriptionIDsByAssignedToResourceIds = new HashMap<String, String>();

	public UserResource(Configuration conf, String callbackAddress,
			SystemResource system) throws Exception {
		this.conf = conf;
		this.htClient = HumanTaskClient.createClient(conf.getProperties().get("humantask"));
		this.coreClient = CoreGovClient
				.createClient(conf.getProperties().get("governance").replace("/gov", "/GovCore"));
		this.modelsClient = ModelsGovClient
				.createClient(conf.getProperties().get("governance").replace("/gov", "/GovModels"));
		this.callbackAddress = callbackAddress;
		this.system = system;
	}

//	@POST
//	@Path("/login")
//	public GJaxbLoginResponse login(GJaxbLogin parameters) throws FaultMessage {
//		GJaxbLoginResponse response = new GJaxbLoginResponse();
//		try {
//
//			if (parameters.getToken() != null) {
//				GJaxbNode userNode = this.system.login(null, parameters.getToken());
//
//				parameters.setUserId(userNode.getId());
//			} else {
//				GJaxbNode user = this.system.getUserById(null, parameters.getUserId(), parameters.getUserId());
//				String token = createToken(GenericModelHelper.findProperty("login", user.getProperty()).getValue(),
//						GenericModelHelper.findProperty("password", user.getProperty()).getValue());
//
//				GJaxbNode userNode = this.system.login(null, token);
//
//				parameters.setUserId(userNode.getId());
//			}
//
//			GJaxbSubscribeTasksByAssignedToResource reqSubs = new GJaxbSubscribeTasksByAssignedToResource();
//			reqSubs.getAssignedToIds().add(parameters.getUserId());
//			reqSubs.setTopic(new QName("http://www.gind.emac.fr/HumanTaskTopic", "allHumanTaskTopic"));
//
//			reqSubs.setCallbackAddress(this.callbackAddress);
//			GJaxbSubscribeTasksByAssignedToResourceResponse respSubs = this.htClient.subscribeTasksByAssignedToResource(reqSubs);
//
//			subscriptionIDsByAssignedToResourceIds.put(parameters.getUserId(), respSubs.getSubscriptionId());
//
//			response.setLogged(true);
//		} catch (Exception e) {
//			throw new RestWebApplicationException(e);
//		}
//		return response;
//	}
//
//	private String createToken(String login, String password) {
//		return Base64.getEncoder().encodeToString(new String(login + ":" + password).getBytes());
//	}
//
//	@POST
//	@Path("/logout")
//	public GJaxbLogoutResponse logout(GJaxbLogout parameters) throws FaultMessage {
//		GJaxbLogoutResponse response = new GJaxbLogoutResponse();
//		try {
//
//			GJaxbNode user = this.system.getUserById(null, parameters.getUserId(), parameters.getUserId());
//			DWUser dwUser = new DWUser(user, this.system.getSystemClient());
//			this.system.logout(dwUser);
//
//			String subscriptionId = subscriptionIDsByAssignedToResourceIds.remove(parameters.getUserId());
//			if (subscriptionId != null) {
//				GJaxbUnSubscribeTasksByAssignedToResource reqSubs = new GJaxbUnSubscribeTasksByAssignedToResource();
//				reqSubs.setSubscriptionId(subscriptionId);
//				GJaxbUnSubscribeTasksByAssignedToResourceResponse respSubs = this.htClient.unSubscribeTasksByAssignedToResource(reqSubs);
//			}
//
//			response.setDisconnected(true);
//		} catch (Exception e) {
//			throw new RestWebApplicationException(e);
//		}
//		return response;
//	}
//
//
//	@POST
//	@Path("/getUsers")
//	public GJaxbGetUsersResponse getUsers(GJaxbGetUsers parameters) throws FaultMessage {
//		GJaxbGetUsersResponse response = new GJaxbGetUsersResponse();
//		try {
//			GJaxbGenericModel users = CoreGovClient.singleQuery(this.coreClient,
//					"match (u:`{http://fr.emac.gind/system}User`) return u", null, null);
//
//			for (GJaxbNode u : users.getNode()) {
//				GJaxbUser ue = new GJaxbUser();
//				ue.setUserId(u.getId());
//				ue.setUserName(GenericModelHelper.getName(u));
//				ue.setNode(u);
//
//				if (parameters.getCollaborationName() != null && !parameters.getCollaborationName().isBlank()
//						&& parameters.getKnowledgeSpaceName() != null
//						&& !parameters.getKnowledgeSpaceName().isBlank()) {
//					GJaxbGenericModel organisations = CoreGovClient.singleQuery(this.coreClient,
//							"match (o:`{http://fr.emac.gind/system}Collaboration`) where o.property_Manager contains '"
//									+ u.getId() + "' return o",
//							parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
//
//					if (organisations != null && organisations.getNode() != null) {
//						for (GJaxbNode organisation : organisations.getNode()) {
//							ManagedOrganisation mo = new ManagedOrganisation();
//							mo.setOrganisationId(organisation.getId());
//							mo.setOrganisationName(GenericModelHelper.getName(organisation));
//							ue.getManagedOrganisation().add(mo);
//						}
//					}
//				}
//				response.getUser().add(ue);
//			}
//		} catch (Exception e) {
//			throw new RestWebApplicationException(e);
//		}
//		return response;
//	}

	

}
