/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources.gov.bo;

import java.util.ArrayList;
import java.util.List;

import fr.emac.gind.modeler.genericmodel.GJaxbProperty;

public class FindParameters extends GJaxbProperty {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  private String operator = null;
  
  public FindParameters() {
    this.operator = "equals";
  }

  public String getOperator() {
    return operator;
  }

  public void setOperator(String operator) {
    this.operator = operator;
  }
  
  
  public static List<FindParameters> convertProperties(List<GJaxbProperty> properties) {
    List<FindParameters> parameters = new ArrayList<FindParameters>();
    for(GJaxbProperty prop: properties) {
      FindParameters param = new FindParameters();
      param.setName(prop.getName());
      param.setValue(prop.getValue());
      param.setOperator("equals");
      parameters.add(param);
    }
    return parameters;
  }
  
}
