/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import java.io.File;

import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.application.model.GJaxbApplication;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;

public class ApplicationJson {

	private static Logger LOG = LoggerFactory.getLogger(ApplicationJson.class.getName());


	@Test
	public void testJSON() throws Exception {
		GJaxbApplication app = XMLJAXBContext.getInstance().unmarshallDocument(new File("src/test/resources/test/application.xml").toURI().toURL(), GJaxbApplication.class);
		String json = JSONJAXBContext.getInstance().marshallAnyElement(app);
		LOG.debug("json: \n" + json);
	}


}
