/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;

import javax.xml.namespace.QName;

import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.crypt.MD5;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import io.dropwizard.core.setup.Environment;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class GenericApplicationTest {

	public static void main(String[] args) throws Exception {
		RIOConstant.RESOURCES_FOLDER = "./target/resourcesFolder";
		FileUtils.deleteDirectory(new File("./target/neo4j-db").getCanonicalFile());

		GovernanceWebService collabGovServer = GovernanceWebService.create(10007,
				"http://localhost:10100/StorageService");

		DWApplicationService appService = new DWApplicationService() {

			@Override
			public void doRun(io.dropwizard.core.Configuration configuration, Environment env,
					RestResourceManager resourcesManager) throws Exception {
				// TODO Auto-generated method stub
				fr.emac.gind.modeler.genericmodel.GJaxbNode defaultUser = this
						.createDefaultUser(this.contextResource.getSystem());
				this.getApplicationContext().setCurrentUser(defaultUser);
			}

			private fr.emac.gind.modeler.genericmodel.GJaxbNode createDefaultUser(GJaxbEffectiveMetaModel sysMM)
					throws Exception {
				EffectiveMetaModelManager sysMan = new EffectiveMetaModelManager(sysMM);
				GJaxbEffectiveConceptType userMetaModel = sysMan
						.getConceptByType(new QName("http://fr.emac.gind/system", "User"));

				fr.emac.gind.modeler.genericmodel.GJaxbNode firstUser = GenericModelHelper
						.createNodeFromMetaModel(userMetaModel, true);

				GenericModelHelper.findProperty("firstName", firstUser.getProperty()).setValue("Ken");
				GenericModelHelper.findProperty("lastName", firstUser.getProperty()).setValue("Addams");
				GenericModelHelper.findProperty("name", firstUser.getProperty(), true).setValue("Ken Addams");
				GenericModelHelper.findProperty("name", firstUser.getProperty(), true)
						.setValue(GenericModelHelper.findProperty("firstName", firstUser.getProperty()).getValue() + " "
								+ GenericModelHelper.findProperty("lastName", firstUser.getProperty()).getValue());
				GenericModelHelper.findProperty("email", firstUser.getProperty()).setValue("ka@mines-albi.fr");
				GenericModelHelper.findProperty("password", firstUser.getProperty())
						.setValue("crypto_" + MD5.cryptWithMD5("ka"));
				GenericModelHelper.findProperty("re-password", firstUser.getProperty())
						.setValue("crypto_" + MD5.cryptWithMD5("ka"));
				JSONObject roles = new JSONObject(
						GenericModelHelper.findProperty("roles", firstUser.getProperty()).getValue());
				roles.getJSONObject("admin").put("checked", false);
				roles.getJSONObject("user").put("checked", true);
				GenericModelHelper.findProperty("roles", firstUser.getProperty()).setValue(roles.toString());

				this.systemResource.register(null, firstUser);
				return firstUser;
			}

		};
		appService.boot(new Configuration(
				Thread.currentThread().getContextClassLoader().getResource("conf/config.properties")));

		appService.run(new String[] { "serverWithoutLog",
				new File(appService.getYmlConfig().toURI()).getCanonicalFile().toString() });

	}

}
