/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import fr.emac.gind.commons.utils.security.GindCrypto;


public class GindCryptoTest {
	
	@Test
	public void testEncryptDecryptUser() {
		
		String cryptedMsg = GindCrypto.encrypt("emac81");
		Assertions.assertEquals("Z2luZF9jcnlwdG9fWlcxaFl6Z3g=", cryptedMsg);
		
		String decyptedMsg = GindCrypto.decrypt(cryptedMsg);
		Assertions.assertEquals("emac81", decyptedMsg);
		
	}
	
	@Test
	public void testEncryptDecryptAdmin() {
		
		String cryptedMsg = GindCrypto.encrypt("admin");
		Assertions.assertEquals("Z2luZF9jcnlwdG9fWVdSdGFXND0=", cryptedMsg);
		
		String decyptedMsg = GindCrypto.decrypt(cryptedMsg);
		Assertions.assertEquals("admin", decyptedMsg);
		
	}
 
}
