/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import java.io.IOException;
import java.util.Iterator;

public class GJaxbSerialierModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public GJaxbSerialierModule() {
        this.addDeserializer(GJaxbGenericModel.class, new GJaxbGenericModelDeserializer(this));
        this.addSerializer(GJaxbGenericModel.class, new GJaxbGenericModelSerializer(this));
    }

    public class GJaxbGenericModelDeserializer
    extends JsonDeserializer<GJaxbGenericModel> {
        public GJaxbGenericModelDeserializer(GJaxbSerialierModule this$0) {
        }

        public GJaxbGenericModel deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            GJaxbGenericModel model = new GJaxbGenericModel();
            try {
                JsonNode jsonModel = (JsonNode)jp.getCodec().readTree(jp);
                Iterator nodes = jsonModel.get("node").elements();
                while (nodes.hasNext()) {
                    JsonNode node = (JsonNode)nodes.next();
                    model.getNode().add((GJaxbNode)JSONJAXBContext.getInstance().unmarshall(node.asText(), GJaxbNode.class));
                }
                Iterator edges = jsonModel.get("edge").elements();
                while (edges.hasNext()) {
                    JsonNode edge = (JsonNode)edges.next();
                    model.getEdge().add((GJaxbEdge)JSONJAXBContext.getInstance().unmarshall(edge.asText(), GJaxbEdge.class));
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            return model;
        }
    }

    public class GJaxbGenericModelSerializer
    extends JsonSerializer<GJaxbGenericModel> {
        public GJaxbGenericModelSerializer(GJaxbSerialierModule this$0) {
        }

        public void serialize(GJaxbGenericModel value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            try {
                jgen.writeStartObject();
                jgen.writeStringField("node", JSONJAXBContext.getInstance().marshallAnyElement((Object)value.getNode()));
                jgen.writeStringField("edge", JSONJAXBContext.getInstance().marshallAnyElement((Object)value.getEdge()));
                jgen.writeEndObject();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

