/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="/wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIODataSourceSensorNotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIODataSourceSensorNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;

    public RIODataSourceSensorNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
    }

    public synchronized void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            String address = ((GJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getProducerReference().getAddress().getValue();
            String queryPath = address.replace("http://", "");
            LOG.debug("log event receive from: " + address);
            Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
            JSONObject json = new JSONObject();
            String payload = null;
            if (doc.getDocumentElement().getLocalName().equals("sensorEvent")) {
                GJaxbSensorEvent sensorEvent = (GJaxbSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbSensorEvent.class);
                payload = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)sensorEvent));
            } else {
                payload = XMLCompactPrinter.print((Node)doc.getDocumentElement());
            }
            json.put("log", (Object)payload);
            json.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
            json.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
            json.put("eventId", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "eventId"))).getTextContent());
            if (mapInfo.get(new QName("http://www.gind.emac.fr", "context")) != null) {
                Element elmtContext = (Element)mapInfo.get(new QName("http://www.gind.emac.fr", "context"));
                Element elmtEventIndex = DOMUtil.getInstance().findFirstElementByNs(elmtContext, new QName("http://www.gind.emac.fr", "eventIndex"));
                if (elmtEventIndex != null) {
                    json.put("eventIndex", Integer.parseInt(elmtEventIndex.getTextContent()));
                }
            }
            GJaxbGetResult request = new GJaxbGetResult();
            request.setWebsocketId(queryPath);
            request.setJsonResult(json.toString());
            this.WEB_SOCKET_COMMAND.getResult(request);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

