/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.launcher;

import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.Main;
import fr.emac.gind.storage.launcher.EventStorageLauncher;
import fr.emac.gind.storage.mongodb.launcher.StorageLauncher;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class GenericApplicationLauncher
extends AbstractLauncher {
    private ServiceLoader<DWApplicationService> genericApplicationLoader = ServiceLoader.load(DWApplicationService.class);
    private List<DWApplicationService> genericApplications = new ArrayList<DWApplicationService>();
    private DWApplicationService runner = null;

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        return res.toString();
    }

    public String getName() {
        if (this.runner != null && this.runner.getApplication() != null) {
            return this.runner.getApplication().getTitle();
        }
        return "Gind Generic Application";
    }

    public String getPromptName() {
        return "app";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.genericApplications.clear();
        this.genericApplicationLoader.reload();
        for (DWApplicationService appService : this.genericApplicationLoader) {
            this.genericApplications.add(appService);
        }
        if (this.genericApplications.isEmpty()) {
            throw new Exception("No service found");
        }
        if (this.genericApplications.size() > 1) {
            throw new Exception("Too much services found: " + String.valueOf(this.genericApplications));
        }
        this.runner = this.genericApplications.get(0);
        this.runner.boot(conf);
        this.runner.run(new String[]{"server", new File(this.runner.getYmlConfig().toURI()).getCanonicalFile().toString()});
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI("http://" + this.runner.getConfiguration().getHost() + ":" + this.runner.getConfiguration().getPort() + "/" + this.runner.getName() + this.runner.getShortPath()));
        }
    }

    public void stopRunner() throws Exception {
        this.runner.stop();
    }

    static {
        Main.addLauncherToIgnore(StorageLauncher.class);
        Main.addLauncherToIgnore(EventStorageLauncher.class);
    }
}

