/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.ApplicationContext;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.utils.svg.SVGGenerator;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/{app}/generic-application/context")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DWApplicationContextResource {
    private CoreResource core = null;
    private GJaxbEffectiveMetaModel system = null;
    private GJaxbEffectiveMetaModel uml = null;
    protected ApplicationContext applicationContext = null;

    public DWApplicationContextResource(DWApplicationService dwApplicationService, ApplicationContext applicationContext, Configuration conf, CoreResource core) throws Exception {
        this.applicationContext = applicationContext;
        this.core = core;
        GJaxbMetaModel coreMM = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/core_meta_model/Core_MetaModel.xml"), GJaxbMetaModel.class);
        GJaxbEffectiveMetaModel effCoreMM = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel((GJaxbMetaModel)coreMM);
        DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), effCoreMM, dwApplicationService.getName());
        applicationContext.setCore(effCoreMM);
        GJaxbMetaModel projectMM = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/project/Project_MetaModel.xml"), GJaxbMetaModel.class);
        GJaxbEffectiveMetaModel effProjectMM = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel((GJaxbMetaModel)projectMM);
        DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), effProjectMM, dwApplicationService.getName());
        applicationContext.setProject(effProjectMM);
        GJaxbMetaModel sysMM = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/system/System_MetaModel.xml"), GJaxbMetaModel.class);
        this.system = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel((GJaxbMetaModel)sysMM);
        DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), this.system, dwApplicationService.getName());
        applicationContext.setSystem(this.system);
        GJaxbMetaModel umlMM = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("model/uml_meta_model/UML_MetaModel.xml"), GJaxbMetaModel.class);
        this.uml = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel((GJaxbMetaModel)umlMM);
        DWApplicationContextResource.changeApplicationNameOnEffectiveMetaModel(new SVGGenerator(), this.uml, dwApplicationService.getName());
        applicationContext.setUml(this.uml);
    }

    public GJaxbEffectiveMetaModel getSystem() {
        return this.system;
    }

    @GET
    @Path(value="/applicationContext")
    public String getApplicationContext() throws Exception {
        String res = null;
        try {
            res = this.applicationContext.toJSON().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return res;
    }

    public static void changeApplicationNameOnEffectiveMetaModel(SVGGenerator svgGenerator, GJaxbEffectiveMetaModel effMModel, String applicationName) throws Exception {
        effMModel.getEffectiveConcept().forEach(n -> {
            if (n.isSetNodeMetaModeling() && n.getNodeMetaModeling().isSetModelingViewDefinition() && n.getNodeMetaModeling().getModelingViewDefinition().isSetView()) {
                n.getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(n.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl().trim().replace("##application_name##", applicationName));
                try {
                    svgGenerator.setSizeOnView((GJaxbConceptType)n);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            n.getMetaProperty().forEach(p -> DWApplicationContextResource.changeApplicationNameInProperty(p, applicationName));
        });
        effMModel.getRelation().forEach(e -> {
            if (e.isSetEdgeMetaModeling() && e.getEdgeMetaModeling().getModelingEdgeViewDefinition().isSetIcon()) {
                e.getEdgeMetaModeling().getModelingEdgeViewDefinition().setIcon(e.getEdgeMetaModeling().getModelingEdgeViewDefinition().getIcon().trim().replace("##application_name##", applicationName));
            }
            e.getMetaProperty().forEach(p -> DWApplicationContextResource.changeApplicationNameInProperty(p, applicationName));
        });
    }

    public static void changeApplicationNameInProperty(GJaxbMetaProperty p, String applicationName) {
        if (p.isSetButtons()) {
            p.getButtons().getButton().forEach(b -> {
                if (b.isSetButtonIcon()) {
                    b.setButtonIcon(b.getButtonIcon().trim().replace("##application_name##", applicationName));
                }
            });
        }
        if (p.isSetValues() && p.getValues().isSetFixedValues()) {
            p.getValues().getFixedValues().getValue().forEach(v -> {
                if (v.isSetIcon()) {
                    v.setIcon(v.getIcon().trim().replace("##application_name##", applicationName));
                }
            });
        }
    }
}

