/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.UploadUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.InputStream;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/generic-application/file")
public class FileResource {
    private static Logger LOG = LoggerFactory.getLogger((String)FileResource.class.getName());
    private String applicationName = null;

    public FileResource(String applicationName) {
        this.applicationName = applicationName;
    }

    @GET
    @Path(value="/download")
    public String download(@Auth DWUser user, @QueryParam(value="resourceUrl") String resourceUrl) throws Exception {
        Object validUrl = resourceUrl;
        try {
            if (resourceUrl.indexOf(RIOConstant.WEBJARS_RESOURCES_FOLDER) >= 0) {
                validUrl = resourceUrl.substring(resourceUrl.indexOf(RIOConstant.WEBJARS_RESOURCES_FOLDER) + RIOConstant.WEBJARS_RESOURCES_FOLDER.length(), resourceUrl.length());
                if (resourceUrl.indexOf("share/") >= 0) {
                    validUrl = resourceUrl.substring(resourceUrl.indexOf("share/"));
                    validUrl = RIOConstant.RESOURCES_FOLDER + "/" + (String)validUrl;
                } else {
                    validUrl = ((String)validUrl).contains(RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName())) ? RIOConstant.RESOURCES_FOLDER + "/" + (String)validUrl : RIOConstant.RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()) + "/" + (String)validUrl;
                }
            }
            File rsc = new File((String)validUrl);
            String buffer = null;
            if (rsc.exists()) {
                buffer = FileUtil.getContents((File)rsc);
            }
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
            return validUrl;
        }
    }

    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public String upload(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        LOG.debug("\n\n*************************** upload *******************\n\n");
        String url = null;
        try {
            String collaborationName = null;
            String knowledgeSpaceName = null;
            if (user != null) {
                collaborationName = user.getCurrentCollaborationName();
                knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            }
            String fileName = fileDetail != null ? fileDetail.getFileName() : null;
            url = UploadUtil.upload((String)fileName, (InputStream)is, (JSONObject)(data != null ? new JSONObject(data) : null), (String)collaborationName, (String)knowledgeSpaceName, (String)this.applicationName, (String)(user != null ? user.getUserId() : null));
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return url;
    }
}

