/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.util.query.QueryStructure;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomain;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models.util.ExtractHelper;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatus;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatusResponse;
import fr.emac.gind.gov.models_gov.GJaxbConnexionModeType;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbFreezeSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbFreezeSyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbOptionalParameters;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbPublishMode;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.gov.models_gov.GJaxbPublishSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbPublishUnpublishResultType;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeRequest;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeResponse;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishSyncModel;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.process.mining.improver.ProcessImproversManager;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbAttachment;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.rio.dw.resources.gov.MetaModelsResource;
import fr.emac.gind.rio.dw.resources.gov.RIOGAModelsGovCallBackImpl;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.GJaxbPutResponse;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.GJaxbUpdateResponse;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.usecase.GJaxbModelURLType;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.workflow.deduction.ProcessDeductionHelper;
import fr.emac.gind.workflow.deduction.domain.UsecaseModelManager;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Process;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.bson.Document;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Path(value="/{app}/generic-application/models")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ModelsResource {
    private static Logger LOG = LoggerFactory.getLogger((String)ModelsResource.class.getName());
    private EffectiveMetaModelManager effMM = null;
    private ModelsGov modelsClient = null;
    private CoreGov coreClient = null;
    private Storage storageClient = null;
    private Humantask humanTaskApi = null;
    private MetaModelsResource metaModelsResource = null;
    private Configuration conf = null;
    public static SPIWebServicePrimitives ASYNC_PUBLISH_EXTRACT_CONSUMER = null;
    protected WebsocketCommand wEB_SOCKET_COMMAND = null;

    public ModelsResource(Configuration conf, WebsocketCommand wEB_SOCKET_COMMAND, MetaModelsResource metaModelsResource) throws Exception {
        this.modelsClient = ModelsGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovModels"));
        this.coreClient = CoreGovClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovCore"));
        this.storageClient = StorageClient.createClient((String)((String)conf.getProperties().get("storage")));
        this.humanTaskApi = HumanTaskClient.createClient((String)((String)conf.getProperties().get("humantask")));
        this.conf = conf;
        this.metaModelsResource = metaModelsResource;
        this.wEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        Map allMetaModels = EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromMetaModelByQNameMap();
        this.effMM = new EffectiveMetaModelManager(allMetaModels.values().toArray(new GJaxbEffectiveMetaModel[allMetaModels.values().size()]));
        this.createNotifierASYNC_PUBLISH_EXTRACT_WS();
    }

    public ModelsGov getModelsClient() {
        return this.modelsClient;
    }

    public EffectiveMetaModelManager getEffMM() {
        return this.effMM;
    }

    @POST
    @Path(value="/publishModel")
    public String publishModel(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        String json = null;
        try {
            JSONObject jsonData = new JSONObject(data);
            String viewName = (String)jsonData.get("viewName");
            org.w3c.dom.Document document = DOMUtil.getInstance().parse((InputStream)new BufferedInputStream(is));
            GJaxbGenericModel model = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(document, GJaxbGenericModel.class);
            GJaxbSynchronizeResponse publishResp = this.publish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), model, null, null);
            json = JSONJAXBContext.getInstance().marshallAnyElement((Object)publishResp.getSyncResponse().getPublishSyncModelResponse());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return json;
    }

    @GET
    @Path(value="/query")
    public String queryString(@Auth DWUser user, @QueryParam(value="query") String queryString, @QueryParam(value="category") String category) throws Exception {
        GJaxbGenericModel model = this.query(user, queryString, category);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)model)).getJSONObject("genericModel").toString();
    }

    public GJaxbGenericModel query(@Auth DWUser user, @QueryParam(value="query") String queryString, @QueryParam(value="category") String category) throws Exception {
        fr.emac.gind.gov.core_gov.GJaxbQueryResponse response = null;
        GJaxbGenericModel model = new GJaxbGenericModel();
        try {
            LOG.info("query : " + queryString);
            fr.emac.gind.gov.core_gov.GJaxbQuery query = new fr.emac.gind.gov.core_gov.GJaxbQuery();
            query.setQuery(queryString);
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            if (user != null) {
                query.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                query.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.coreClient.query(query);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        if (response.getSingle() != null) {
            model = response.getSingle().getGenericModel();
        }
        return model;
    }

    @POST
    @Path(value="/synchronize")
    public String synchronize(@Auth Optional<DWUser> userOpt, GJaxbSynchronizeRequest model) throws Exception {
        try {
            if (!model.isPublish() && !model.isExtract()) {
                throw new Exception("You must publish and/or extract !!!!");
            }
            GJaxbGenericModel gjaxbModel = null;
            if (model.isPublish()) {
                gjaxbModel = (GJaxbGenericModel)JSONJAXBContext.getInstance().unmarshall(model.getJsonModel(), GJaxbGenericModel.class);
                LOG.debug("add model: ");
            }
            DWUser user = null;
            if (userOpt.isPresent()) {
                user = userOpt.get();
            }
            String collaborationName = null;
            String knowledgeSpaceName = null;
            if (user != null) {
                collaborationName = user.getCurrentCollaborationName();
                knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            }
            if (model.isSetSelectedKnowledgeSpace() && model.getSelectedKnowledgeSpace().getCollaborationName() != null && model.getSelectedKnowledgeSpace().getKnowledgeName() != null) {
                collaborationName = model.getSelectedKnowledgeSpace().getCollaborationName();
                knowledgeSpaceName = model.getSelectedKnowledgeSpace().getKnowledgeName();
            }
            GJaxbSynchronizeResponse response = this._synchronize(user, gjaxbModel, model.getEffectivePackage(), model.getDomain(), model.getExtractionStatus(), model.isPublish(), model.isExtract(), model.getOptionalParameters(), model.getLabel(), collaborationName, knowledgeSpaceName);
            return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)response)).get("synchronizeResponse").toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    @PUT
    @Path(value="/deleteModels")
    public GJaxbPublishUnpublishResultType deleteModels(@Auth DWUser user, List<GJaxbSynchronizeRequest> models) throws Exception {
        assert (user != null);
        GJaxbPublishUnpublishResultType response = new GJaxbPublishUnpublishResultType();
        response.setNodesId(new GJaxbPublishUnpublishResultType.NodesId());
        response.setEdgesId(new GJaxbPublishUnpublishResultType.EdgesId());
        try {
            for (GJaxbSynchronizeRequest model : models) {
                GJaxbGenericModel gjaxbModel = (GJaxbGenericModel)JSONJAXBContext.getInstance().unmarshall(model.getJsonModel(), GJaxbGenericModel.class);
                GJaxbPublishUnpublishResultType resp = this.unpublish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), gjaxbModel, model.getOptionalParameters(), model.getLabel());
                if (resp == null) continue;
                if (resp.getNodesId() != null) {
                    response.getNodesId().getId().addAll(resp.getNodesId().getId());
                }
                if (resp.getEdgesId() == null) continue;
                response.getEdgesId().getId().addAll(resp.getEdgesId().getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/addModelsFromURL")
    public List<GJaxbSynchronizeResponse> addModelsFromURL(@Auth Optional<DWUser> user, List<GJaxbModelURLType> modelsByUrl) throws Exception {
        assert (user != null);
        ArrayList<GJaxbSynchronizeResponse> response = new ArrayList<GJaxbSynchronizeResponse>();
        try {
            for (GJaxbModelURLType mu : modelsByUrl) {
                GJaxbSynchronizeRequest m = new GJaxbSynchronizeRequest();
                GJaxbGenericModel gjaxbModel = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(mu.getUrl()).toURL(), GJaxbGenericModel.class);
                for (GJaxbNode n : gjaxbModel.getNode()) {
                    if (!n.getType().getNamespaceURI().contains("${collab}")) continue;
                    QName newType = new QName(n.getType().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)user.get().getCurrentCollaborationName())), n.getType().getLocalPart());
                    n.setType(newType);
                }
                if (mu.isIsReference()) {
                    for (GJaxbNode node : gjaxbModel.getNode()) {
                        node.getStatus().remove(GJaxbStatusType.ACTIVE);
                        node.getStatus().remove(GJaxbStatusType.FREEZE);
                        node.getStatus().add(GJaxbStatusType.REFERENCE);
                    }
                }
                if (mu.isIsSharedResource()) {
                    for (GJaxbNode node : gjaxbModel.getNode()) {
                        node.getStatus().add(GJaxbStatusType.SHARE);
                    }
                }
                m.setJsonModel(JSONJAXBContext.getInstance().marshallAnyElement((Object)gjaxbModel));
                m.getExtractionStatus().add(mu.getStatus());
                m.setOptionalParameters(new GJaxbOptionalParameters());
                m.getOptionalParameters().setPublication(new GJaxbOptionalParameters.Publication());
                m.getOptionalParameters().getPublication().setMode(GJaxbConnexionModeType.SYNC);
                m.getOptionalParameters().getPublication().setPublishOptions(new GJaxbPublishOptions());
                m.getOptionalParameters().getPublication().getPublishOptions().setNotification(new GJaxbNotification());
                m.getOptionalParameters().getPublication().getPublishOptions().getNotification().setActivateNotification(false);
                m.getOptionalParameters().getPublication().getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
                m.getOptionalParameters().getPublication().getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
                m.setPublish(true);
                m.setExtract(false);
                response.add((GJaxbSynchronizeResponse)JSONJAXBContext.getInstance().unmarshall(this.synchronize(user, m), GJaxbSynchronizeResponse.class));
            }
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    private synchronized GJaxbSynchronizeResponse _synchronize(DWUser user, GJaxbGenericModel model, QName effectivePackageName, String domain, List<GJaxbStatusType> status, boolean publish, boolean extract, GJaxbOptionalParameters optionalParameters, List<String> labels, String collaborationName, String knowledgeSpaceName) throws Exception {
        GJaxbSynchronizeResponse synchronizeResp = new GJaxbSynchronizeResponse();
        GJaxbSynchronizeResponse publishSynchronizeResp = null;
        GJaxbSynchronizeResponse extractSynchronizeResp = null;
        if (!(!publish || model == null || model.getNode().isEmpty() && model.getEdge().isEmpty())) {
            publishSynchronizeResp = this.publish(collaborationName, knowledgeSpaceName, model, labels, optionalParameters);
        }
        if (extract) {
            extractSynchronizeResp = this.extraction(collaborationName, knowledgeSpaceName, effectivePackageName, domain, status, null, labels, optionalParameters);
            if ((optionalParameters == null || optionalParameters.isSetExtraction() && optionalParameters.getExtraction().getMode().equals((Object)GJaxbConnexionModeType.SYNC)) && extractSynchronizeResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel() != null) {
                this.postTreatmentsUsingInterceptors(collaborationName, knowledgeSpaceName, model, extractSynchronizeResp.getSyncResponse().getExtractSyncModelResponse());
                GJaxbGenericModel processModel = extractSynchronizeResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel();
                if (optionalParameters != null && optionalParameters.isActivateProcessMining()) {
                    GJaxbNode project = ProcessDeductionHelper.getInstance().findProject(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), this.coreClient);
                    Map context = this.conf.getMapObjects();
                    ProcessImproversManager pmm = new ProcessImproversManager(context, this.coreClient, this.modelsClient, this.effMM);
                    UsecaseModelManager usecaseManager = new UsecaseModelManager(this.coreClient, this.modelsClient, this.humanTaskApi, user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), project);
                    Process process = Process.buildFromGenericModel((GJaxbGenericModel)processModel, (UsecaseModelManager)usecaseManager);
                    process = pmm.improveOnlyWithSelectImprovers(process, optionalParameters.getSelectedImprovers(), project, collaborationName, knowledgeSpaceName, usecaseManager);
                    processModel = process.getGenericModel();
                }
                extractSynchronizeResp.getSyncResponse().getExtractSyncModelResponse().setGenericModel(processModel);
            }
        }
        if (publishSynchronizeResp != null) {
            if (publishSynchronizeResp.isSetSyncResponse()) {
                synchronizeResp.setSyncResponse(new GJaxbSynchronizeResponse.SyncResponse());
                synchronizeResp.getSyncResponse().setPublishSyncModelResponse(publishSynchronizeResp.getSyncResponse().getPublishSyncModelResponse());
            } else {
                synchronizeResp.setAsyncResponse(new GJaxbSynchronizeResponse.AsyncResponse());
                synchronizeResp.getAsyncResponse().setPublishASyncModelResponse(publishSynchronizeResp.getAsyncResponse().getPublishASyncModelResponse());
            }
        }
        if (extractSynchronizeResp != null) {
            if (extractSynchronizeResp.isSetSyncResponse()) {
                if (!synchronizeResp.isSetSyncResponse()) {
                    synchronizeResp.setSyncResponse(new GJaxbSynchronizeResponse.SyncResponse());
                }
                synchronizeResp.getSyncResponse().setExtractSyncModelResponse(extractSynchronizeResp.getSyncResponse().getExtractSyncModelResponse());
            } else {
                if (!synchronizeResp.isSetAsyncResponse()) {
                    synchronizeResp.setAsyncResponse(new GJaxbSynchronizeResponse.AsyncResponse());
                }
                synchronizeResp.getAsyncResponse().setExtractASyncModelResponse(extractSynchronizeResp.getAsyncResponse().getExtractASyncModelResponse());
            }
        }
        return synchronizeResp;
    }

    public GJaxbSynchronizeResponse publish(final String collaborationName, final String knowledgSpaceName, GJaxbGenericModel model, List<String> labels, GJaxbOptionalParameters optionalParameters) throws Exception {
        GJaxbSynchronizeResponse response = new GJaxbSynchronizeResponse();
        GJaxbPublishSyncModel publishReq = new GJaxbPublishSyncModel();
        publishReq.setGenericModel(model);
        publishReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        publishReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        publishReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgSpaceName);
        if (optionalParameters != null && optionalParameters.getPublication() != null && optionalParameters.getPublication().isSetPublishOptions()) {
            publishReq.setPublishOptions(optionalParameters.getPublication().getPublishOptions());
        }
        if (!publishReq.isSetPublishOptions()) {
            publishReq.setPublishOptions(new GJaxbPublishOptions());
            publishReq.getPublishOptions().setPublishMode(GJaxbPublishMode.fromValue((String)((String)this.conf.getProperties().get("publish-mode"))));
            if (GJaxbPublishMode.BASH_TRANSACTION.equals((Object)publishReq.getPublishOptions().getPublishMode())) {
                publishReq.getPublishOptions().setBashOptions(new GJaxbPublishOptions.BashOptions());
                publishReq.getPublishOptions().getBashOptions().setLotSize(Integer.valueOf((String)this.conf.getProperties().get("publish-lot-size")).intValue());
            }
        }
        if (labels != null) {
            publishReq.getPublishOptions().getLabel().addAll(labels);
            if (labels.contains("concept")) {
                EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgSpaceName, null);
            }
        }
        try {
            if (optionalParameters == null || optionalParameters.isSetPublication() && optionalParameters.getPublication().getMode().equals((Object)GJaxbConnexionModeType.SYNC)) {
                GJaxbPublishUnpublishResultType publishResp = this.modelsClient.publishSyncModel(publishReq);
                response.setSyncResponse(new GJaxbSynchronizeResponse.SyncResponse());
                response.getSyncResponse().setPublishSyncModelResponse(publishResp);
                if (labels != null && labels.contains(CoreGovImpl.DEFAULT_CONCEPT_NODE_LABEL)) {
                    ExecutorService service = Executors.newSingleThreadExecutor();
                    service.execute(new Runnable(){
                        final /* synthetic */ ModelsResource this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            GJaxbExtractSyncEffectiveDomain extractEffMM = new GJaxbExtractSyncEffectiveDomain();
                            extractEffMM.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                            extractEffMM.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                            extractEffMM.getSelectedKnowledgeSpace().setKnowledgeName(knowledgSpaceName);
                            try {
                                this.this$0.metaModelsResource.extractSyncEffectiveDomain(null, extractEffMM);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            } else {
                GJaxbPublishASyncModel asyncPublishReq = new GJaxbPublishASyncModel();
                String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("async-publish-extract-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/ASyncPublishExtractNotifierClient");
                asyncPublishReq.setCallbackAddress(notifierClientAddress);
                asyncPublishReq.setRequestTopicId(optionalParameters.getPublication().getTopicId());
                asyncPublishReq.setPublishSyncModel(publishReq);
                GJaxbPublishASyncModelResponse publishResp = this.modelsClient.publishASyncModel(asyncPublishReq);
                response.setAsyncResponse(new GJaxbSynchronizeResponse.AsyncResponse());
                response.getAsyncResponse().setPublishASyncModelResponse(publishResp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return response;
    }

    public GJaxbPublishUnpublishResultType unpublish(String collaborationName, String knowledgSpaceName, GJaxbGenericModel model, GJaxbOptionalParameters gJaxbOptionalParameters, List<String> labels) throws Exception {
        GJaxbPublishUnpublishResultType publishResp = null;
        GJaxbUnpublishSyncModel unpublishReq = new GJaxbUnpublishSyncModel();
        unpublishReq.setGenericModel(model);
        unpublishReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        unpublishReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        unpublishReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgSpaceName);
        if (gJaxbOptionalParameters != null) {
            unpublishReq.setPublishOptions(gJaxbOptionalParameters.getPublication().getPublishOptions());
        }
        if (labels != null) {
            if (unpublishReq.getPublishOptions() == null) {
                unpublishReq.setPublishOptions(new GJaxbPublishOptions());
            }
            unpublishReq.getPublishOptions().getLabel().addAll(labels);
        }
        publishResp = this.modelsClient.unpublishSyncModel(unpublishReq);
        return publishResp;
    }

    public GJaxbExtractSyncModelResponse extraction(DWUser user, List<QName> conceptTypes, List<QName> relationTypes, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels) throws Exception {
        GJaxbExtractSyncModelResponse extractResp = null;
        GJaxbExtractSyncModel extractReq = new GJaxbExtractSyncModel();
        extractReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        extractReq.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
        extractReq.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
        extractReq.setExtractionQuery(new GJaxbExtractSyncModel.ExtractionQuery());
        GJaxbEffectiveMetaModel effMetaModel = new GJaxbEffectiveMetaModel();
        conceptTypes.forEach(t -> {
            GJaxbEffectiveConceptType c = new GJaxbEffectiveConceptType();
            c.setType(t);
            effMetaModel.getEffectiveConcept().add(c);
        });
        relationTypes.forEach(t -> {
            GJaxbRelation r = new GJaxbRelation();
            r.setType(t);
            effMetaModel.getRelation().add(r);
        });
        extractReq.getExtractionQuery().setQuery(QueryStructure.union((List)ExtractHelper.getInstance().createModelExtractionQueryFromMetaModelByType(effMetaModel, user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), status, exclusionStatus, labels)));
        if (labels != null && !labels.isEmpty()) {
            extractReq.getLabel().addAll(labels);
        }
        extractResp = this.modelsClient.extractSyncModel(extractReq);
        return extractResp;
    }

    public GJaxbSynchronizeResponse extraction(String collaborationName, String knowledgeSpaceName, QName effectivePackageName, String domain, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels, GJaxbOptionalParameters optionalParameters) throws Exception {
        GJaxbSynchronizeResponse response = new GJaxbSynchronizeResponse();
        GJaxbExtractSyncModel extractReq = new GJaxbExtractSyncModel();
        extractReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        extractReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        extractReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        extractReq.setExtractionQuery(new GJaxbExtractSyncModel.ExtractionQuery());
        if (effectivePackageName != null) {
            extractReq.getExtractionQuery().setPackage(effectivePackageName);
        }
        if (domain != null) {
            extractReq.getExtractionQuery().setDomain(domain);
        }
        extractReq.getStatus().addAll(status);
        if (exclusionStatus != null && !exclusionStatus.isEmpty()) {
            extractReq.getExclusionStatus().addAll(exclusionStatus);
        }
        if (labels != null && !labels.isEmpty()) {
            extractReq.getLabel().addAll(labels);
        }
        try {
            if (optionalParameters == null || optionalParameters.isSetExtraction() && optionalParameters.getExtraction().getMode() != null && optionalParameters.getExtraction().getMode().equals((Object)GJaxbConnexionModeType.SYNC)) {
                GJaxbExtractSyncModelResponse extractResp = this.modelsClient.extractSyncModel(extractReq);
                response.setSyncResponse(new GJaxbSynchronizeResponse.SyncResponse());
                response.getSyncResponse().setExtractSyncModelResponse(extractResp);
            } else {
                GJaxbExtractASyncModel asyncExtractReq = new GJaxbExtractASyncModel();
                String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("async-publish-extract-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/ASyncPublishExtractNotifierClient");
                asyncExtractReq.setCallbackAddress(notifierClientAddress);
                asyncExtractReq.setRequestTopicId(optionalParameters.getExtraction().getTopicId());
                asyncExtractReq.setExtractSyncModel(extractReq);
                GJaxbExtractASyncModelResponse extractResp = this.modelsClient.extractASyncModel(asyncExtractReq);
                response.setAsyncResponse(new GJaxbSynchronizeResponse.AsyncResponse());
                response.getAsyncResponse().setExtractASyncModelResponse(extractResp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return response;
    }

    private void postTreatmentsUsingInterceptors(final String collaborationName, final String knowledgeSpaceName, final GJaxbGenericModel model, GJaxbExtractSyncModelResponse extractResp) throws Exception {
        if (model != null && model.getAttachment() != null && !model.getAttachment().isEmpty()) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(new Runnable(){
                final /* synthetic */ ModelsResource this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    GJaxbPut request = new GJaxbPut();
                    request.setCollection(collaborationName + "__" + knowledgeSpaceName + "__attachements");
                    GJaxbUpdate updateRequest = new GJaxbUpdate();
                    updateRequest.setCollection(collaborationName + "__" + knowledgeSpaceName + "__attachements");
                    String json = null;
                    try {
                        for (GJaxbAttachment attachment : model.getAttachment()) {
                            attachment.setId(attachment.getId().replace("\\", "/"));
                            String query = "{\n   \"attachment.id\" : \"" + attachment.getId() + "\" \n}";
                            GJaxbQuery queryRequest = new GJaxbQuery();
                            queryRequest.setCollection(collaborationName + "__" + knowledgeSpaceName + "__attachements");
                            queryRequest.setQuery(query);
                            GJaxbQueryResponse queryResponse = this.this$0.storageClient.query(queryRequest);
                            json = JSONJAXBContext.getInstance().marshallAnyElement((Object)attachment);
                            String document = "<jgind:json xmlns:jgind=\"http://www.gind.emac.fr/json\"><![CDATA[" + json + "]]></jgind:json>";
                            org.w3c.dom.Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes("UTF-8")));
                            if (queryResponse.getAny() != null && queryResponse.getAny().isEmpty()) {
                                request.setAny((Object)doc.getDocumentElement());
                                GJaxbPutResponse gJaxbPutResponse = this.this$0.storageClient.put(request);
                                continue;
                            }
                            Element foundattach = (Element)queryResponse.getAny().get(0);
                            Document docA = Document.parse((String)foundattach.getTextContent());
                            String id = docA.get((Object)"_id").toString();
                            updateRequest.setId(id);
                            updateRequest.setAny((Object)doc.getDocumentElement());
                            GJaxbUpdateResponse gJaxbUpdateResponse = this.this$0.storageClient.update(updateRequest);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Impossible to add attchment : " + json + "\n in model");
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @POST
    @Path(value="/freeze")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String freeze(@Auth DWUser user, Map<String, Object> jsonObject) throws Exception {
        assert (user != null);
        GJaxbFreezeSyncModelResponse freezeResp = new GJaxbFreezeSyncModelResponse();
        try {
            Object modelString = jsonObject.get("model");
            GJaxbGenericModel oldModel = null;
            if (modelString != null && modelString.equals("null")) {
                modelString = null;
            }
            oldModel = ModelsResource.convertModel((String)modelString);
            GJaxbFreezeSyncModel freezeReq = new GJaxbFreezeSyncModel();
            freezeReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            freezeReq.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            freezeReq.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            freezeResp = this.modelsClient.freezeSyncModel(freezeReq);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return JSONJAXBContext.getInstance().marshallAnyElement((Object)freezeResp);
    }

    public static GJaxbGenericModel convertModel(String modelString) throws Exception {
        GJaxbGenericModel oldModel = null;
        oldModel = modelString != null ? (GJaxbGenericModel)JSONJAXBContext.getInstance().unmarshall("{ \"genericModel\" : " + modelString + "}", GJaxbGenericModel.class) : new GJaxbGenericModel();
        return oldModel;
    }

    @POST
    @Path(value="/cloneModelFromStatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCloneSyncModelFromStatusResponse cloneModelFromStatus(@Auth DWUser user, GJaxbCloneSyncModelFromStatus request) throws Exception {
        assert (user != null);
        GJaxbCloneSyncModelFromStatusResponse response = new GJaxbCloneSyncModelFromStatusResponse();
        try {
            request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            response = this.modelsClient.cloneSyncModelFromStatus(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    public static GJaxbEffectiveMetaModel convertMetaModel(String metaModelString) throws Exception {
        GJaxbEffectiveMetaModel oldModel = (GJaxbEffectiveMetaModel)JSONJAXBContext.getInstance().unmarshall("{ \"effectiveMetaModel\" : " + metaModelString + "}", GJaxbEffectiveMetaModel.class);
        return oldModel;
    }

    public CoreGov getCoreClient() {
        return this.coreClient;
    }

    private void createNotifierASYNC_PUBLISH_EXTRACT_WS() throws Exception {
        if (ASYNC_PUBLISH_EXTRACT_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("async-publish-extract-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/ASyncPublishExtractNotifierClient");
            ASYNC_PUBLISH_EXTRACT_CONSUMER = new SPIWebServicePrimitives(){

                public void onInit(Map<String, Object> context) throws RuntimeException {
                    this.registerWSImplementation("ASyncPublishExtractNotifierClient", new RIOGAModelsGovCallBackImpl(ModelsResource.this.wEB_SOCKET_COMMAND));
                }
            };
            ASYNC_PUBLISH_EXTRACT_CONSUMER.start((Map)new HashMap<String, Object>(){
                {
                    this.put("host", ModelsResource.this.conf.getProperties().get("host"));
                    this.put("port", ModelsResource.this.conf.getProperties().get("async-publish-extract-notifier-port"));
                }
            });
        }
    }
}

