/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.commons.gis.DistanceTimeMatrixManager;
import fr.emac.gind.commons.gis.GlobalDistanceTimeMatrices;
import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.excel.ExcelModelReader;
import fr.emac.gind.commons.utils.excel.ExcelModelWriter;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.GZipUtil;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.XMLNSCleaner;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.distance.data.GJaxbDistanceTimeMatrix;
import fr.emac.gind.dsl.kpil.IndicatorManager;
import fr.emac.gind.game_master.GameMasterApi;
import fr.emac.gind.game_master.GameMasterManagerClient;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenario;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenarios;
import fr.emac.gind.game_master.data.GJaxbExportGameScenarios;
import fr.emac.gind.game_master.data.GJaxbExportGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbGameScenario;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.generic.application.utils.LoadedUsecase;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectory;
import fr.emac.gind.gov.ai_chatbot.GJaxbRestoreRAGFromDirectoryResponse;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomain;
import fr.emac.gind.gov.meta_models_gov.GJaxbExtractSyncEffectiveDomainResponse;
import fr.emac.gind.gov.meta_models_gov.GJaxbPublishSyncEffectiveDomain;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeRequest;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeResponse;
import fr.emac.gind.gov.system_gov.GJaxbAddKnowledgeSpace;
import fr.emac.gind.gov.system_gov.GJaxbAddKnowledgeSpaceResponse;
import fr.emac.gind.gov.system_gov.GJaxbConnectUserToCollaboration;
import fr.emac.gind.gov.system_gov.GJaxbFindKnowledgeSpacesByUserAndCollaboration;
import fr.emac.gind.gov.system_gov.GJaxbGetKnowledgeSpace;
import fr.emac.gind.gov.system_gov.GJaxbGetKnowledgeSpaceByNameInCollaboration;
import fr.emac.gind.gov.system_gov.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.gov.system_gov.GJaxbUpdateKnowledgeSpace;
import fr.emac.gind.gov.system_gov.GJaxbUpdateUser;
import fr.emac.gind.indicators.Indicator;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.ll.LLManager;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRules;
import fr.emac.gind.modeler.metamodel.GJaxbContainmentRule;
import fr.emac.gind.modeler.metamodel.GJaxbDomain;
import fr.emac.gind.modeler.metamodel.GJaxbDomainDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbEffectivePackage;
import fr.emac.gind.modeler.metamodel.GJaxbFormtypeType;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbPackage;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.modeler.metamodel.GJaxbRules;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.svg.SVGGenerator;
import fr.emac.gind.process.GJaxbDeployResult;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.dw.resources.gov.AIChatbotResource;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.InterpretationRulesResource;
import fr.emac.gind.rio.dw.resources.gov.MetaModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.rio.dw.resources.gov.SensorManagerResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.ExportProjectRequest;
import fr.emac.gind.rio.dw.resources.gov.bo.ProcessListResponse;
import fr.emac.gind.sensors.controler.data.GJaxbSensorControlerBackup;
import fr.emac.gind.sensors.manager.SensorManager;
import fr.emac.gind.sensors.manager.SensorManagerClient;
import fr.emac.gind.sensors.manager.data.GJaxbBackupTimeSeriesDB;
import fr.emac.gind.sensors.manager.data.GJaxbBackupTimeSeriesDBResponse;
import fr.emac.gind.sensors.manager.data.GJaxbCreateSensor;
import fr.emac.gind.sensors.manager.data.GJaxbRestoreTimeSeriesDB;
import fr.emac.gind.usecase.GJaxbCompleteUsecaseDefinition;
import fr.emac.gind.usecase.GJaxbLocationType;
import fr.emac.gind.usecase.GJaxbModelURLType;
import fr.emac.gind.usecase.GJaxbResourceType;
import fr.emac.gind.usecase.GJaxbResourceURLType;
import fr.emac.gind.usecase.GJaxbShortUsecaseDefinitionType;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.usecases.RIOUsecasesManager;
import io.dropwizard.auth.Auth;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.eclipse.persistence.internal.oxm.ByteArrayDataSource;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@jakarta.ws.rs.Path(value="/{app}/r-ioga/projects")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProjectResource {
    private static Logger LOG = LoggerFactory.getLogger(ProjectResource.class);
    private Configuration conf = null;
    private String applicationName = null;
    private MetaModelsResource metaModel = null;
    private CoreResource core = null;
    private ModelsResource models = null;
    private SystemResource system = null;
    private ProcessResource process = null;
    private SensorManagerResource sensorManagerResource = null;
    private InterpretationRulesResource interpretationRules = null;
    private AIChatbotResource aichatBotResource = null;
    private GJaxbEffectiveMetaModel projectEffectiveModeler = null;
    private GameMasterApi gmClient = null;
    private SensorManager sensorManagerClient = null;
    private static final String CACHE_MATRIX_PATH = "distance_time_cache_matrix/matrix.xml";
    private static final String INTERPRETATION_RULES_FOLDER = "interpretation_rules";
    public static Map<String, LoadedUsecase> USECASES_ALREADY_LOADED = new HashMap<String, LoadedUsecase>();
    public static String REALWORLD_UC_NAME = "RealWorld";
    public static String WORLD_COLLABORATION_NAME = "World";
    public static GJaxbNode REALWORLD_UC_NODE = null;
    public static GJaxbNode WORLD_COLLABORATION_NODE = null;

    public ProjectResource(Configuration conf, String applicationName, SystemResource system, MetaModelsResource metaModel, CoreResource coreResource, ModelsResource models, ProcessResource process, SensorManagerResource eventProducerAgentResource, InterpretationRulesResource interpretationRules, AIChatbotResource aichatBotResource, GJaxbEffectiveMetaModel projectEffectiveModeler) throws Exception {
        this.conf = conf;
        this.system = system;
        this.metaModel = metaModel;
        this.core = coreResource;
        this.models = models;
        this.process = process;
        this.aichatBotResource = aichatBotResource;
        this.interpretationRules = interpretationRules;
        this.sensorManagerResource = eventProducerAgentResource;
        this.projectEffectiveModeler = projectEffectiveModeler;
        this.applicationName = applicationName;
        this.gmClient = GameMasterManagerClient.createClient((String)((String)conf.getProperties().get("game-master-server")));
        this.sensorManagerClient = SensorManagerClient.createClient((String)((String)conf.getProperties().get("sensor-manager-server")));
        SVGGenerator svgGen = new SVGGenerator();
        for (GJaxbEffectivePackage effPack : EffectiveMetaModelPluginManager.getInstance().getUmlEffectiveDomain().getEffectivePackage()) {
            for (GJaxbRelation relation : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRelation()) {
                DWApplicationService.generateIcon(svgGen, relation, "uml", null);
            }
        }
        for (GJaxbRelation relation : EffectiveMetaModelPluginManager.getInstance().getUmlEffectiveDomain().getGlobalEffectiveMetaModel().getEffectiveMetaModel().getRelation()) {
            DWApplicationService.generateIcon(svgGen, relation, "uml", null);
        }
        String loadPredefinedUsecases = (String)conf.getProperties().get("load-predefined-usecases");
        if (loadPredefinedUsecases != null) {
            JSONArray predefineducs = new JSONArray(loadPredefinedUsecases);
            for (int i = 0; i < predefineducs.length(); ++i) {
                JSONObject preduc = predefineducs.getJSONObject(i);
                String collaborationName = preduc.getString("collaborationName");
                if (collaborationName == null || collaborationName.isBlank()) {
                    throw new Exception("CollaborationName not defined !!!");
                }
                String knownledgeSpaceName = preduc.getString("knowledgeSpaceName");
                if (knownledgeSpaceName == null || knownledgeSpaceName.isBlank()) {
                    throw new Exception("knownledgeSpaceName not defined !!!");
                }
                String idUsecase = "_c__" + collaborationName + "_k__" + knownledgeSpaceName;
                if (USECASES_ALREADY_LOADED.get(idUsecase) != null) continue;
                GJaxbNode uc_collab = SystemResource.createCollaboration(collaborationName, system.getSystemClient(), system.getCollaborationMetaModel());
                DWUser defaultAdmin = new DWUser(SystemResource.getDEFAULT_ADMIN(), true, this.system.getSystemClient());
                GJaxbConnectUserToCollaboration reqConn = new GJaxbConnectUserToCollaboration();
                reqConn.setCollaborationId(uc_collab.getId());
                reqConn.setUserId(SystemResource.getDEFAULT_ADMIN().getId());
                this.system.connectUserToCollaboration(defaultAdmin, reqConn);
                GJaxbNode fakeUserNode = new GJaxbNode();
                if (SystemResource.getDEFAULT_ADMIN() != null) {
                    fakeUserNode = SystemResource.getDEFAULT_ADMIN();
                }
                DWUser fakeUser = new DWUser(fakeUserNode, true, this.system.getSystemClient());
                fakeUser.setCurrentCollaborationName(collaborationName);
                fakeUser.setCurrentKnowledgeSpaceName(knownledgeSpaceName);
                RIOAbstractProject founduc = null;
                Optional<RIOAbstractProject> opfounduc = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).getEmbeddedUsecases().stream().filter(uc -> uc.getUsecaseDef().getName().equals(knownledgeSpaceName)).findFirst();
                if (opfounduc != null && opfounduc.isPresent()) {
                    founduc = opfounduc.get();
                }
                if (founduc == null) {
                    LOG.info("Not embedded usecase... try to download...");
                    Optional<GJaxbShortUsecaseDefinitionType> downloaducS = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).getDownloadUsecases().stream().filter(uc -> uc.getName().equals(knownledgeSpaceName)).findFirst();
                    if (downloaducS != null && downloaducS.isPresent()) {
                        founduc = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).download(downloaducS.get());
                        LOG.info("predefined usecase downloaded");
                    }
                    if (founduc == null) {
                        throw new Exception("Impossible to found uc '" + knownledgeSpaceName + "' in list: " + String.valueOf(RIOUsecasesManager.getInstance((String)this.conf.getVersion()).getEmbeddedUsecases().stream().map(uc -> uc.getUsecaseDef().getName())));
                    }
                }
                GJaxbNode uc_kn = this.loadProject(founduc, fakeUser.getCurrentCollaborationName(), fakeUser.getCurrentKnowledgeSpaceName(), fakeUser, false, false, new ArrayList<String>(), false);
                USECASES_ALREADY_LOADED.put(idUsecase, new LoadedUsecase(uc_collab, uc_kn));
                if (REALWORLD_UC_NAME.equals(knownledgeSpaceName)) {
                    REALWORLD_UC_NODE = uc_kn;
                }
                if (WORLD_COLLABORATION_NAME.equals(collaborationName)) {
                    WORLD_COLLABORATION_NODE = uc_collab;
                }
                GJaxbAddKnowledgeSpace req = new GJaxbAddKnowledgeSpace();
                req.setNode(uc_kn);
                req.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                req.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                req.getSelectedKnowledgeSpace().setKnowledgeName(knownledgeSpaceName);
                GJaxbAddKnowledgeSpaceResponse resp = this.system.getSystemClient().addKnowledgeSpace(req);
                uc_kn.setId(resp.getId());
                this.system.attachKnowledgeSpaceToCollaboration(fakeUser, uc_kn.getId(), GenericModelHelper.getName((GJaxbNode)uc_kn), collaborationName);
                if (!REALWORLD_UC_NAME.equals(knownledgeSpaceName)) continue;
                Boolean activateTweetsListener = true;
                if (preduc.has("activateTweetsListener")) {
                    activateTweetsListener = preduc.getBoolean("activateTweetsListener");
                }
                GJaxbGetNode getNodeReq = new GJaxbGetNode();
                getNodeReq.setId("node_06785c2e-fdae-67d3-dc6c-7b083072ef36");
                getNodeReq.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
                getNodeReq.getSelectedKnowledgeSpace().setCollaborationName(req.getSelectedKnowledgeSpace().getCollaborationName());
                getNodeReq.getSelectedKnowledgeSpace().setKnowledgeName(req.getSelectedKnowledgeSpace().getKnowledgeName());
                GJaxbGetNodeResponse getNodeResp = this.core.getNode(fakeUser, getNodeReq);
                GJaxbNode twitterNode = getNodeResp.getNode();
                GenericModelHelper.findProperty((String)"type", (List)twitterNode.getProperty(), (boolean)true).setValue("SOCIAL");
                GenericModelHelper.findProperty((String)"nature", (List)twitterNode.getProperty(), (boolean)true).setValue("TWITTER");
                GenericModelHelper.findProperty((String)"activateTweetsListener", (List)twitterNode.getProperty(), (boolean)true).setValue(activateTweetsListener.toString());
                GJaxbCreateSensor paReq = new GJaxbCreateSensor();
                paReq.setCollaborationName(req.getSelectedKnowledgeSpace().getCollaborationName());
                paReq.setKnowledgeSpaceName(req.getSelectedKnowledgeSpace().getKnowledgeName());
                paReq.setStartSensor(true);
                paReq.setNode(twitterNode);
                String twitterKey = SensorManagerResource.createTwitterKey(fakeUser);
                paReq.setContext(new GJaxbCreateSensor.Context());
                paReq.getContext().getProperty().add(GenericModelHelper.createProperty((String)"twitterKey", (String)twitterKey));
                this.sensorManagerResource.createSensor(fakeUser, paReq);
            }
        }
    }

    public SystemResource getSystem() {
        return this.system;
    }

    @GET
    @jakarta.ws.rs.Path(value="/findProjectsByUserAndCollaboration/{collaborationName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<GJaxbNode> findProjectsByUserAndCollaboration(@Auth DWUser user, @PathParam(value="collaborationName") String collaborationName, @QueryParam(value="qCollaborationName") String qCollaborationName) throws Exception {
        assert (user != null);
        List knowledges = null;
        try {
            GJaxbFindKnowledgeSpacesByUserAndCollaboration req = new GJaxbFindKnowledgeSpacesByUserAndCollaboration();
            req.setUserId(user.getUser().getId());
            req.setCollaborationName(qCollaborationName);
            knowledges = this.system.getSystemClient().findKnowledgeSpacesByUserAndCollaboration(req).getNode();
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return knowledges;
    }

    @POST
    @jakarta.ws.rs.Path(value="/projects")
    @Consumes(value={"application/json"})
    public GJaxbNode addProject(@Auth DWUser user, GJaxbNode projectNode) throws Exception {
        assert (user != null);
        this._addProject(user, projectNode, user.getCurrentCollaborationName(), null, new ArrayList<String>(), false);
        return projectNode;
    }

    public void _addProject(DWUser user, GJaxbNode projectNode, String collaborationName, String knowledgeSpaceName, List<String> projectsAlreadyLoaded, boolean metaModelAlreadyLoaded) throws Exception {
        try {
            GJaxbGenericModel model;
            String name = GenericModelHelper.getName((GJaxbNode)projectNode);
            if (!user.isFake() && (model = this.models.query(user, "match (n:" + Neo4JReqConstant.system((String)"Project") + ":`" + collaborationName + "`) where n.property_name = '" + name + "' return n;", null)) != null && model.getNode().size() > 0) {
                throw new Exception("A project with the same name '" + name + "' already exist !!!");
            }
            IndicatorManager indMan = new IndicatorManager(projectNode);
            JSONObject indicatorsJson = new JSONObject();
            for (Map.Entry entry : indMan.getIndicators().entrySet()) {
                indicatorsJson.put((String)entry.getKey(), (Object)((Indicator)entry.getValue()).toJSON());
            }
            GenericModelHelper.findProperty((String)"indicators", (List)projectNode.getProperty(), (boolean)true).setValue(indicatorsJson.toString());
            if (!user.isFake() && knowledgeSpaceName == null) {
                user.setCurrentKnowledgeSpaceName(name);
                knowledgeSpaceName = name;
                this.system.updateUser(user, user.getUser());
            }
            if (projectNode.getId() == null) {
                projectNode.setId("project_" + String.valueOf(UUID.randomUUID()));
            }
            String friendlyProjectId = RegExpHelper.toRegexFriendlyName((String)projectNode.getId());
            projectNode.setId(friendlyProjectId);
            if (!(user.isFake() || projectNode.getStatus().contains(GJaxbStatusType.REFERENCE) || projectNode.getStatus().contains(GJaxbStatusType.SHARE))) {
                GJaxbAddKnowledgeSpace req = new GJaxbAddKnowledgeSpace();
                req.setNode(projectNode);
                req.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                req.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                req.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                GJaxbAddKnowledgeSpaceResponse resp = this.system.getSystemClient().addKnowledgeSpace(req);
                projectNode.setId(resp.getId());
                this.system.attachKnowledgeSpaceToCollaboration(user, projectNode.getId(), name, collaborationName);
                GlobalDistanceTimeMatrices.create((GJaxbNode)user.getUser());
            }
            if (!(metaModelAlreadyLoaded || projectNode.getStatus().contains(GJaxbStatusType.REFERENCE) || projectNode.getStatus().contains(GJaxbStatusType.SHARE))) {
                metaModelAlreadyLoaded = true;
                this.createEffectiveDomain(user, projectNode, (RIOAbstractProject)projectNode.getUserData("project"), collaborationName, knowledgeSpaceName);
            }
            this.loadProjectsAsReferences(user, projectNode, collaborationName, knowledgeSpaceName, projectsAlreadyLoaded, metaModelAlreadyLoaded);
            this.loadProjectsAsSharedResources(user, projectNode, collaborationName, knowledgeSpaceName, projectsAlreadyLoaded, metaModelAlreadyLoaded);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
    }

    public void loadProjectsAsReferences(DWUser user, GJaxbNode projectNode, String collaborationName, String knowledgeSpaceName, List<String> projectsAlreadyLoaded, boolean metaModelAlreadyLoaded) throws Exception {
        GJaxbProperty referencesProjectsProp = GenericModelHelper.findProperty((String)"references projects", (List)projectNode.getProperty());
        if (referencesProjectsProp != null && referencesProjectsProp.getValue() != null && !referencesProjectsProp.getValue().isBlank()) {
            JSONArray referencesProjectsArray = new JSONArray(referencesProjectsProp.getValue());
            for (int i = 0; i < referencesProjectsArray.length(); ++i) {
                JSONArray refProjJson = referencesProjectsArray.getJSONArray(i);
                List projRefProps = GenericModelHelper.convertJSONArrayToPropertyList((JSONArray)refProjJson);
                String projectName = GenericModelHelper.findProperty((String)"project name", (List)projRefProps).getValue();
                String projectId = GenericModelHelper.findProperty((String)"project id", (List)projRefProps).getValue();
                String projectKey = projectName + "##reference";
                if (!projectsAlreadyLoaded.contains(projectKey)) {
                    projectsAlreadyLoaded.add(projectKey);
                    RIOAbstractProject internalProject = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).findAvailableUsecaseByFriendlyName(RegExpHelper.toRegexFriendlyName((String)projectName), true, null);
                    if (internalProject == null) {
                        throw new Exception(projectName + " cannot be found !!!");
                    }
                    this.selectUsedResources(internalProject, null);
                    GJaxbNode gJaxbNode = this.loadProject(internalProject, collaborationName, knowledgeSpaceName, user, true, false, projectsAlreadyLoaded, metaModelAlreadyLoaded);
                    continue;
                }
                LOG.debug("Project already loaded as reference: " + projectName);
            }
        }
    }

    public void loadProjectsAsSharedResources(DWUser user, GJaxbNode projectNode, String collaborationName, String knowledgeSpaceName, List<String> projectsAlreadyLoaded, boolean metaModelAlreadyLoaded) throws Exception {
        GJaxbProperty sharedResourcesProjectsProp = GenericModelHelper.findProperty((String)"shared resources projects", (List)projectNode.getProperty());
        if (sharedResourcesProjectsProp != null && sharedResourcesProjectsProp.getValue() != null && !sharedResourcesProjectsProp.getValue().isBlank()) {
            JSONArray sharedResourcesProjectsArray = new JSONArray(sharedResourcesProjectsProp.getValue());
            for (int i = 0; i < sharedResourcesProjectsArray.length(); ++i) {
                JSONArray sharedRscProjJson = sharedResourcesProjectsArray.getJSONArray(i);
                List projSharedRscProps = GenericModelHelper.convertJSONArrayToPropertyList((JSONArray)sharedRscProjJson);
                String projectName = GenericModelHelper.findProperty((String)"project name", (List)projSharedRscProps).getValue();
                String projectId = GenericModelHelper.findProperty((String)"project id", (List)projSharedRscProps).getValue();
                String projectKey = projectName + "##shared_resource";
                if (!projectsAlreadyLoaded.contains(projectKey)) {
                    projectsAlreadyLoaded.add(projectKey);
                    RIOAbstractProject internalProject = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).findAvailableUsecaseByFriendlyName(RegExpHelper.toRegexFriendlyName((String)projectName), true, null);
                    if (internalProject == null) {
                        throw new Exception(projectName + " cannot be found !!!");
                    }
                    this.selectUsedResources(internalProject, null);
                    GJaxbNode gJaxbNode = this.loadProject(internalProject, collaborationName, knowledgeSpaceName, user, false, true, projectsAlreadyLoaded, metaModelAlreadyLoaded);
                    continue;
                }
                LOG.debug("Project already loaded as share resource: " + projectName);
            }
        }
    }

    @PUT
    @jakarta.ws.rs.Path(value="/projects")
    @Consumes(value={"application/json"})
    public GJaxbNode updateProject(@Auth DWUser user, GJaxbNode node) throws Exception {
        assert (user != null);
        try {
            IndicatorManager indMan = new IndicatorManager(node);
            JSONObject indicatorsJson = new JSONObject();
            for (Map.Entry entry : indMan.getIndicators().entrySet()) {
                indicatorsJson.put((String)entry.getKey(), (Object)((Indicator)entry.getValue()).toJSON());
            }
            GenericModelHelper.findProperty((String)"indicators", (List)node.getProperty(), (boolean)true).setValue(indicatorsJson.toString());
            GJaxbUpdateKnowledgeSpace req = new GJaxbUpdateKnowledgeSpace();
            req.setNode(node);
            req.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            req.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            req.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            this.system.getSystemClient().updateKnowledgeSpace(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return node;
    }

    private GJaxbEffectiveDomain createEffectiveDomain(DWUser user, GJaxbNode projectNode, RIOAbstractProject project, String collaborationName, String knowledgeSpaceName) throws Exception {
        List<String> selectedDomains = this.getDomains(projectNode);
        String currentDomain = selectedDomains.get(0);
        if (project != null) {
            GJaxbEffectiveDomain effDomain = null;
            GJaxbDomainDefinition knownDomain = null;
            for (GJaxbDomainDefinition dd : EffectiveMetaModelPluginManager.getInstance().getDomainsDefinition()) {
                if (!dd.getName().toLowerCase().equals(currentDomain)) continue;
                knownDomain = dd;
                break;
            }
            if (knownDomain != null) {
                effDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromDefinition(knownDomain);
                if (((List)project.getMap().get(GJaxbResourceType.DOMAIN)).size() > 0) {
                    rscDomain = (GJaxbResourceURLType)((List)project.getMap().get(GJaxbResourceType.DOMAIN)).get(0);
                    GJaxbDomain extendedDomain = (GJaxbDomain)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(rscDomain.getUrl()).toURL(), GJaxbDomain.class);
                    Map mapPackagesByDomain = EffectiveMetaModelPluginManager.getInstance().getExistingPackagesByDomainMap();
                    ArrayList<GJaxbPackage> extendedPackages = new ArrayList<GJaxbPackage>();
                    if (mapPackagesByDomain.get(extendedDomain.getName()) != null) {
                        extendedPackages.addAll((Collection)mapPackagesByDomain.get(extendedDomain.getName()));
                    }
                    for (GJaxbResourceURLType rscP : (List)project.getMap().get(GJaxbResourceType.PACKAGE)) {
                        GJaxbPackage extendedPackage = (GJaxbPackage)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(rscP.getUrl()).toURL(), GJaxbPackage.class);
                        extendedPackages.add(extendedPackage);
                        EffectiveMetaModelPluginManager.getInstance().getPackages().put(new QName(extendedPackage.findTargetNamespace(), extendedPackage.getName()), extendedPackage);
                    }
                    GJaxbEffectiveDomain extendedEffDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromResources(extendedDomain, extendedPackages);
                    effDomain = this.mergeExtendedEffectiveDomain(effDomain, extendedEffDomain, user.getCurrentCollaborationName());
                    EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), effDomain);
                }
            } else if (((List)project.getMap().get(GJaxbResourceType.DOMAIN)).size() > 0) {
                rscDomain = (GJaxbResourceURLType)((List)project.getMap().get(GJaxbResourceType.DOMAIN)).get(0);
                GJaxbDomain domain = (GJaxbDomain)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(rscDomain.getUrl()).toURL(), GJaxbDomain.class);
                ArrayList<GJaxbPackage> _packages = new ArrayList<GJaxbPackage>();
                List rscPackages = (List)project.getMap().get(GJaxbResourceType.PACKAGE);
                for (GJaxbResourceURLType rscP : rscPackages) {
                    GJaxbPackage _package = (GJaxbPackage)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(rscP.getUrl()).toURL(), GJaxbPackage.class);
                    _packages.add(_package);
                    EffectiveMetaModelPluginManager.getInstance().getPackages().put(new QName(_package.findTargetNamespace(), _package.getName()), _package);
                }
                effDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromResources(domain, _packages);
            }
            SVGGenerator svgGen = new SVGGenerator();
            for (GJaxbEffectivePackage effPack : effDomain.getEffectivePackage()) {
                for (GJaxbRelation relation : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRelation()) {
                    DWApplicationService.generateIcon(svgGen, relation, RegExpHelper.toRegexFriendlyName((String)collaborationName), RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
                }
            }
            for (GJaxbRelation relation : effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getRelation()) {
                DWApplicationService.generateIcon(svgGen, relation, RegExpHelper.toRegexFriendlyName((String)collaborationName), RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            }
            GJaxbPublishSyncEffectiveDomain publishReq = new GJaxbPublishSyncEffectiveDomain();
            publishReq.setEffectiveDomain(effDomain);
            publishReq.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
            publishReq.getSelectedKnowledgeSpace().setCollaborationName(RegExpHelper.toRegexFriendlyName((String)collaborationName));
            publishReq.getSelectedKnowledgeSpace().setKnowledgeName(RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            this.metaModel.publishSyncEffectiveDomain(user, publishReq);
            EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName, effDomain);
        } else {
            GJaxbDomainDefinition knownDomain = null;
            for (GJaxbDomainDefinition dd : EffectiveMetaModelPluginManager.getInstance().getDomainsDefinition()) {
                if (!dd.getName().toLowerCase().equals(currentDomain)) continue;
                knownDomain = dd;
                break;
            }
            GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromDefinition(knownDomain);
            effDomain.getEffectivePackage().stream().forEach(ep -> {
                ep.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().stream().forEach(ec -> ec.setReadonly(Boolean.valueOf(true)));
                ep.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRelation().stream().forEach(r -> r.setReadonly(Boolean.valueOf(true)));
            });
            effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getEffectiveConcept().stream().forEach(ec -> ec.setReadonly(Boolean.valueOf(true)));
            effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getRelation().stream().forEach(r -> r.setReadonly(Boolean.valueOf(true)));
            SVGGenerator svgGen = new SVGGenerator();
            for (GJaxbEffectivePackage effPack : effDomain.getEffectivePackage()) {
                for (GJaxbRelation relation : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRelation()) {
                    DWApplicationService.generateIcon(svgGen, relation, RegExpHelper.toRegexFriendlyName((String)collaborationName), RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
                }
            }
            for (GJaxbRelation relation : effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getRelation()) {
                DWApplicationService.generateIcon(svgGen, relation, RegExpHelper.toRegexFriendlyName((String)collaborationName), RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            }
            GJaxbPublishSyncEffectiveDomain publishReq = new GJaxbPublishSyncEffectiveDomain();
            publishReq.setEffectiveDomain(effDomain);
            publishReq.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
            publishReq.getSelectedKnowledgeSpace().setCollaborationName(RegExpHelper.toRegexFriendlyName((String)collaborationName));
            publishReq.getSelectedKnowledgeSpace().setKnowledgeName(RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            this.metaModel.publishSyncEffectiveDomain(user, publishReq);
            EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName, effDomain);
        }
        GJaxbExtractSyncEffectiveDomain extractReq = new GJaxbExtractSyncEffectiveDomain();
        extractReq.setDomain(currentDomain);
        extractReq.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
        extractReq.getSelectedKnowledgeSpace().setCollaborationName(RegExpHelper.toRegexFriendlyName((String)collaborationName));
        extractReq.getSelectedKnowledgeSpace().setKnowledgeName(RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
        GJaxbExtractSyncEffectiveDomainResponse extractResp = this.metaModel.extractSyncEffectiveDomain(user, extractReq);
        return extractResp.getEffectiveDomain();
    }

    private GJaxbEffectiveDomain mergeExtendedEffectiveDomain(GJaxbEffectiveDomain effDomain, GJaxbEffectiveDomain extendedEffDomain, String collaborationName) {
        for (GJaxbEffectivePackage extendedEffPack : extendedEffDomain.getEffectivePackage()) {
            boolean found = false;
            for (GJaxbEffectivePackage effPack : effDomain.getEffectivePackage()) {
                QName newType;
                if (!RegExpHelper.toRegexFriendlyName((String)extendedEffPack.getName()).equals(RegExpHelper.toRegexFriendlyName((String)effPack.getName()))) continue;
                for (GJaxbEffectiveConceptType concept : extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
                    if (!concept.getType().getNamespaceURI().contains("${collab}")) continue;
                    newType = new QName(concept.getType().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)collaborationName)), concept.getType().getLocalPart());
                    concept.setType(newType);
                }
                for (GJaxbContainmentRule.Contain _contain : extendedEffPack.getRules().getContainmentRule().getContain()) {
                    if (!_contain.getType().getNamespaceURI().contains("${collab}")) continue;
                    newType = new QName(_contain.getType().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)collaborationName)), _contain.getType().getLocalPart());
                    _contain.setType(newType);
                }
                for (GJaxbConnectionRule rule : extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule()) {
                    if (rule.getRelationType().getNamespaceURI().contains("${collab}")) {
                        newType = new QName(rule.getRelationType().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)collaborationName)), rule.getRelationType().getLocalPart());
                        rule.setRelationType(newType);
                    }
                    if (rule.getFrom().getNamespaceURI().contains("${collab}")) {
                        newType = new QName(rule.getFrom().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)collaborationName)), rule.getFrom().getLocalPart());
                        rule.setFrom(newType);
                    }
                    if (!rule.getTo().getNamespaceURI().contains("${collab}")) continue;
                    newType = new QName(rule.getTo().getNamespaceURI().replace("${collab}", RegExpHelper.toRegexFriendlyName((String)collaborationName)), rule.getTo().getLocalPart());
                    rule.setTo(newType);
                }
                effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().addAll(extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept());
                effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getEffectiveConcept().addAll(extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept());
                effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule().addAll(extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule());
                effPack.getRules().getContainmentRule().getContain().addAll(extendedEffPack.getRules().getContainmentRule().getContain());
                effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule().addAll(extendedEffPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule());
                found = true;
            }
            if (found) continue;
            effDomain.getEffectivePackage().add(extendedEffPack);
        }
        return effDomain;
    }

    private GJaxbEffectiveDomain getAndRefreshEffectiveDomainIfNotExist(DWUser user, GJaxbNode projectNode, RIOAbstractProject project, String collaborationName, String knowledgeSpaceName, boolean forceToRefresh) throws Exception {
        GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName);
        if ((effDomain == null || forceToRefresh) && projectNode != null) {
            GJaxbExtractSyncEffectiveDomain extractReq = new GJaxbExtractSyncEffectiveDomain();
            extractReq.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
            extractReq.getSelectedKnowledgeSpace().setCollaborationName(RegExpHelper.toRegexFriendlyName((String)collaborationName));
            extractReq.getSelectedKnowledgeSpace().setKnowledgeName(RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            extractReq.setReload(true);
            GJaxbExtractSyncEffectiveDomainResponse extractResp = this.metaModel.extractSyncEffectiveDomain(user, extractReq);
            EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName, extractResp.getEffectiveDomain());
            effDomain = extractResp.getEffectiveDomain();
        }
        return effDomain;
    }

    private List<String> getDomains(GJaxbNode projectNode) {
        ArrayList<String> selectedDomains = new ArrayList<String>();
        JSONObject domains = new JSONObject(GenericModelHelper.findProperty((String)"domains", (List)projectNode.getProperty()).getValue());
        for (String domain : domains.keySet()) {
            if (!domains.getJSONObject(domain).getBoolean("checked") || selectedDomains.contains(domain)) continue;
            selectedDomains.add(domain);
        }
        assert (selectedDomains.size() == 1);
        return selectedDomains;
    }

    @GET
    @jakarta.ws.rs.Path(value="/projects/{id}")
    public GJaxbNode getProject(@Auth DWUser user, @PathParam(value="id") String id, @QueryParam(value="qid") String qid) throws Exception {
        assert (user != null);
        GJaxbNode project = null;
        try {
            String collaborationName = user.getCurrentCollaborationName();
            String knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            if (qid.indexOf("_k__") > 0) {
                knowledgeSpaceName = qid.substring(qid.indexOf("_k__") + "_k__".length());
            }
            GJaxbGetKnowledgeSpace req = new GJaxbGetKnowledgeSpace();
            req.setId(Neo4JId.cleanId((String)qid));
            req.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            req.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            req.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            project = this.system.getSystemClient().getKnowledgeSpace(req).getNode();
            user.setCurrentKnowledgeSpaceName(GenericModelHelper.getName((GJaxbNode)project));
            this.system.updateUser(null, user.getUser());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return project;
    }

    @GET
    @jakarta.ws.rs.Path(value="/getProjectByNameInCollaboration")
    public GJaxbNode getProjectByNameInCollaboration(@Auth DWUser user, @QueryParam(value="projectName") String projectName, @QueryParam(value="collaborationName") String collaborationName) throws Exception {
        assert (user != null);
        GJaxbNode project = null;
        try {
            GJaxbGetKnowledgeSpaceByNameInCollaboration req = new GJaxbGetKnowledgeSpaceByNameInCollaboration();
            req.setKnowledgeSpaceName(projectName);
            req.setCollaborationName(collaborationName);
            project = this.system.getSystemClient().getKnowledgeSpaceByNameInCollaboration(req).getNode();
            if (project != null) {
                user.setCurrentKnowledgeSpaceName(GenericModelHelper.getName((GJaxbNode)project));
                this.system.updateUser(user, user.getUser());
            }
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return project;
    }

    @GET
    @jakarta.ws.rs.Path(value="/findEffectiveDomainByProjectId")
    public GJaxbEffectiveDomain findEffectiveDomainByProjectId(@Auth DWUser user, @QueryParam(value="projectId") String projectId, @QueryParam(value="forceToRefresh") Boolean forceToRefresh) throws Exception {
        assert (user != null);
        GJaxbEffectiveDomain effDomain = null;
        try {
            Object projIdFriendly = projectId;
            String collaborationName = user.getCurrentCollaborationName();
            String knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            if (!((String)projIdFriendly).contains("_c__")) {
                projIdFriendly = projectId + "_c__" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "_k__" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName);
            } else {
                collaborationName = ((String)projIdFriendly).split("_c__")[1].split("_k__")[0];
                knowledgeSpaceName = ((String)projIdFriendly).split("_c__")[1].split("_k__")[1];
            }
            GJaxbNode projectNode = this.system.getKnowledgeSpace(user, (String)projIdFriendly, (String)projIdFriendly);
            if (forceToRefresh == null) {
                forceToRefresh = false;
            }
            effDomain = this.getAndRefreshEffectiveDomainIfNotExist(user, projectNode, null, collaborationName, knowledgeSpaceName, forceToRefresh);
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return effDomain;
    }

    @GET
    @jakarta.ws.rs.Path(value="/findEffectivePackageByNameByProjectId")
    public GJaxbEffectivePackage findEffectivePackageByNameByProjectId(@Auth DWUser user, @QueryParam(value="projectId") String projectId, @QueryParam(value="category") String category) throws Exception {
        assert (user != null);
        GJaxbEffectivePackage mcv = null;
        try {
            mcv = this.findEffectivePackage(user, projectId, category);
            if (mcv == null) {
                throw new Exception("Impossible to find effectiveMetaModel");
            }
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return mcv;
    }

    public synchronized GJaxbEffectivePackage findEffectivePackage(DWUser user, String projectId, String category) throws Exception {
        Object projIdFriendly;
        Object projId = projectId;
        if (!((String)projId).contains("_c__")) {
            projId = projectId + "_c__" + user.getCurrentCollaborationName() + "_k__" + user.getCurrentKnowledgeSpaceName();
        }
        if (!((String)(projIdFriendly = projectId)).contains("_c__")) {
            projIdFriendly = projectId + "_c__" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()) + "_k__" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentKnowledgeSpaceName());
        }
        GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName());
        GJaxbEffectivePackage mcv = effDomain.getEffectivePackage().stream().filter(m -> RegExpHelper.toRegexFriendlyName((String)m.getName().toLowerCase()).equals(RegExpHelper.toRegexFriendlyName((String)category.toLowerCase()))).findFirst().get();
        return mcv;
    }

    @POST
    @jakarta.ws.rs.Path(value="/downloadRemoteUsecase")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String downloadRemoteUsecaseString(@Auth DWUser user, GJaxbShortUsecaseDefinitionType ucDef) throws Exception {
        GJaxbCompleteUsecaseDefinition projectDef = this.downloadRemoteUsecase(user, ucDef);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)projectDef)).getJSONObject("completeUsecaseDefinition").toString();
    }

    public GJaxbCompleteUsecaseDefinition downloadRemoteUsecase(@Auth DWUser user, GJaxbShortUsecaseDefinitionType ucDef) throws Exception {
        RIOAbstractProject project = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).download(ucDef);
        return project.createCompleteUsecaseDefinition();
    }

    @POST
    @jakarta.ws.rs.Path(value="/loadProjectFromUsecase")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String loadProjectFromUsecase(@Auth DWUser user, GJaxbCompleteUsecaseDefinition usecase, @QueryParam(value="collaborationName") String collaborationName) throws Exception {
        JSONObject response = new JSONObject();
        assert (user != null);
        assert (usecase != null);
        LOG.debug("[user]:" + user.getName() + " - [loadProjectFromUsecase] with usecase: " + usecase.getName());
        if (collaborationName != null && !user.getCurrentCollaborationName().equals(collaborationName)) {
            GJaxbNode collab = null;
            List<GJaxbNode> collabs = this.system.findCollaborationsByName(user, collaborationName);
            collab = collabs.isEmpty() ? SystemResource.createCollaboration(collaborationName, this.system.getSystemClient(), this.system.getCollaborationMetaModel()) : collabs.get(0);
            this.system.selectCollaboration(user, collab.getId(), collab.getId());
        }
        if (collaborationName == null) {
            collaborationName = user.getCurrentCollaborationName();
        }
        RIOAbstractProject internalProject = RIOUsecasesManager.getInstance((String)this.conf.getVersion()).findAvailableUsecaseByFriendlyName(usecase.getFriendlyName(), true, usecase);
        this.selectUsedResources(internalProject, usecase);
        GJaxbNode projectNode = this.loadProject(internalProject, collaborationName, usecase.getName(), user, false, false, new ArrayList<String>(), false);
        response.put("projectId", (Object)projectNode.getId());
        response.put("projectName", (Object)GenericModelHelper.getName((GJaxbNode)projectNode));
        return response.toString();
    }

    public GJaxbNode loadProject(RIOAbstractProject project, String collaborationName, String knowledgeSpaceName, DWUser user, boolean isReference, boolean isSharedResource, List<String> projectsAlreadyLoaded, boolean metaModelAlreadyLoaded) throws Exception {
        GJaxbNode projectModel = null;
        try {
            GJaxbInterpretationConfig rule;
            if (!user.isFake()) {
                if (user.getCurrentCollaborationName() == null || !user.getCurrentCollaborationName().equals(collaborationName)) {
                    user.setCurrentCollaborationName(collaborationName);
                }
                if (user.getCurrentKnowledgeSpaceName() == null || !user.getCurrentKnowledgeSpaceName().equals(knowledgeSpaceName)) {
                    user.setCurrentKnowledgeSpaceName(knowledgeSpaceName);
                }
                this.system.updateUser(user, user.getUser());
            }
            if (project.getProject() != null) {
                LOG.debug("load project: " + project.getUsecaseDef().getName());
                projectModel = (GJaxbNode)((GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(project.getProject().getUrl()).toURL(), GJaxbGenericModel.class)).getNode().get(0);
                projectModel.getStatus().remove(GJaxbStatusType.ACTIVE);
                projectModel.getStatus().remove(GJaxbStatusType.FREEZE);
                projectModel.getStatus().add(GJaxbStatusType.ACTIVE);
                if (isReference) {
                    projectModel.getStatus().remove(GJaxbStatusType.ACTIVE);
                    projectModel.getStatus().add(GJaxbStatusType.REFERENCE);
                }
                if (isSharedResource) {
                    projectModel.getStatus().remove(GJaxbStatusType.ACTIVE);
                    projectModel.getStatus().add(GJaxbStatusType.SHARE);
                }
                projectModel.setUserData("project", (Object)project);
                this._addProject(user, projectModel, collaborationName, knowledgeSpaceName, projectsAlreadyLoaded, metaModelAlreadyLoaded);
            } else {
                LOG.debug("load project as reference or share resources knowledge: " + project.getUsecaseDef().getName());
            }
            this.copyResourcesInRioResourcesFolder(project, user, collaborationName, knowledgeSpaceName);
            ArrayList<GJaxbModelURLType> modelsByUrlSelected = new ArrayList<GJaxbModelURLType>();
            ((List)project.getMap().get(GJaxbResourceType.MODEL)).forEach(r -> {
                GJaxbModelURLType m;
                if (r.isSelected() && !r.getName().equals("project") && (m = (GJaxbModelURLType)r).getStatus().equals((Object)GJaxbStatusType.FREEZE)) {
                    GJaxbModelURLType model = new GJaxbModelURLType();
                    model.setName(m.getName());
                    model.setUrl(m.getUrl().toString());
                    model.setStatus(m.getStatus());
                    model.setIsReference(isReference);
                    model.setIsSharedResource(isSharedResource);
                    model.setCategory(m.getCategory());
                    modelsByUrlSelected.add(model);
                    LOG.debug("project freeze model to load: " + model.getUrl());
                }
            });
            this.models.addModelsFromURL(Optional.of(user), modelsByUrlSelected);
            LOG.debug("project freeze models loaded: " + modelsByUrlSelected.size());
            modelsByUrlSelected.clear();
            ((List)project.getMap().get(GJaxbResourceType.MODEL)).forEach(r -> {
                GJaxbModelURLType m;
                if (r.isSelected() && !r.getName().equals("project") && (m = (GJaxbModelURLType)r).getStatus().equals((Object)GJaxbStatusType.ACTIVE)) {
                    GJaxbModelURLType model = new GJaxbModelURLType();
                    model.setName(m.getName());
                    model.setUrl(m.getUrl().toString());
                    model.setStatus(m.getStatus());
                    model.setIsReference(isReference);
                    model.setIsSharedResource(isSharedResource);
                    model.setCategory(m.getCategory());
                    modelsByUrlSelected.add(model);
                    LOG.debug("project active model to load: " + model.getUrl());
                }
            });
            this.models.addModelsFromURL(Optional.of(user), modelsByUrlSelected);
            LOG.debug("project active models loaded: " + modelsByUrlSelected.size());
            LLManager.getInstance().analyzePartialInterpretors(collaborationName, knowledgeSpaceName);
            ArrayList<GJaxbInterpretationConfig> configs = new ArrayList<GJaxbInterpretationConfig>();
            for (Object r2 : (List)project.getMap().get(GJaxbResourceType.CEP_RULE)) {
                if (!r2.isSelected()) continue;
                rule = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(r2.getUrl()).toURL(), GJaxbInterpretationConfig.class);
                configs.add(rule);
            }
            for (Object r2 : (List)project.getMap().get(GJaxbResourceType.ML_RULE)) {
                if (!r2.isSelected()) continue;
                rule = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(r2.getUrl()).toURL(), GJaxbInterpretationConfig.class);
                configs.add(rule);
            }
            String rulesLoadedResponse = this.interpretationRules.addRules(user, configs);
            for (Object r3 : (List)project.getMap().get(GJaxbResourceType.DISTANCE_TIME_MATRIX)) {
                GJaxbDistanceTimeMatrix cachedMatrixModel = (GJaxbDistanceTimeMatrix)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(r3.getUrl()).toURL(), GJaxbDistanceTimeMatrix.class);
                GlobalDistanceTimeMatrices.set((GJaxbNode)user.getUser(), (GJaxbDistanceTimeMatrix)cachedMatrixModel);
            }
            for (Object r3 : (List)project.getMap().get(GJaxbResourceType.GAME_SCENARIO)) {
                GJaxbGameScenario gs = (GJaxbGameScenario)XMLJAXBContext.getInstance().unmarshallDocument(URI.create(r3.getUrl()).toURL(), GJaxbGameScenario.class);
                for (GJaxbSensorControlerBackup rds : gs.getSensorControlerBackup()) {
                    GJaxbResourceURLType dr = project.findResourceByName(rds.getDatasetInfo().getName().strip().stripIndent(), GJaxbResourceType.DATASET);
                    if (dr == null) {
                        throw new Exception("Impossible to find: " + rds.getDatasetInfo().getName());
                    }
                    String buffer = XMLNSCleaner.clean((String)FileUtil.getContents((InputStream)URI.create(dr.getUrl()).toURL().openStream()));
                    byte[] compressedBuffer = GZipUtil.zip((String)buffer);
                    rds.getDatasetInfo().setZip(new DataHandler((DataSource)new ByteArrayDataSource(compressedBuffer, "application/gzip")));
                    rds.getDatasetInfo().setUrl(null);
                }
                GJaxbCreateGameScenario createReq = new GJaxbCreateGameScenario();
                createReq.setCollaborationName(user.getCurrentCollaborationName());
                createReq.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                createReq.setGameScenario(gs);
                this.gmClient.createGameScenario(createReq);
            }
            GJaxbRestoreTimeSeriesDB restoreReq = new GJaxbRestoreTimeSeriesDB();
            for (Object r4 : (List)project.getMap().get(GJaxbResourceType.BACKUP_DATABASE)) {
                if (!r4.isSelected() || !r4.getName().contains("timeseries")) continue;
                restoreReq.setCollaborationName(user.getCurrentCollaborationName());
                restoreReq.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                DataHandler dh = new DataHandler(URI.create(r4.getUrl()).toURL());
                restoreReq.getZip().add(dh);
            }
            if (!restoreReq.getZip().isEmpty()) {
                Object r3;
                r3 = this.sensorManagerClient.restoreTimeSeriesDB(restoreReq);
            }
            if (((List)project.getMap().get(GJaxbResourceType.RAG)).size() > 0) {
                GJaxbRestoreRAGFromDirectory restoreRag = new GJaxbRestoreRAGFromDirectory();
                restoreRag.setContext(new GJaxbContext());
                restoreRag.getContext().setCurrentCollaborationName(user.getCurrentCollaborationName());
                restoreRag.getContext().setCurrentKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                for (GJaxbResourceURLType r5 : (List)project.getMap().get(GJaxbResourceType.RAG)) {
                    if (!r5.isSelected()) continue;
                    URL url = URI.create(r5.getUrl()).toURL();
                    String fileName = url.getFile().substring(url.getFile().lastIndexOf("/") + "/".length());
                    File ragFileInFolder = new File(AIChatbotImpl.getOrCreateRAGDirectory((GJaxbContext)restoreRag.getContext()), fileName);
                    FileOutputStream out = new FileOutputStream(ragFileInFolder);
                    FileUtil.copy((InputStream)url.openStream(), (OutputStream)out);
                    out.close();
                }
                GJaxbRestoreRAGFromDirectoryResponse restoreRagResp = this.aichatBotResource.restoreRAGFromDirectory(restoreRag);
                LOG.debug("RAG Initialized: " + JSONJAXBContext.getInstance().marshallAnyElement((Object)restoreRagResp));
            }
            this.createAllSensors(user);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (projectModel != null) {
                this.deleteProject(user, projectModel.getId(), projectModel.getId());
            }
            throw e;
        }
        return projectModel;
    }

    private void createAllSensors(DWUser user) throws Exception {
        List<GJaxbNode> dataSources = this.core.findNodesByTypesAndOrProperties(user, Arrays.asList(new QName("http://fr.emac.gind/core-model", "Data_Source")), null, Arrays.asList("ACTIVE"), user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName());
        for (GJaxbNode dataSource : dataSources) {
            GJaxbCreateSensor req = new GJaxbCreateSensor();
            req.setNode(dataSource);
            req.setCollaborationName(user.getCurrentCollaborationName());
            req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            this.sensorManagerResource.createSensor(user, req);
        }
    }

    private void copyResourcesInRioResourcesFolder(RIOAbstractProject project, DWUser user, String collaborationName, String knowledgeSpaceName) throws Exception {
        String rootDir = project.getRootDirectory();
        URL root = null;
        LOG.debug("project mode (location): " + String.valueOf(project.getUsecaseDef().getLocation()));
        root = project.getUsecaseDef().getLocation().equals((Object)GJaxbLocationType.EMBEDDED) ? Thread.currentThread().getContextClassLoader().getResource(rootDir) : new File(rootDir).toURI().toURL();
        if (root != null) {
            Path myPath;
            LOG.debug("project root: " + String.valueOf(root));
            String friendlyCollaborationName = RegExpHelper.toRegexFriendlyName((String)WORLD_COLLABORATION_NAME);
            if (collaborationName != null) {
                friendlyCollaborationName = RegExpHelper.toRegexFriendlyName((String)collaborationName).toLowerCase();
            }
            LOG.debug("project friendlyCollaborationName: " + friendlyCollaborationName);
            String friendlyKnowledgeSpaceName = RegExpHelper.toRegexFriendlyName((String)project.getUsecaseDef().getFriendlyName()).toLowerCase();
            if (knowledgeSpaceName != null) {
                friendlyKnowledgeSpaceName = RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName).toLowerCase();
            }
            LOG.debug("project friendlyKnowledgeSpaceName: " + friendlyKnowledgeSpaceName);
            if (root != null && root.toURI().getScheme().equals("jar")) {
                FileSystem fileSystem = FileSystems.getFileSystem(root.toURI());
                myPath = fileSystem.getPath(rootDir, new String[0]);
            } else {
                myPath = Paths.get(root.toURI());
            }
            Stream<Path> walk = Files.walk(myPath, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path p = (Path)it.next();
                URL url = p.toUri().toURL();
                String shortPath = url.getFile().substring(url.getFile().indexOf("/META-INF/resources/") + "/META-INF/resources/".length(), url.getFile().length());
                if (shortPath.indexOf(".", shortPath.lastIndexOf("/")) <= 0) continue;
                if (shortPath.contains("/resources/")) {
                    String beginIndex;
                    String pathAndFileName = shortPath.substring(shortPath.indexOf(project.getUsecaseDef().getFriendlyName()) + project.getUsecaseDef().getFriendlyName().length(), shortPath.length());
                    String path = pathAndFileName.substring(0, pathAndFileName.lastIndexOf("/") + 1);
                    if (path.indexOf(beginIndex = "-uc-resources/gind/usecases/" + project.getUsecaseDef().getFriendlyName() + "/") >= 0) {
                        path = path.substring(path.indexOf(beginIndex) + beginIndex.length());
                    }
                    String fileName = pathAndFileName.substring(pathAndFileName.lastIndexOf("/") + 1, pathAndFileName.length());
                    File rscDir = new File(RIOConstant.RESOURCES_FOLDER + "/" + friendlyCollaborationName + "/" + friendlyKnowledgeSpaceName + "/" + path);
                    rscDir.mkdirs();
                    File rsc = new File(rscDir, fileName);
                    rsc.createNewFile();
                    FileUtils.copyURLToFile((URL)url, (File)rsc);
                    continue;
                }
                if (!url.toString().contains("/users/user_node_") || !url.toString().contains(".")) continue;
                String queryPath = url.toString().substring(url.toString().indexOf("/users/") + "/users/".length());
                File destination = new File("./target/listener", queryPath);
                FileUtils.copyURLToFile((URL)url, (File)destination);
                if (!url.toString().endsWith(".xml")) continue;
                GJaxbNode predefinedUser = (GJaxbNode)XMLJAXBContext.getInstance().unmarshallDocument(url, GJaxbNode.class);
                GenericModelHelper.findProperty((String)"Presence", (List)predefinedUser.getProperty(), (boolean)true).setValue("Available");
                GenericModelHelper.findProperty((String)"currentCollaborationName", (List)predefinedUser.getProperty(), (boolean)true).setValue(collaborationName);
                GenericModelHelper.findProperty((String)"currentKnowledgeSpaceName", (List)predefinedUser.getProperty(), (boolean)true).setValue(knowledgeSpaceName);
                GJaxbUpdateUser upReq = new GJaxbUpdateUser();
                upReq.setNode(predefinedUser);
                upReq.setCreateIfNotExist(true);
                this.system.updateUser(user, predefinedUser);
                List<GJaxbNode> collabNodes = this.system.findCollaborationsByName(user, collaborationName);
                GJaxbNode collabNode = collabNodes.get(0);
                GJaxbConnectUserToCollaboration reqConnColl = new GJaxbConnectUserToCollaboration();
                reqConnColl.setCollaborationId(collabNode.getId());
                reqConnColl.setUserId(predefinedUser.getId());
                this.system.connectUserToCollaboration(user, reqConnColl);
            }
            walk.close();
        }
    }

    private void selectUsedResources(RIOAbstractProject internalProject, GJaxbCompleteUsecaseDefinition usecase) {
        if (usecase != null) {
            if (usecase.getResourcesByType() != null && !usecase.getResourcesByType().isEmpty()) {
                internalProject.getMap().values().forEach(rscs -> rscs.forEach(rsc -> rsc.setSelected(false)));
                for (GJaxbCompleteUsecaseDefinition.ResourcesByType rscsByType : usecase.getResourcesByType()) {
                    for (GJaxbResourceURLType rscBrowser : rscsByType.getResources()) {
                        GJaxbResourceURLType rsc = internalProject.findResourceByName(rscBrowser.getName(), rscsByType.getType());
                        if (!rscBrowser.isSelected()) continue;
                        rsc.setSelected(true);
                    }
                }
            } else {
                internalProject.getMap().values().forEach(rscs -> rscs.forEach(rsc -> rsc.setSelected(true)));
            }
        }
    }

    @DELETE
    @jakarta.ws.rs.Path(value="/projects/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteProject(@Auth DWUser user, @PathParam(value="id") String id, @QueryParam(value="qid") String qid) throws Exception {
        JSONObject resp = new JSONObject();
        try {
            assert (user != null);
            GJaxbNode project = this.system.getKnowledgeSpace(user, id, qid);
            if (project != null) {
                String projectName = GenericModelHelper.getName((GJaxbNode)project);
                this.interpretationRules.deleteRules(user, this.interpretationRules.getRules(user));
                GJaxbDeleteGameScenarios delReq = new GJaxbDeleteGameScenarios();
                delReq.setCollaborationName(user.getCurrentCollaborationName());
                delReq.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                this.gmClient.deleteGameScenarios(delReq);
                List<ProcessListResponse> list = this.process.processDeployedList(user);
                for (ProcessListResponse respP : list) {
                    for (GJaxbDeployResult deploy : respP.getDeployedProcesses().getResult()) {
                        GJaxbProcessToDeploy sampledProcess = new GJaxbProcessToDeploy();
                        sampledProcess.setProcessName(deploy.getServiceQName().getLocalPart());
                        this.process.undeploy(user, sampledProcess);
                    }
                }
                String currentKnowledge = RegExpHelper.toRegexFriendlyName((String)projectName);
                String currentCollaboration = RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName());
                this.models.query(null, "match (n:`" + currentCollaboration + "`:`" + currentKnowledge + "`), (n1:`" + currentCollaboration + "`:`" + currentKnowledge + "`)-[r]-(n2:`" + currentCollaboration + "`:`" + currentKnowledge + "`) detach delete n1, n2, n, r", null);
                this.system.deleteKnowledgeSpace(user, id, qid);
                if (projectName.equals(user.getCurrentKnowledgeSpaceName())) {
                    user.setCurrentKnowledgeSpaceName(null);
                    this.system.updateUser(user, user.getUser());
                }
                FileUtils.deleteQuietly((File)new File(RIOConstant.RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()) + "/" + RegExpHelper.toRegexFriendlyName((String)projectName)));
                resp.put("projectName", (Object)projectName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return resp.toString();
    }

    @DELETE
    @jakarta.ws.rs.Path(value="/resetAll")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String resetAll(@Auth DWUser user) throws Exception {
        JSONObject resp = new JSONObject();
        try {
            assert (user != null);
            this.interpretationRules.deleteRules(user, this.interpretationRules.getRules(user));
            List<ProcessListResponse> list = this.process.processDeployedList(user);
            for (ProcessListResponse respP : list) {
                for (GJaxbDeployResult deploy : respP.getDeployedProcesses().getResult()) {
                    GJaxbProcessToDeploy sampledProcess = new GJaxbProcessToDeploy();
                    sampledProcess.setProcessName(deploy.getServiceQName().getLocalPart());
                    this.process.undeploy(user, sampledProcess);
                }
            }
            GJaxbGenericModel models = this.models.query(null, "match (n), (n1)-[r]-(n2) where not n:" + Neo4JReqConstant.system((String)"User") + " and not n1:" + Neo4JReqConstant.system((String)"User") + " and not n2:" + Neo4JReqConstant.system((String)"User") + " and not n:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n1:" + Neo4JReqConstant.system((String)"Collaboration") + " and not n2:" + Neo4JReqConstant.system((String)"Collaboration") + " return n1, n2, n, r", null);
            GJaxbSynchronizeRequest m = new GJaxbSynchronizeRequest();
            m.setJsonModel(JSONJAXBContext.getInstance().marshallAnyElement((Object)models));
            this.models.deleteModels(user, Arrays.asList(m));
            user.setCurrentKnowledgeSpaceName(null);
            this.system.updateUser(null, user.getUser());
            FileUtils.deleteQuietly((File)new File(RIOConstant.RESOURCES_FOLDER + "/" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName())));
            resp.put("result", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return resp.toString();
    }

    @POST
    @jakarta.ws.rs.Path(value="/exportProject")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportProject(@Auth DWUser user, ExportProjectRequest request) throws Exception {
        Response response = null;
        try {
            Collection files;
            JSONObject fileResources;
            Document docResources;
            GJaxbGenericModel model;
            GJaxbSynchronizeResponse extractResourcesResp;
            GJaxbNode projModel = this.system.getKnowledgeSpace(user, request.getProjectId(), request.getProjectId());
            if (projModel == null) {
                throw new Exception("Impossible to find project with this id: " + request.getProjectId());
            }
            GJaxbGenericModel projectModel = new GJaxbGenericModel();
            projectModel.setName(request.getProjectName());
            projectModel.getNode().add(projModel);
            String shortProjectId = request.getProjectId();
            if (request.getProjectId().indexOf("_c__") > 0) {
                shortProjectId = shortProjectId.substring(0, request.getProjectId().indexOf("_c__"));
            }
            ((GJaxbNode)projectModel.getNode().get(0)).setId(shortProjectId);
            Document docProject = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)projectModel);
            final JSONArray array = new JSONArray();
            GJaxbProperty useDynamicMMProp = GenericModelHelper.findProperty((String)"use dynamic MetaModel", (List)projModel.getProperty());
            if (useDynamicMMProp != null && useDynamicMMProp.getValue() != null && useDynamicMMProp.getValue().toLowerCase().trim().equals("yes")) {
                String targetNameSpace = "http://fr.emac.gind/${collab}/" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentKnowledgeSpaceName());
                GJaxbEffectiveDomain dom = this.getAndRefreshEffectiveDomainIfNotExist(user, projModel, null, user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), false);
                GJaxbEffectiveDomain cloned_domain = (GJaxbEffectiveDomain)GenericModelHelper.clone((AbstractJaxbObject)dom, dom.getClass());
                ArrayList<GJaxbEffectivePackage> arrayList = new ArrayList<GJaxbEffectivePackage>();
                for (GJaxbEffectivePackage effP : cloned_domain.getEffectivePackage()) {
                    GJaxbEffectivePackage effPack = this.keepOnlyAddedClassInPackage(effP, user.getCurrentCollaborationName());
                    if (effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().isEmpty()) continue;
                    arrayList.add(effPack);
                }
                for (GJaxbEffectivePackage validEffPack : arrayList) {
                    GJaxbPackage _package = EffectiveMetaModelPluginManager.getInstance().createPackageFromEffectivePackage(targetNameSpace, validEffPack);
                    JSONObject fileEffPackage = new JSONObject();
                    fileEffPackage.put("fileName", (Object)("metamodel/Extended_" + _package.getName() + "_Package.xml"));
                    fileEffPackage.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)_package)).getBytes());
                    array.put((Object)fileEffPackage);
                }
                GJaxbMetaModel extendedMetaModel = EffectiveMetaModelPluginManager.getInstance().createMetaModelFromEffectivePackages(targetNameSpace, arrayList);
                JSONObject fileEffPackage = new JSONObject();
                fileEffPackage.put("fileName", (Object)"metamodel/Extended_Collaborative_MetaModel.xml");
                fileEffPackage.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)extendedMetaModel)).getBytes());
                array.put((Object)fileEffPackage);
                cloned_domain.setName("Collaborative");
                cloned_domain.setGlobalEffectiveMetaModel(null);
                cloned_domain.getEffectivePackage().clear();
                JSONObject fileEffDomain = new JSONObject();
                fileEffDomain.put("fileName", (Object)"metamodel/domain.xml");
                fileEffDomain.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)cloned_domain)).getBytes());
                array.put((Object)fileEffDomain);
            }
            HashMap<String, Document> otherModelDocuments = new HashMap<String, Document>();
            for (Object mcv : EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName()).getEffectivePackage()) {
                String string = mcv.getName();
                extractResourcesResp = this.models.extraction(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), new QName(mcv.getTargetNamespace(), mcv.getName()), null, Arrays.asList(GJaxbStatusType.ACTIVE), Arrays.asList(GJaxbStatusType.SHARE), null, null);
                model = extractResourcesResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel();
                this.extractSpecificExportDocuments(model, otherModelDocuments, user.getCurrentCollaborationName());
                if (extractResourcesResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel() == null) continue;
                docResources = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)model);
                otherModelDocuments.put(string, docResources);
            }
            for (Object mcv : EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName()).getEffectivePackage()) {
                String string = mcv.getName();
                extractResourcesResp = this.models.extraction(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), new QName(mcv.getTargetNamespace(), mcv.getName()), null, Arrays.asList(GJaxbStatusType.FREEZE), Arrays.asList(GJaxbStatusType.SHARE), null, null);
                model = extractResourcesResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel();
                this.extractSpecificExportDocuments(model, otherModelDocuments, user.getCurrentCollaborationName());
                if (extractResourcesResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel() == null) continue;
                docResources = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)model);
                otherModelDocuments.put("freezed_" + string, docResources);
            }
            JSONObject fileProject = new JSONObject();
            fileProject.put("fileName", (Object)"models/project.xml");
            fileProject.put("fileContent", (Object)XMLPrettyPrinter.print((Node)docProject).getBytes());
            array.put((Object)fileProject);
            for (Map.Entry entry : otherModelDocuments.entrySet()) {
                JSONObject fileResources3 = new JSONObject();
                fileResources3.put("fileName", (Object)("models/" + ((String)entry.getKey()).toLowerCase() + ".xml"));
                fileResources3.put("fileContent", (Object)XMLPrettyPrinter.print((Node)((Node)entry.getValue())).getBytes());
                array.put((Object)fileResources3);
            }
            GJaxbGenericModel users = this.models.query(user, "match (personOrCommunity:ACTIVE)-[:`" + String.valueOf(GenericModelHelper.collab((String)"Assigned_To")) + "`]->(u:`" + String.valueOf(GenericModelHelper.system((String)"User")) + "`) return distinct u", null);
            for (Object userN : users.getNode()) {
                System.out.println("user name: " + GenericModelHelper.getName((GJaxbNode)userN));
                Document docUser = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)userN);
                JSONObject userResources = new JSONObject();
                userResources.put("fileName", (Object)("users/" + userN.getId() + "/" + userN.getId() + ".xml"));
                userResources.put("fileContent", (Object)XMLPrettyPrinter.print((Node)docUser).getBytes());
                array.put((Object)userResources);
                GJaxbProperty pictureProp = GenericModelHelper.findProperty((String)"picture", (List)userN.getProperty());
                if (pictureProp == null || pictureProp.getValue() == null || pictureProp.getValue().contains("/share/assets")) continue;
                String pictureFile = pictureProp.getValue().substring(pictureProp.getValue().indexOf(RIOConstant.WEBJARS_RESOURCES_FOLDER) + RIOConstant.WEBJARS_RESOURCES_FOLDER.length(), pictureProp.getValue().length());
                String fileName = pictureFile.replace("\\", "/");
                String path = RIOConstant.RESOURCES_FOLDER + "/" + pictureFile;
                JSONObject fileResources2 = new JSONObject();
                fileResources2.put("fileName", (Object)fileName);
                fileResources2.put("fileContent", (Object)FileUtils.readFileToByteArray((File)new File(path)));
                array.put((Object)fileResources2);
            }
            List<GJaxbInterpretationConfig> list = this.interpretationRules.getRules(user);
            for (GJaxbInterpretationConfig rule : list) {
                LOG.debug("exporting rule " + rule.getName());
                ArrayList<GJaxbEventAction> eventActionsCloned = new ArrayList<GJaxbEventAction>();
                for (GJaxbEventAction ea2 : rule.getEventAction()) {
                    GJaxbEventAction eaCloned = (GJaxbEventAction)GenericModelHelper.clone((AbstractJaxbObject)ea2, GJaxbEventAction.class);
                    eventActionsCloned.add(eaCloned);
                }
                rule.getEventAction().forEach(ea -> ea.getPublishDestination().removeIf(dest -> dest.contains("HighLevelInterpretationNotifier")));
                Object pathOfRules = "interpretation_rules/";
                if (rule.getMlConfig() != null) {
                    pathOfRules = (String)pathOfRules + "ml_rules/" + RegExpHelper.toRegexFriendlyName((String)rule.getName()) + "/resources/";
                    fileResources = new JSONObject();
                    fileResources.put("fileName", (Object)((String)pathOfRules + "mlConfig.xml"));
                    fileResources.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)rule)).getBytes());
                    array.put((Object)fileResources);
                } else {
                    pathOfRules = (String)pathOfRules + "cep_rules/";
                    fileResources = new JSONObject();
                    fileResources.put("fileName", (Object)((String)pathOfRules + RegExpHelper.toRegexFriendlyName((String)rule.getId()) + ".xml"));
                    fileResources.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)rule)).getBytes());
                    array.put((Object)fileResources);
                }
                rule.getEventAction().clear();
                rule.getEventAction().addAll(eventActionsCloned);
            }
            DistanceTimeMatrixManager matrixCache = GlobalDistanceTimeMatrices.get((String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName());
            if (matrixCache != null) {
                GJaxbDistanceTimeMatrix matrixCacheModel = matrixCache.getCachedMatrix();
                JSONObject fileResources4 = new JSONObject();
                fileResources4.put("fileName", (Object)CACHE_MATRIX_PATH);
                fileResources4.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)matrixCacheModel)).getBytes());
                array.put((Object)fileResources4);
            }
            String pathOfGameScenarios = "game_scenarios/";
            GJaxbExportGameScenarios exportReq = new GJaxbExportGameScenarios();
            exportReq.setCollaborationName(user.getCurrentCollaborationName());
            exportReq.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            GJaxbExportGameScenariosResponse exportResp = this.gmClient.exportGameScenarios(exportReq);
            for (GJaxbGameScenario gs : exportResp.getGameScenario()) {
                gs.setMongoDBId(null);
                for (GJaxbSensorControlerBackup rds : gs.getSensorControlerBackup()) {
                    if (rds.getDatasetInfo() == null) continue;
                    DataHandler dh = rds.getDatasetInfo().getZip();
                    String buffer = GZipUtil.unzip((byte[])dh.getDataSource().getInputStream().readAllBytes());
                    String datasetName = rds.getDatasetInfo().getName();
                    rds.getDatasetInfo().setZip(null);
                    rds.getDatasetInfo().setUrl("./datasets/" + gs.getScenarioId() + "/" + datasetName + ".xml");
                    JSONObject fileResources5 = new JSONObject();
                    String datasetFileName = pathOfGameScenarios + "datasets/" + gs.getScenarioId() + "/" + datasetName + ".xml";
                    if (this.containsFile(array, datasetFileName)) continue;
                    fileResources5.put("fileName", (Object)datasetFileName);
                    fileResources5.put("fileContent", (Object)buffer.getBytes());
                    array.put((Object)fileResources5);
                }
                String gsFileName = pathOfGameScenarios + gs.getName() + ".xml";
                if (this.containsFile(array, gsFileName)) continue;
                JSONObject fileResources2 = new JSONObject();
                fileResources2.put("fileName", (Object)gsFileName);
                fileResources2.put("fileContent", (Object)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)gs)).getBytes());
                array.put((Object)fileResources2);
            }
            if (user.isAdmin() && request.getOptions().getSaveTimeSeriesDb().booleanValue()) {
                GJaxbBackupTimeSeriesDB backupReq = new GJaxbBackupTimeSeriesDB();
                backupReq.setCollaborationName(user.getCurrentCollaborationName());
                backupReq.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                GJaxbBackupTimeSeriesDBResponse backupResp = this.sensorManagerClient.backupTimeSeriesDB(backupReq);
                for (DataHandler dh : backupResp.getZip()) {
                    String pathOfDatabase = "database/";
                    fileResources = new JSONObject();
                    String tsSimpleName = dh.getName().substring(dh.getName().lastIndexOf("/") + "/".length(), dh.getName().length());
                    String tsDbFileName = pathOfDatabase + "backup/timeseries/" + tsSimpleName;
                    fileResources.put("fileName", (Object)tsDbFileName);
                    fileResources.put("fileContent", (Object)IOUtils.toByteArray((InputStream)dh.getInputStream()));
                    array.put((Object)fileResources);
                }
            }
            File rootDirectory = new File(RIOConstant.RESOURCES_FOLDER);
            rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()));
            rootDirectory = new File(rootDirectory, RegExpHelper.toRegexFriendlyName((String)request.getProjectName()));
            IOFileFilter filter = new IOFileFilter(this){

                public boolean accept(File dir, String name) {
                    return !name.startsWith(".");
                }

                public boolean accept(File file) {
                    return !file.getName().startsWith(".");
                }
            };
            if (rootDirectory.exists() && rootDirectory.isDirectory() && (files = FileUtils.listFilesAndDirs((File)rootDirectory, (IOFileFilter)filter, (IOFileFilter)filter)) != null && files.size() > 0) {
                for (File file : files) {
                    fileResources = new JSONObject();
                    if (!file.isFile()) continue;
                    String path = file.getPath().substring(file.getPath().indexOf(RegExpHelper.toRegexFriendlyName((String)request.getProjectName())) + RegExpHelper.toRegexFriendlyName((String)request.getProjectName()).length(), file.getPath().indexOf(file.getName()));
                    path = path.replace("\\", "/");
                    fileResources.put("fileName", (Object)(path + file.getName()));
                    fileResources.put("fileContent", (Object)FileUtils.readFileToByteArray((File)file));
                    array.put((Object)fileResources);
                }
            }
            StreamingOutput stream = new StreamingOutput(){

                public void write(OutputStream output) throws IOException, WebApplicationException {
                    ZipOutputStream zos = new ZipOutputStream(output);
                    for (int i = 0; i < array.length(); ++i) {
                        ZipEntry ze = new ZipEntry(array.getJSONObject(i).getString("fileName"));
                        zos.putNextEntry(ze);
                        zos.write((byte[])array.getJSONObject(i).get("fileContent"));
                        zos.closeEntry();
                    }
                    zos.flush();
                    zos.close();
                }
            };
            response = Response.ok((Object)stream).header("Content-Disposition", (Object)("attachment; filename=" + RegExpHelper.toRegexFriendlyName((String)request.getProjectName()).toLowerCase() + ".zip")).header("Content-Transfer-Encoding", (Object)"binary").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    private GJaxbEffectivePackage keepOnlyAddedClassInPackage(GJaxbEffectivePackage effP, String collaborationName) throws Exception {
        QName newType;
        GJaxbEffectivePackage neffP = new GJaxbEffectivePackage();
        neffP.setName(effP.getName());
        neffP.setEffectiveMetaModelOfPackage(new GJaxbEffectivePackage.EffectiveMetaModelOfPackage());
        neffP.getEffectiveMetaModelOfPackage().setEffectiveMetaModel(new GJaxbEffectiveMetaModel());
        neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().setName(effP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getName());
        neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().setRules(new GJaxbRules());
        neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().setConnectionRules(new GJaxbConnectionRules());
        neffP.setRules(new GJaxbEffectivePackage.Rules());
        neffP.getRules().setContainmentRule(new GJaxbContainmentRule());
        for (GJaxbEffectiveConceptType concept : effP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
            if (!concept.getType().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) continue;
            neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().add(concept);
        }
        for (GJaxbConnectionRule rule : effP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule()) {
            GJaxbEffectiveConceptType from = EffectiveMetaModelPluginManager.getInstance().getConceptByType(rule.getFrom());
            GJaxbEffectiveConceptType to = EffectiveMetaModelPluginManager.getInstance().getConceptByType(rule.getTo());
            if (from == null && to == null) continue;
            for (GJaxbEffectiveConceptType concept : neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
                if (!concept.getType().equals(rule.getFrom()) && !concept.getType().equals(rule.getTo())) continue;
                neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule().add(rule);
            }
        }
        for (GJaxbEffectiveConceptType concept : neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
            if (!concept.getType().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) continue;
            newType = new QName(concept.getType().getNamespaceURI().replace(RegExpHelper.toRegexFriendlyName((String)collaborationName), "${collab}"), concept.getType().getLocalPart());
            concept.setType(newType);
        }
        for (GJaxbConnectionRule rule : neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule()) {
            if (rule.getRelationType().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) {
                newType = new QName(rule.getRelationType().getNamespaceURI().replace(RegExpHelper.toRegexFriendlyName((String)collaborationName), "${collab}"), rule.getRelationType().getLocalPart());
                rule.setRelationType(newType);
            }
            if (rule.getFrom().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) {
                newType = new QName(rule.getFrom().getNamespaceURI().replace(RegExpHelper.toRegexFriendlyName((String)collaborationName), "${collab}"), rule.getFrom().getLocalPart());
                rule.setFrom(newType);
            }
            if (!rule.getTo().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) continue;
            newType = new QName(rule.getTo().getNamespaceURI().replace(RegExpHelper.toRegexFriendlyName((String)collaborationName), "${collab}"), rule.getTo().getLocalPart());
            rule.setTo(newType);
        }
        for (GJaxbEffectiveConceptType concept : neffP.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
            if (concept.isAbstract().booleanValue()) continue;
            GJaxbContainmentRule.Contain _contain = new GJaxbContainmentRule.Contain();
            _contain.setType(concept.getType());
            neffP.getRules().getContainmentRule().getContain().add(_contain);
        }
        return neffP;
    }

    private void extractSpecificExportDocuments(GJaxbGenericModel model, Map<String, Document> otherDocuments, String collaborationName) throws Exception {
        GJaxbGenericModel newModel;
        HashMap<String, GJaxbGenericModel> newExportedModels = new HashMap<String, GJaxbGenericModel>();
        for (GJaxbNode gJaxbNode : model.getNode()) {
            if (gJaxbNode.getType().getNamespaceURI().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) {
                QName newType = new QName(gJaxbNode.getType().getNamespaceURI().replace(RegExpHelper.toRegexFriendlyName((String)collaborationName), "${collab}"), gJaxbNode.getType().getLocalPart());
                gJaxbNode.setType(newType);
            }
            if (!gJaxbNode.isSetSpecificExportPackage() || gJaxbNode.getSpecificExportPackage().isBlank()) continue;
            newModel = (GJaxbGenericModel)newExportedModels.get(gJaxbNode.getSpecificExportPackage());
            if (newModel == null) {
                newModel = new GJaxbGenericModel();
                newExportedModels.put(gJaxbNode.getSpecificExportPackage(), newModel);
            }
            newModel.getNode().add(gJaxbNode);
        }
        for (GJaxbEdge gJaxbEdge : model.getEdge()) {
            if (!gJaxbEdge.isSetSpecificExportPackage() || gJaxbEdge.getSpecificExportPackage().isBlank()) continue;
            newModel = (GJaxbGenericModel)newExportedModels.get(gJaxbEdge.getSpecificExportPackage());
            if (newModel == null) {
                newModel = new GJaxbGenericModel();
                newExportedModels.put(gJaxbEdge.getSpecificExportPackage(), newModel);
            }
            newModel.getEdge().add(gJaxbEdge);
        }
        for (GJaxbGenericModel gJaxbGenericModel : newExportedModels.values()) {
            model.getNode().removeIf(n -> GenericModelHelper.contains((GJaxbNode)n, (List)newModel2.getNode()));
            model.getEdge().removeIf(e -> GenericModelHelper.contains((GJaxbEdge)e, (List)newModel2.getEdge()));
        }
        for (Map.Entry entry : newExportedModels.entrySet()) {
            otherDocuments.put((String)entry.getKey(), XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)entry.getValue()));
        }
    }

    private boolean containsFile(JSONArray array, String fileName) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject rsc = array.getJSONObject(i);
            if (!rsc.getString("fileName").equals(fileName)) continue;
            return true;
        }
        return false;
    }

    @POST
    @jakarta.ws.rs.Path(value="/importProject")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String importProject(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        JSONObject response = new JSONObject();
        String projectName = fileDetail.getFileName().substring(0, fileDetail.getFileName().lastIndexOf("."));
        projectName = projectName.replaceAll("(\\s\\(\\d\\))+", "");
        String newKnowledgeSpaceName = RegExpHelper.toRegexFriendlyName((String)projectName);
        File userProjectDir = new File(RIOConstant.RESOURCES_FOLDER + "/users/" + user.getUserId() + "/" + newKnowledgeSpaceName);
        ZipUtil.unZip((InputStream)is, (File)userProjectDir);
        RIOAbstractProject internalProject = new RIOAbstractProject(this, userProjectDir.toString()){

            public void beforeInit() throws Exception {
            }

            public void afterInit() throws Exception {
            }
        };
        internalProject.getUsecaseDef().setLocation(GJaxbLocationType.DOWNLOADED);
        internalProject.getMap().forEach((k, v) -> v.forEach(r -> r.setSelected(true)));
        GJaxbNode projectNode = this.loadProject(internalProject, user.getCurrentCollaborationName(), internalProject.getUsecaseDef().getName(), user, false, false, new ArrayList<String>(), false);
        response.put("projectId", (Object)projectNode.getId());
        response.put("projectName", (Object)GenericModelHelper.getName((GJaxbNode)projectNode));
        FileUtils.deleteQuietly((File)userProjectDir);
        return response.toString();
    }

    @GET
    @jakarta.ws.rs.Path(value="/exportExcelData/{projectId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportExcelData(@Auth DWUser user, @PathParam(value="projectId") String projectId, @QueryParam(value="projectName") String projectName) throws Exception {
        GJaxbGenericModel projectModel = this.models.query(user, "Match (n:`" + user.getCurrentCollaborationName() + "`:`" + user.getCurrentKnowledgeSpaceName() + "` { type : '{" + this.projectEffectiveModeler.getTargetNamespace() + "}Project'}) where n.modelNodeId =~ '.*" + projectId + ".*' return n;", null);
        projectModel.setName(GenericModelHelper.getName((GJaxbNode)((GJaxbNode)projectModel.getNode().get(0))));
        String shortProjectId = RegExpHelper.toRegexFriendlyName((String)projectId);
        HashMap<String, GJaxbGenericModel> otherDocuments = new HashMap<String, GJaxbGenericModel>();
        for (Object mcv : EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName()).getEffectivePackage()) {
            String category = mcv.getName();
            GJaxbSynchronizeResponse extractResourcesResp = this.models.extraction(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), new QName(mcv.getTargetNamespace(), mcv.getName()), null, Arrays.asList(GJaxbStatusType.ACTIVE), Arrays.asList(GJaxbStatusType.SHARE), null, null);
            otherDocuments.put(category, extractResourcesResp.getSyncResponse().getExtractSyncModelResponse().getGenericModel());
        }
        ArrayList<GJaxbEffectiveMetaModel> effmodels = new ArrayList<GJaxbEffectiveMetaModel>();
        for (GJaxbEffectivePackage mcv : EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName()).getEffectivePackage()) {
            if (mcv.getName().toLowerCase().equals(PluginCollaborativeModel.PROCESS_PACKAGE_NAME.toLowerCase())) continue;
            effmodels.add(mcv.getEffectiveMetaModelOfPackage().getEffectiveMetaModel());
        }
        ExcelModelWriter writer = new ExcelModelWriter(effmodels.toArray(new GJaxbEffectiveMetaModel[effmodels.size()]));
        ByteArrayOutputStream os = writer.writeInByteArray(otherDocuments.values().toArray(new GJaxbGenericModel[otherDocuments.values().size()]));
        return Response.ok((Object)os.toByteArray(), (String)"application/octet-stream").build();
    }

    @POST
    @jakarta.ws.rs.Path(value="/importExcelData")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String importExcelData(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        String projectId;
        JSONObject response = new JSONObject();
        JSONObject dataJson = new JSONObject(data);
        String shortProjectId = projectId = dataJson.get("projectId").toString();
        if (projectId.indexOf("_c__") > 0) {
            shortProjectId = shortProjectId.substring(0, projectId.indexOf("_c__"));
        }
        ArrayList<GJaxbEffectiveMetaModel> effmodels = new ArrayList<GJaxbEffectiveMetaModel>();
        for (GJaxbEffectivePackage mcv : EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName()).getEffectivePackage()) {
            if (mcv.getName().toLowerCase().equals(PluginCollaborativeModel.PROCESS_PACKAGE_NAME.toLowerCase())) continue;
            effmodels.add(mcv.getEffectiveMetaModelOfPackage().getEffectiveMetaModel());
        }
        ExcelModelReader excelReader = new ExcelModelReader(effmodels.toArray(new GJaxbEffectiveMetaModel[effmodels.size()]));
        Map dataModels = excelReader.read(is);
        for (Map.Entry dataModel : dataModels.entrySet()) {
            this.models.publish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), (GJaxbGenericModel)dataModel.getValue(), null, null);
        }
        return response.toString();
    }

    @GET
    @jakarta.ws.rs.Path(value="/containsRangeOnMetricsOrIndicators/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String containsRangeOnMetricsOrIndicators(@Auth DWUser user, @PathParam(value="id") String id, @QueryParam(value="qid") String qid) throws Exception {
        JSONObject res = new JSONObject();
        String collaborationName = user.getCurrentCollaborationName();
        String knowledgeSpaceName = user.getCurrentKnowledgeSpaceName();
        GJaxbNode project = null;
        try {
            project = this.system.getKnowledgeSpace(user, id, qid);
            IndicatorManager indManager = new IndicatorManager(project);
            ArrayList metricsOrIndicatorsProperties = new ArrayList();
            GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName());
            GJaxbEffectiveMetaModel effMeta = effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel();
            effMeta.getEffectiveConcept().forEach(n -> n.getMetaProperty().forEach(p -> {
                if (p.getType() == GJaxbFormtypeType.METRIC && !metricsOrIndicatorsProperties.contains(p.getName())) {
                    metricsOrIndicatorsProperties.add(p.getName());
                }
            }));
            indManager.getIndicators().keySet().forEach(indicatorName -> metricsOrIndicatorsProperties.add(indicatorName));
            StringBuffer condition = new StringBuffer();
            metricsOrIndicatorsProperties.forEach(p -> condition.append("(exists(c.`property_" + p + "`) and c.`property_" + p + "` contains 'ranges') or "));
            GJaxbGenericModel rangesModel = this.models.query(user, "match (c:ACTIVE:`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`:`" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "` ) where " + condition.toString().substring(0, condition.toString().length() - " or ".length()) + " return c;", null);
            if (!rangesModel.getNode().isEmpty()) {
                res.put("hasRanges", true);
            } else {
                res.put("hasRanges", false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return res.toString();
    }
}

