/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.RestWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.json_connector.GJaxbData;
import fr.emac.gind.json_connector.GJaxbPoint;
import fr.emac.gind.json_connector.GJaxbPosition;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.json_connector.GJaxbSensorNatureSocialType;
import fr.emac.gind.json_connector.GJaxbSensorType;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.sensors.manager.SensorManager;
import fr.emac.gind.sensors.manager.SensorManagerClient;
import fr.emac.gind.sensors.manager.SensorUIConfigurationHelper;
import fr.emac.gind.sensors.manager.data.GJaxbContinuousSignalInput;
import fr.emac.gind.sensors.manager.data.GJaxbContinuousSignalIsStartedOnJSONConnector;
import fr.emac.gind.sensors.manager.data.GJaxbContinuousSignalIsStartedOnJSONConnectorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbContinuousSignalOutput;
import fr.emac.gind.sensors.manager.data.GJaxbCreateSensor;
import fr.emac.gind.sensors.manager.data.GJaxbCreateSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbDeleteSensor;
import fr.emac.gind.sensors.manager.data.GJaxbDeleteSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByInternalUrl;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByInternalUrlResponse;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByProtocol;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByProtocolResponse;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByTopic;
import fr.emac.gind.sensors.manager.data.GJaxbFindSensorByTopicResponse;
import fr.emac.gind.sensors.manager.data.GJaxbGetSensor;
import fr.emac.gind.sensors.manager.data.GJaxbGetSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbGetSensors;
import fr.emac.gind.sensors.manager.data.GJaxbGetSensorsResponse;
import fr.emac.gind.sensors.manager.data.GJaxbListen;
import fr.emac.gind.sensors.manager.data.GJaxbListenResponse;
import fr.emac.gind.sensors.manager.data.GJaxbPauseContinuousSignalOnJSONConnector;
import fr.emac.gind.sensors.manager.data.GJaxbPauseContinuousSignalOnJSONConnectorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbSetLocked;
import fr.emac.gind.sensors.manager.data.GJaxbSetLockedResponse;
import fr.emac.gind.sensors.manager.data.GJaxbStartContinuousSignalOnJSONConnector;
import fr.emac.gind.sensors.manager.data.GJaxbStartContinuousSignalOnJSONConnectorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbStartSensor;
import fr.emac.gind.sensors.manager.data.GJaxbStartSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbStopSensor;
import fr.emac.gind.sensors.manager.data.GJaxbStopSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbUpdateConfigOfSensor;
import fr.emac.gind.sensors.manager.data.GJaxbUpdateConfigOfSensorResponse;
import fr.emac.gind.sensors.manager.data.GJaxbUpdateContinuousSignalOnJSONConnector;
import fr.emac.gind.sensors.manager.data.GJaxbUpdateContinuousSignalOnJSONConnectorResponse;
import fr.emac.gind.sensors.model.GJaxbSensorModel;
import fr.emac.gind.sensors.model.GJaxbSensorUIConfiguration;
import fr.emac.gind.tweet.GJaxbMediaObject;
import fr.emac.gind.tweet.GJaxbTweetObject;
import fr.emac.gind.websocket.command.WebsocketCommand;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Path(value="/{app}/sensorManager")
@Produces(value={"application/json"})
public class SensorManagerResource {
    private static Logger LOG = LoggerFactory.getLogger(SensorManagerResource.class);
    private SensorManager sensorManagerClient = null;
    private FileResource fileResource = null;
    private NotificationConsumerWebService logConsumer = null;
    private Map<QName, String> subscriptionIds = Collections.synchronizedMap(new HashMap());
    private AbstractNotifierClient notifier = null;
    private WebsocketCommand webSocketCommand = null;
    private Configuration conf = null;

    public SensorManagerResource(Configuration conf, FileResource fileResource, NotificationConsumerWebService consumer, AbstractNotifierClient notifier, WebsocketCommand command) throws Exception {
        this.sensorManagerClient = SensorManagerClient.createClient((String)((String)conf.getProperties().get("sensor-manager-server")));
        this.fileResource = fileResource;
        this.logConsumer = consumer;
        this.notifier = notifier;
        this.webSocketCommand = command;
        this.conf = conf;
        if (this.logConsumer == null) {
            throw new Exception("LogConsumer cannot be null !!!");
        }
    }

    @POST
    @Path(value="/createSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCreateSensorResponse createSensor(@Auth DWUser user, GJaxbCreateSensor req) throws Exception {
        GJaxbCreateSensorResponse response = null;
        try {
            String nature;
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            if ((nature = GenericModelHelper.findProperty((String)"nature", (List)req.getNode().getProperty()).getValue()).toLowerCase().equals("twitter")) {
                String twitterKey = SensorManagerResource.createTwitterKey(user);
                req.setContext(new GJaxbCreateSensor.Context());
                req.getContext().getProperty().add(GenericModelHelper.createProperty((String)"twitterKey", (String)twitterKey));
            }
            response = SensorManagerResource.createEventSensor(this.sensorManagerClient, this.fileResource, user, req);
            if (req.isSetStartSensor() && req.isStartSensor()) {
                for (QName topicProvided : response.getSensorModel().getTopicsProvided()) {
                    String subscriptionId = ((AbstractNotifierClient)this.logConsumer.getImplementation(this.notifier.getClass())).subscribeOn(response.getSensorModel().getInternalUrl(), topicProvided);
                    this.subscriptionIds.put(topicProvided, subscriptionId);
                }
                JSONObject method = new JSONObject();
                method.put("method_name", (Object)"startSensor");
                method.put("method_status", (Object)"SUCCESSFUL");
            }
        }
        catch (Exception e) {
            if (req.isSetStartSensor() && req.isStartSensor()) {
                JSONObject method = new JSONObject();
                method.put("method_name", (Object)"startSensor");
                method.put("method_status", (Object)"ERROR");
                GJaxbSensorModel agent = new GJaxbSensorModel();
                agent.setName(GenericModelHelper.findProperty((String)"name", (List)req.getNode().getProperty()).getValue());
                agent.setStatus(null);
            }
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    public static String createTwitterKey(DWUser user) throws Exception {
        String twitterKey = null;
        JSONArray twitterAPI = new JSONArray(user.getPropertyValue("Twitter API"));
        if (twitterAPI.length() > 0) {
            List tweetProps = GenericModelHelper.convertJSONArrayToPropertyList((JSONArray)twitterAPI.getJSONArray(0));
            String consumer_key = GenericModelHelper.findProperty((String)"consumer key", (List)tweetProps).getValue();
            String consumer_secret = GenericModelHelper.findProperty((String)"consumer secret", (List)tweetProps).getValue();
            String token = GenericModelHelper.findProperty((String)"token", (List)tweetProps).getValue();
            String token_secret = GenericModelHelper.findProperty((String)"token secret", (List)tweetProps).getValue();
            if (consumer_key != null && consumer_secret != null && token != null && token_secret != null) {
                twitterKey = Base64.getEncoder().encodeToString(new String(consumer_key + "@@@" + consumer_secret + "@@@" + token + "@@@" + token_secret).getBytes());
            }
        } else if (System.getenv("TWITTER_CONSUMER_KEY") != null && System.getenv("TWITTER_CONSUMER_SECRET") != null && System.getenv("TWITTER_TOKEN") != null && System.getenv("TWITTER_TOKEN_SECRET") != null) {
            twitterKey = Base64.getEncoder().encodeToString(new String(System.getenv("TWITTER_CONSUMER_KEY") + "@@@" + System.getenv("TWITTER_CONSUMER_SECRET") + "@@@" + System.getenv("TWITTER_TOKEN") + "@@@" + System.getenv("TWITTER_TOKEN_SECRET")).getBytes());
        }
        if (twitterKey == null) {
            throw new Exception("twitterKey cannot be null. Add twitter informations in your r-io account or in environment variable");
        }
        return twitterKey;
    }

    public static GJaxbCreateSensorResponse createEventSensor(SensorManager epsClient, FileResource fileResource, DWUser user, GJaxbCreateSensor req) throws Exception {
        String uiConfigurationURL = GenericModelHelper.findProperty((String)"ui configuration", (List)req.getNode().getProperty(), (boolean)true).getValue();
        if (uiConfigurationURL != null && !uiConfigurationURL.isBlank()) {
            uiConfigurationURL = uiConfigurationURL.replace("resourcesFolder/", "resourcesFolder/" + RegExpHelper.toRegexFriendlyName((String)user.getCurrentCollaborationName()) + "/");
            uiConfiguration = SensorManagerResource.getUIConfiguration(fileResource, user, uiConfigurationURL);
            req.setSensorUIConfiguration(uiConfiguration);
        } else {
            uiConfiguration = SensorManagerResource.createUIConfiguration(fileResource, user, req.getNode());
            req.setSensorUIConfiguration(uiConfiguration);
        }
        GJaxbCreateSensorResponse response = epsClient.createSensor(req);
        response.setUserData("input_request", (Object)GenericModelHelper.getName((GJaxbNode)req.getNode()));
        response.getSensorModel().getNode().setBrokenEdges(null);
        return response;
    }

    @POST
    @Path(value="/startSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStartSensorResponse startSensor(@Auth DWUser user, GJaxbStartSensor req) throws Exception {
        GJaxbStartSensorResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.startSensor(req);
            for (QName topicProvided : response.getSensorModel().getTopicsProvided()) {
                String subscriptionId = ((AbstractNotifierClient)this.logConsumer.getImplementation(this.notifier.getClass())).subscribeOn(req.getUrl(), topicProvided);
                this.subscriptionIds.put(topicProvided, subscriptionId);
            }
            JSONObject method = new JSONObject();
            method.put("method_name", (Object)"startSensor");
            method.put("method_status", (Object)"SUCCESSFUL");
        }
        catch (Exception e) {
            GJaxbFindSensorByInternalUrl find = new GJaxbFindSensorByInternalUrl();
            find.setUrl(req.getUrl());
            find.setCollaborationName(req.getCollaborationName());
            find.setKnowledgeSpaceName(req.getKnowledgeSpaceName());
            GJaxbFindSensorByInternalUrlResponse findResp = this.sensorManagerClient.findSensorByInternalUrl(find);
            JSONObject method = new JSONObject();
            method.put("method_name", (Object)"startSensor");
            method.put("method_status", (Object)"ERROR");
            GindWebApplicationException.manageError(e, this);
        }
        JSONObject jsonMsg = new JSONObject("{ \"user\" : \"" + user.getName() + "\", \"req.getUrl\" : \"" + req.getUrl() + "\" }");
        LOG.debug(jsonMsg.toString());
        LOG.debug("Start event producer at url: " + req.getUrl());
        return response;
    }

    @POST
    @Path(value="/stopSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStopSensorResponse stopSensor(@Auth DWUser user, GJaxbStopSensor req) throws Exception {
        GJaxbStopSensorResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            for (String subscriptionId : this.subscriptionIds.values()) {
                ((AbstractNotifierClient)this.logConsumer.getImplementation(this.notifier.getClass())).unsubscribeOn(req.getUrl(), subscriptionId);
            }
            response = this.sensorManagerClient.stopSensor(req);
            JSONObject method = new JSONObject();
            method.put("method_name", (Object)"stopSensor");
            method.put("method_status", (Object)"SUCCESSFUL");
        }
        catch (Exception e) {
            e.printStackTrace();
            GJaxbFindSensorByInternalUrl find = new GJaxbFindSensorByInternalUrl();
            find.setUrl(req.getUrl());
            find.setCollaborationName(req.getCollaborationName());
            find.setKnowledgeSpaceName(req.getKnowledgeSpaceName());
            GJaxbFindSensorByInternalUrlResponse findResp = this.sensorManagerClient.findSensorByInternalUrl(find);
            JSONObject method = new JSONObject();
            method.put("method_name", (Object)"stopSensor");
            method.put("method_status", (Object)"ERROR");
            GindWebApplicationException.manageError(e, this);
        }
        JSONObject jsonMsg = new JSONObject("{ \"user\" : \"" + user.getName() + "\", \"req.getUrl\" : \"" + req.getUrl() + "\" }");
        LOG.debug(jsonMsg.toString());
        return response;
    }

    @POST
    @Path(value="/deleteSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbDeleteSensorResponse deleteSensor(@Auth DWUser user, GJaxbDeleteSensor req) throws Exception {
        GJaxbDeleteSensorResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.deleteSensor(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        LOG.debug("Start event producer at url: " + req.getUrl());
        return response;
    }

    @GET
    @Path(value="/findSensorByProtocol/{type}/{nature}/{collaborationName}/{knowledgeSpaceName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbFindSensorByProtocolResponse findSensorByProtocol(@Auth DWUser user, @PathParam(value="type") String type, @PathParam(value="nature") String nature, @PathParam(value="collaborationName") String collaborationName, @PathParam(value="knowledgeSpaceName") String knowledgeSpaceName) throws Exception {
        JSONObject jsonMsg = new JSONObject("{ \"user\" : " + user.getName() + ", \"collaborationName\" :" + collaborationName + ", \"knowledgeSpaceName\" :" + knowledgeSpaceName + ", \"type\" : " + type + ", \"nature\" : " + nature + " }");
        LOG.debug(jsonMsg.toString());
        GJaxbFindSensorByProtocolResponse response = null;
        try {
            GJaxbFindSensorByProtocol request = new GJaxbFindSensorByProtocol();
            request.setCollaborationName(collaborationName);
            request.setKnowledgeSpaceName(knowledgeSpaceName);
            if (type != null) {
                request.getType().add(type);
            }
            if (nature != null) {
                request.getNature().add(nature);
            }
            response = this.sensorManagerClient.findSensorByProtocol(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/getSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetSensorResponse getSensor(@Auth DWUser user, GJaxbGetSensor req) throws Exception {
        GJaxbGetSensorResponse response = null;
        try {
            GJaxbGetSensor request = req;
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorManagerClient.getSensor(request);
            if (response.getSensorModel() != null && response.getSensorModel().getNode() != null) {
                response.getSensorModel().getNode().setBrokenEdges(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @GET
    @Path(value="/getSensors")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetSensorsResponse getSensors(@Auth DWUser user) throws Exception {
        GJaxbGetSensorsResponse response = null;
        try {
            GJaxbGetSensors request = new GJaxbGetSensors();
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorManagerClient.getSensors(request);
            response.getSensorModel().forEach(sm -> sm.getNode().setBrokenEdges(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/setLocked")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbSetLockedResponse setLocked(@Auth DWUser user, GJaxbSetLocked request) {
        GJaxbSetLockedResponse response = null;
        try {
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.sensorManagerClient.setLocked(request);
        }
        catch (Exception e) {
            throw new RestWebApplicationException(e);
        }
        return response;
    }

    public static GJaxbSensorUIConfiguration getUIConfiguration(FileResource fileResource, DWUser user, String uiConfigurationURL) throws Exception {
        GJaxbSensorUIConfiguration uiConfiguration = null;
        if (uiConfigurationURL != null && !uiConfigurationURL.isBlank()) {
            String buffer = fileResource.download(user, uiConfigurationURL);
            if (buffer == null) {
                throw new Exception("Cannot Open URL PATH: " + uiConfigurationURL);
            }
            Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(buffer.getBytes()));
            uiConfiguration = (GJaxbSensorUIConfiguration)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbSensorUIConfiguration.class);
        }
        return uiConfiguration;
    }

    public static GJaxbSensorUIConfiguration createUIConfiguration(FileResource fileResource, DWUser user, GJaxbNode sensor) throws Exception {
        String type = GenericModelHelper.findProperty((String)"type", (List)sensor.getProperty()).getValue().toLowerCase();
        String nature = GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty()).getValue().toLowerCase();
        GJaxbSensorUIConfiguration uiConfiguration = SensorUIConfigurationHelper.createUIConfiguration((String)type, (String)nature, (GJaxbNode)sensor);
        String dataXML = XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)uiConfiguration));
        String fileName = type + "_" + nature + "UIConfig.xml";
        JSONObject data = new JSONObject();
        data.put("nodeId", (Object)sensor.getId());
        data.put("category", (Object)"node");
        data.put("collaborationName", (Object)user.getCurrentCollaborationName());
        data.put("knowledgeSpaceName", (Object)user.getCurrentKnowledgeSpaceName());
        data.put("fileName", (Object)fileName);
        String url = fileResource.upload(user, new ByteArrayInputStream(dataXML.getBytes()), FormDataContentDisposition.name((String)fileName).build(), data.toString());
        GenericModelHelper.findProperty((String)"ui configuration", (List)sensor.getProperty(), (boolean)true).setValue(url);
        return uiConfiguration;
    }

    @POST
    @Path(value="/findSensorByTopic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbFindSensorByTopicResponse findSensorByTopic(@Auth DWUser user, GJaxbFindSensorByTopic req) throws Exception {
        GJaxbFindSensorByTopicResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.findSensorByTopic(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/startContinuousSignalOnJSONConnector")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStartContinuousSignalOnJSONConnectorResponse startContinuousSignalOnJSONConnector(@Auth DWUser user, GJaxbStartContinuousSignalOnJSONConnector req) throws Exception {
        GJaxbStartContinuousSignalOnJSONConnectorResponse response = null;
        try {
            for (GJaxbContinuousSignalInput r : req.getContinuousSignalInput()) {
                if (r.getCollaborationName() == null) {
                    r.setCollaborationName(user.getCurrentCollaborationName());
                }
                if (r.getKnowledgeSpaceName() != null) continue;
                r.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.startContinuousSignalOnJSONConnector(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/pauseContinuousSignalOnJSONConnector")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbPauseContinuousSignalOnJSONConnectorResponse pauseContinuousSignalOnJSONConnector(@Auth DWUser user, GJaxbPauseContinuousSignalOnJSONConnector req) throws Exception {
        GJaxbPauseContinuousSignalOnJSONConnectorResponse response = null;
        try {
            for (GJaxbContinuousSignalOutput r : req.getContinuousSignalOutput()) {
                if (r.getCollaborationName() == null) {
                    r.setCollaborationName(user.getCurrentCollaborationName());
                }
                if (r.getKnowledgeSpaceName() != null) continue;
                r.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.pauseContinuousSignalOnJSONConnector(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/updateContinuousSignalOnJSONConnector")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateContinuousSignalOnJSONConnectorResponse updateContinuousSignalOnJSONConnector(@Auth DWUser user, GJaxbUpdateContinuousSignalOnJSONConnector req) throws Exception {
        GJaxbUpdateContinuousSignalOnJSONConnectorResponse response = null;
        try {
            for (GJaxbContinuousSignalInput r : req.getContinuousSignalInput()) {
                if (r.getCollaborationName() == null) {
                    r.setCollaborationName(user.getCurrentCollaborationName());
                }
                if (r.getKnowledgeSpaceName() != null) continue;
                r.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.updateContinuousSignalOnJSONConnector(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/continuousSignalIsStartedOnJSONConnector")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbContinuousSignalIsStartedOnJSONConnectorResponse continuousSignalIsStartedOnJSONConnector(@Auth DWUser user, GJaxbContinuousSignalIsStartedOnJSONConnector req) throws Exception {
        GJaxbContinuousSignalIsStartedOnJSONConnectorResponse response = null;
        try {
            for (GJaxbContinuousSignalOutput r : req.getContinuousSignalOutput()) {
                if (r.getCollaborationName() == null) {
                    r.setCollaborationName(user.getCurrentCollaborationName());
                }
                if (r.getKnowledgeSpaceName() != null) continue;
                r.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.continuousSignalIsStartedOnJSONConnector(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/updateConfigOfSensor")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateConfigOfSensorResponse updateConfigOfSensor(@Auth DWUser user, GJaxbUpdateConfigOfSensor req) throws Exception {
        GJaxbUpdateConfigOfSensorResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.sensorManagerClient.updateConfigOfSensor(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/sendTweetToAllSensors")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public GJaxbListenResponse sendTweetToAllSensors(@Auth DWUser user, FormDataMultiPart multiPart) {
        GJaxbListenResponse res = null;
        try {
            FormDataBodyPart jsonTweet = multiPart.getField("tweet");
            String collaborationName = multiPart.getField("collaborationName").getValue();
            String knowledgeSpaceName = multiPart.getField("knowledgeSpaceName").getValue();
            GJaxbTweetObject tweet = (GJaxbTweetObject)JSONJAXBContext.getInstance().unmarshall("{ \"tweet\" : " + jsonTweet.getValue() + " }", GJaxbTweetObject.class);
            List fileParts = multiPart.getFields("file");
            if (fileParts != null) {
                for (FormDataBodyPart part : fileParts) {
                    InputStream is = (InputStream)part.getValueAs(InputStream.class);
                    FormDataContentDisposition fileDetail = part.getFormDataContentDisposition();
                    GJaxbMediaObject media = tweet.getExtendedEntities().getMedia().stream().filter(f -> f.getMediaUrl().endsWith(fileDetail.getFileName())).findFirst().get();
                    JSONObject data = new JSONObject();
                    data.put("category", (Object)"person");
                    data.put("collaborationName", (Object)collaborationName);
                    data.put("knowledgeSpaceName", (Object)knowledgeSpaceName);
                    if (tweet.getUser() != null && tweet.getUser().getIdStr() != null && !tweet.getUser().getIdStr().isBlank()) {
                        data.put("nodeId", (Object)tweet.getUser().getIdStr());
                    } else {
                        data.put("nodeId", (Object)"shareNode");
                    }
                    Object newUrl = this.fileResource.upload(user, is, fileDetail, data.toString());
                    newUrl = ((String)newUrl).replace(RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "/", RegExpHelper.toRegexFriendlyName((String)collaborationName) + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "/");
                    String pretty_address = IPUtil.createPrettyAddressFomContext((Map)this.conf.getMapObjects());
                    newUrl = pretty_address + (String)newUrl;
                    media.setMediaUrl((String)newUrl);
                }
            }
            GJaxbFindSensorByProtocolResponse resp = this.findSensorByProtocol(user, "Social", "Twitter", collaborationName, knowledgeSpaceName);
            for (GJaxbSensorModel sensorModel : resp.getSensorModel()) {
                GJaxbSensorEvent sensorEvent = new GJaxbSensorEvent();
                sensorEvent.setEventId("event_" + String.valueOf(UUID.randomUUID()));
                sensorEvent.setSensorId(sensorModel.getNode().getId());
                sensorEvent.setSensorType(GJaxbSensorType.SOCIAL);
                sensorEvent.setSensorNature(new GJaxbSensorEvent.SensorNature());
                sensorEvent.getSensorNature().setSocialNature(GJaxbSensorNatureSocialType.TWITTER);
                sensorEvent.setDate(XMLGregorianCalendarHelper.getInstance().getNewCalendar());
                tweet.setCreatedAt(sensorEvent.getDate().toString());
                tweet.setIdStr("tweet_" + sensorEvent.getEventId());
                sensorEvent.setSensorEventIndex(-1);
                sensorEvent.setSensorEventStackIndex(Integer.valueOf(0));
                sensorEvent.setSensorColor(ColorHelper.formatColorToHexaString((Color)ColorHelper.randomBrighterColor()));
                sensorEvent.setData(new GJaxbData());
                sensorEvent.getData().setSocial(new GJaxbData.Social());
                sensorEvent.getData().getSocial().setValue(new GJaxbData.Social.Value());
                sensorEvent.getData().getSocial().getValue().setTweet(tweet);
                sensorEvent.setPosition(new GJaxbPosition());
                sensorEvent.getPosition().setPoint(new GJaxbPoint());
                sensorEvent.getPosition().getPoint().setLatitude(Float.parseFloat((String)tweet.getCoordinates().getCoordinates().get(0)));
                sensorEvent.getPosition().getPoint().setLongitude(Float.parseFloat((String)tweet.getCoordinates().getCoordinates().get(1)));
                Document payload = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)sensorEvent);
                GJaxbListen request = new GJaxbListen();
                request.setPayload(new GJaxbListen.Payload());
                request.getPayload().setAny((Object)payload.getDocumentElement());
                request.setCollaborationName(collaborationName);
                request.setKnowledgeSpaceName(knowledgeSpaceName);
                request.setDataSourceId(sensorModel.getNode().getId());
                res = this.sensorManagerClient.listen(request);
            }
        }
        catch (Exception e) {
            throw new RestWebApplicationException(e);
        }
        return res;
    }
}

