/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources.gov;

import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.eventcommonsdata.GJaxbInstanceInfo;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNode;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNodeResponse;
import fr.emac.gind.gov.deduction.Deduction;
import fr.emac.gind.gov.deduction.GJaxbDeduceASync;
import fr.emac.gind.gov.deduction.GJaxbDeduceASyncResponse;
import fr.emac.gind.gov.deduction.client.DeductionClient;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatus;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatusResponse;
import fr.emac.gind.indicators.plugin.IndicatorsRangeStrategyPluginManager;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.monitoring.client.ProcessMonitoringClient;
import fr.emac.gind.process.GJaxbDeployResult;
import fr.emac.gind.process.GJaxbUndeployResponse;
import fr.emac.gind.process.instance.GJaxbExecType;
import fr.emac.gind.process.instance.GJaxbRunASync;
import fr.emac.gind.process.instance.GJaxbRunASyncResponse;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.processgeneratorinstance.GJaxbProcessGeneratorInstance;
import fr.emac.gind.processgeneratorinstance.GJaxbProcessGeneratorInstances;
import fr.emac.gind.processmonitoring.ProcessMonitoringItf;
import fr.emac.gind.processmonitoring.data.GJaxbGetProcessInstance;
import fr.emac.gind.processmonitoring.data.GJaxbGetProcessInstanceResponse;
import fr.emac.gind.processmonitoring.data.GJaxbGetProcessInstancesResponse;
import fr.emac.gind.processmonitoring.data.GJaxbUpdateProcessInstance;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.dw.resources.FileResource;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHeader;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import fr.emac.gind.we.command.GJaxbCancel;
import fr.emac.gind.we.command.GJaxbCancelResponse;
import fr.emac.gind.we.command.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.workflow.AbstractProcessGenerator;
import fr.emac.gind.workflow.engine.prio.deployer.dispatch.DispatcherManager;
import fr.emac.gind.workflow.report.GJaxbDeductionModeType;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Path(value="/{app}/r-ioga/solution")
public class SolutionResource {
    private static Logger LOG = LoggerFactory.getLogger((String)SolutionResource.class.getName());
    protected Configuration conf = null;
    protected SOAPSender sender = new SOAPSender(new SOAPInterceptor[0]);
    protected NotificationConsumerWebService processDeployerConsumer = null;
    protected NotificationConsumerWebService newProcessInstanceConsumer = null;
    protected NotificationConsumerWebService monitoringConsumer = null;
    private Deduction deductionClient = null;
    protected ModelsResource models = null;
    protected CoreResource core = null;
    protected ProcessResource process = null;
    protected FileResource fileResource = null;
    protected ProjectResource project = null;
    protected CampaignManagerItf campaignClient = null;
    protected ProcessMonitoringItf processMonitoringClient = null;
    protected GJaxbEffectiveMetaModel processEffectiveMetaModel = null;
    protected GJaxbEffectiveMetaModel risksEffectiveModeler = null;
    protected static DispatcherManager DISPATCHER = null;
    protected IndicatorsRangeStrategyPluginManager uncertainlyStrategyManager = null;
    private Map<String, AbstractProcessGenerator> processGenerators = new HashMap<String, AbstractProcessGenerator>();
    private GJaxbProcessGeneratorInstances processDeductionStrategies = null;
    private GJaxbEffectiveMetaModel processEffMetaModel = null;

    public SolutionResource(Configuration configuration, CoreResource core, ProcessResource process, ModelsResource models, ProjectResource project, GJaxbEffectiveMetaModel processEffectiveMetaModel, NotificationConsumerWebService processDeployerConsumer, NotificationConsumerWebService newProcessInstanceConsumer, NotificationConsumerWebService monitoringConsumer, FileResource fileResource) throws Exception {
        this.conf = configuration;
        this.core = core;
        this.process = process;
        this.models = models;
        this.project = project;
        this.processEffectiveMetaModel = processEffectiveMetaModel;
        this.campaignClient = CampaignManagerClient.createClient((String)((String)this.conf.getProperties().get("campaign-manager")));
        this.processMonitoringClient = ProcessMonitoringClient.createClient((String)((String)this.conf.getProperties().get("monitoring-server")));
        this.processDeployerConsumer = processDeployerConsumer;
        this.newProcessInstanceConsumer = newProcessInstanceConsumer;
        this.monitoringConsumer = monitoringConsumer;
        this.risksEffectiveModeler = (GJaxbEffectiveMetaModel)EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromContainerByQNameMap().get(new QName("http://fr.emac.gind/collaborative-model/objectives", "Objectives"));
        this.uncertainlyStrategyManager = new IndicatorsRangeStrategyPluginManager();
        this.processDeductionStrategies = this.initProcessGenerators();
        this.deductionClient = DeductionClient.createClient((String)((String)this.conf.getProperties().get("governance")).replace("/gov", "/GovDeduction"));
        this.processEffMetaModel = (GJaxbEffectiveMetaModel)EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromContainerByQNameMap().get(new QName("http://fr.emac.gind/collaborative-model/process", "Process"));
        this.fileResource = fileResource;
    }

    private GJaxbProcessGeneratorInstances initProcessGenerators() throws Exception {
        GJaxbProcessGeneratorInstances res = new GJaxbProcessGeneratorInstances();
        ServiceLoader<AbstractProcessGenerator> processGeneratorLoader = ServiceLoader.load(AbstractProcessGenerator.class);
        this.processGenerators.clear();
        processGeneratorLoader.reload();
        for (AbstractProcessGenerator processGenerator : processGeneratorLoader) {
            this.processGenerators.put(processGenerator.getClass().getName(), processGenerator);
            GJaxbProcessGeneratorInstance gen = new GJaxbProcessGeneratorInstance();
            if (processGenerator.getDeductionStrategy() != null) {
                gen.setName(processGenerator.getDeductionStrategy().getName());
                gen.setClazz(processGenerator.getDeductionStrategy().getClass().getName());
                gen.setDescription(processGenerator.getDeductionStrategy().getDescription());
                gen.setNgFunction(processGenerator.getDeductionStrategy().getJavascriptFunction());
                gen.setNgFunctionParams(processGenerator.getDeductionStrategy().getJavascriptFunctionParameters().toString());
                gen.setFavoriteDomains(processGenerator.getDeductionStrategy().getFavoriteDomains());
            }
            res.getProcessGeneratorInstance().add(gen);
        }
        return res;
    }

    public void setProject(ProjectResource project) {
        this.project = project;
    }

    public DispatcherManager getDispatcher() throws Exception {
        if (DISPATCHER == null) {
            DISPATCHER = new DispatcherManager(this.conf.getMapObjects());
        }
        return DISPATCHER;
    }

    @POST
    @Path(value="/selectSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbNode selectSolution(@Auth DWUser user, GJaxbNode selectedSolution) throws Exception {
        assert (user != null);
        try {
            String query = "match (s:instance:" + Neo4JReqConstant.collab((String)"Solution") + ") return distinct s";
            GJaxbGenericModel solutions = this.models.query(user, query, PluginCollaborativeModel.PROCESS_PACKAGE_NAME);
            for (GJaxbNode solution : solutions.getNode()) {
                if (solution.getId().equals(selectedSolution.getId())) {
                    GenericModelHelper.findProperty((String)"selected", (List)solution.getProperty(), (boolean)true).setValue("true");
                    selectedSolution = solution;
                    continue;
                }
                GenericModelHelper.findProperty((String)"selected", (List)solution.getProperty(), (boolean)true).setValue("false");
            }
            this.models.publish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), solutions, null, null);
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return selectedSolution;
    }

    @GET
    @Path(value="/findSelectedSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String findSelectedSolution(@Auth DWUser user) throws Exception {
        assert (user != null);
        GJaxbNode selectedSolution = this._findSelectedSolution(user);
        JSONObject res = new JSONObject();
        res.put("selected", selectedSolution != null ? JSONJAXBContext.getInstance().marshallAnyElement((Object)selectedSolution) : null);
        return res.toString();
    }

    public GJaxbNode _findSelectedSolution(DWUser user) throws Exception {
        GJaxbNode selectedSolution = null;
        try {
            String query = "match (s:instance:" + Neo4JReqConstant.collab((String)"Solution") + ") return distinct s";
            GJaxbGenericModel solutions = this.models.query(user, query, PluginCollaborativeModel.PROCESS_PACKAGE_NAME);
            for (GJaxbNode solution : solutions.getNode()) {
                if (!"true".equals(GenericModelHelper.findProperty((String)"selected", (List)solution.getProperty(), (boolean)true).getValue())) continue;
                selectedSolution = solution;
                break;
            }
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return selectedSolution;
    }

    @POST
    @Path(value="/deduceSolutionASync")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbDeduceASyncResponse deduceSolutionASync(@Auth DWUser user, DeduceInput input) throws Exception {
        assert (user != null);
        GJaxbDeduceASyncResponse deduceResponse = null;
        try {
            GJaxbProcessGeneratorInstance pgi = (GJaxbProcessGeneratorInstance)JSONJAXBContext.getInstance().unmarshall("{ \"processGeneratorInstance\": " + input.getProcessGeneratorInstance() + " }", GJaxbProcessGeneratorInstance.class);
            String dataJSON = input.getSpecificInputData();
            JSONObject data = null;
            if (dataJSON != null) {
                data = new JSONObject(dataJSON);
            }
            GJaxbDeduceASync request = new GJaxbDeduceASync();
            request.setProcessGeneratorInstance(pgi);
            request.setDeductionMode(GJaxbDeductionModeType.fromValue((String)input.getDeductionMode()));
            request.setInputDeductionData(new GJaxbDeduceASync.InputDeductionData());
            request.setCurrentCollaborationName(user.getCurrentCollaborationName());
            request.setCurrentKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            request.setCallBackAddress("http://0.0.0.0:" + (String)this.conf.getProperties().get("deduction-solution-async-response-callback-port") + "/DeductionAsyncResponseCallBack");
            if (data != null) {
                for (String key : data.keySet()) {
                    request.getInputDeductionData().getProperty().add(GenericModelHelper.createProperty((String)key, (String)data.get(key).toString()));
                }
            }
            deduceResponse = this.deductionClient.deduceASync(request);
            LOG.debug("deduceResponse: \n" + String.valueOf(deduceResponse));
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return deduceResponse;
    }

    @POST
    @Path(value="/deploySolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbNode deploySolution(@Auth DWUser user, GJaxbNode solution) throws Exception {
        try {
            String query = "match (p:instance:" + Neo4JReqConstant.collab((String)"Process") + ")-[r:" + Neo4JReqConstant.uml((String)"Compose") + "]->(s:instance:" + Neo4JReqConstant.collab((String)"Solution") + " { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)solution.getId(), (String)user.getCurrentCollaborationName(), (String)user.getCurrentKnowledgeSpaceName()) + "'}) return distinct p";
            GJaxbGenericModel processes = this.models.query(user, query, PluginCollaborativeModel.PROCESS_PACKAGE_NAME);
            if (processes.getNode().isEmpty()) {
                throw new Exception("None process composes the solution: " + GenericModelHelper.getName((GJaxbNode)solution));
            }
            JSONArray processInstances = new JSONArray();
            for (GJaxbNode process : processes.getNode()) {
                GJaxbProcessToDeploy sampledProcess = new GJaxbProcessToDeploy();
                sampledProcess.setProcessId(process.getId());
                sampledProcess.setProcessName(GenericModelHelper.getName((GJaxbNode)process));
                GJaxbDeployResult responseDeploy = this.process.deployProcess(user, sampledProcess);
                JSONObject processInstance = new JSONObject();
                processInstance.put("processId", (Object)process.getId());
                processInstance.put("processName", (Object)GenericModelHelper.getName((GJaxbNode)process));
                processInstance.put("processEndpointAddress", (Object)responseDeploy.getEndpointAddress());
                processInstance.put("processEndpointName", (Object)responseDeploy.getEndpointName());
                processInstance.put("processServiceQName", (Object)responseDeploy.getServiceQName());
                processInstance.put("processInternalEndpointAddress", (Object)responseDeploy.getInternalEndpointAddress());
                processInstance.put("processResourceUrl", (Object)responseDeploy.getProcessResourceUrl());
                processInstance.put("processWorkflowEngineName", (Object)responseDeploy.getWorkflowEngineName());
                processInstances.put((Object)processInstance);
            }
            GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty(), (boolean)true).setValue(processInstances.toString());
            GJaxbUpdateNode request = new GJaxbUpdateNode();
            request.setNode(solution);
            request.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
            request.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
            request.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
            request.setCreateIfNotExist(true);
            request.setNotification(new GJaxbNotification());
            request.getNotification().setActivateNotification(true);
            request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
            request.getPreAndPostTreatment().setActivatePreAndPostTreatment(false);
            GJaxbUpdateNodeResponse gJaxbUpdateNodeResponse = this.core.getCoreClient().updateNode(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return solution;
    }

    @POST
    @Path(value="/undeploySolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbNode undeploySolution(@Auth DWUser user, GJaxbNode solution) throws Exception {
        try {
            JSONArray processInstances = new JSONArray(GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty(), (boolean)true).getValue());
            for (int i = 0; i < processInstances.length(); ++i) {
                JSONObject processInstance = processInstances.getJSONObject(i);
                GJaxbProcessToDeploy sampledProcess = new GJaxbProcessToDeploy();
                sampledProcess.setProcessId(processInstance.getString("processId"));
                sampledProcess.setProcessName(processInstance.getString("processName"));
                GJaxbGetProcessInstancesResponse instances = this.process.instancesByProcess(user, sampledProcess.getProcessName());
                for (GJaxbInstanceInfo info : instances.getInstanceInfo()) {
                    this.process.deleteOrchestration(user, info.getProcessInstanceId());
                }
                GJaxbUndeployResponse gJaxbUndeployResponse = this.process.undeployProcess(user, sampledProcess);
            }
            GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty(), (boolean)true).setValue(null);
            this.core.updateNode(user, solution);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return solution;
    }

    @POST
    @Path(value="/superviseSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCloneSyncModelFromStatusResponse superviseSolution(@Auth DWUser user, GJaxbNode solution) throws Exception {
        GJaxbCloneSyncModelFromStatusResponse response = null;
        try {
            this.models.query(user, "MATCH (n:EXPECTED_FREEZE) DETACH DELETE n;", null);
            GJaxbCloneSyncModelFromStatus request = new GJaxbCloneSyncModelFromStatus();
            request.setStatusIn(GJaxbStatusType.ACTIVE);
            request.setStatusOut(GJaxbStatusType.EXPECTED_FREEZE);
            request.getAdditionalInLabel().add("instance");
            request.getAdditionalOutLabel().add(solution.getId());
            response = this.models.cloneModelFromStatus(user, request);
            JSONArray processInstanceIdsArray = new JSONArray(GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty()).getValue());
            for (int i = 0; i < processInstanceIdsArray.length(); ++i) {
                JSONObject processInstanceIdObj = processInstanceIdsArray.getJSONObject(i);
                String processInstanceId = processInstanceIdObj.getString("processInstanceId");
                GJaxbGetProcessInstance getInst = new GJaxbGetProcessInstance();
                getInst.setProcessInstanceId(processInstanceId);
                GJaxbGetProcessInstanceResponse responseGetInst = this.processMonitoringClient.getProcessInstance(getInst);
                GJaxbInstanceInfo instanceInfo = responseGetInst.getInstanceInfo();
                instanceInfo.setSupervisedAt(response.getClonedAt());
                GJaxbUpdateProcessInstance upInst = new GJaxbUpdateProcessInstance();
                upInst.setInstanceInfo(instanceInfo);
                this.processMonitoringClient.updateProcessInstance(upInst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }

    @POST
    @Path(value="/runASyncSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public synchronized GJaxbNode runASyncSolution(final @Auth DWUser user, GJaxbNode solution) throws Exception {
        GJaxbRunASyncResponse response = null;
        try {
            if (GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty()) == null) {
                solution = this.deploySolution(user, solution);
            }
            JSONArray processInstances = new JSONArray(GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty()).getValue());
            for (int i = 0; i < processInstances.length(); ++i) {
                JSONObject processInstance = processInstances.getJSONObject(i);
                String internalEndpointAddress = processInstance.getString("processInternalEndpointAddress");
                GJaxbRunASync asyncRequest = new GJaxbRunASync();
                GJaxbRunSync request = new GJaxbRunSync();
                request.setCollaborationName(user.getCurrentCollaborationName());
                request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                request.setExecutionType(GJaxbExecType.ORCHESTRATION);
                asyncRequest.setRunSync(request);
                asyncRequest.getCallbackAddress().add("http://0.0.0.0:" + (String)this.conf.getProperties().get("process-async-response-callback-port") + "/ProcessAsyncResponseCallBack");
                if (processInstance.has("callbackEndpointAddress") && !processInstance.getString("callbackEndpointAddress").isBlank()) {
                    asyncRequest.getCallbackAddress().add(processInstance.getString("callbackEndpointAddress"));
                }
                asyncRequest.setCollaborationName(user.getCurrentCollaborationName());
                asyncRequest.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
                asyncRequest.setUserId(user.getUserId());
                SOAPHeader header = new SOAPHeader((Map)new HashMap<QName, String>(this){
                    final /* synthetic */ SolutionResource this$0;
                    {
                        this.this$0 = this$0;
                        this.put(new QName("http://fr.emac.gind/", "websocketCommandSOAPEndpoint"), SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.this$0.conf.getHost(), (int)Integer.parseInt((String)this.this$0.conf.getProperties().get("websocket-command-service-port")), (int)Integer.parseInt((String)this.this$0.conf.getProperties().get("proxy-port")), (String)"/websocketCommandService"));
                        this.put(new QName("http://fr.emac.gind/", "currentUser"), JSONJAXBContext.getInstance().marshallAnyElement((Object)user.getUser()));
                        this.put(new QName("http://fr.emac.gind/", "withoutThread"), "false");
                        this.put(new QName("http://fr.emac.gind/", "activateMonitoring"), "true");
                    }
                });
                Document req = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)asyncRequest);
                Document soapResp = this.sender.sendSoapRequest(req, internalEndpointAddress, "http://www.gind.emac.fr/process/instance/runASync", header);
                Document resp = SOAPHandler.extractPayload((Document)soapResp);
                response = (GJaxbRunASyncResponse)XMLJAXBContext.getInstance().unmarshallDocument(resp, GJaxbRunASyncResponse.class);
                LOG.debug("response in dw: " + XMLCompactPrinter.print((Node)resp));
                processInstance.put("processInstanceId", (Object)response.getInstanceId());
            }
            GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty(), (boolean)true).setValue(processInstances.toString());
            this.core.updateNode(user, solution);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof SOAPFaultException) {
                SOAPFault sf = ((SOAPFaultException)e).getFault();
                NodeList nl = sf.getDetail().getElementsByTagNameNS("http://www.gind.emac.fr", "workflowErrorDetails");
                Element error = (Element)nl.item(0);
                String message = DOMUtil.getInstance().findFirstElementByNs(error, new QName("http://www.gind.emac.fr", "message")).getTextContent();
                String stacktrace = DOMUtil.getInstance().findFirstElementByNs(error, new QName("http://www.gind.emac.fr", "stacktrace")).getTextContent();
                Exception newE = new Exception("Error in workflow execution:\n\nmessage: " + message + "\n\n" + stacktrace);
                GindWebApplicationException.manageError(newE, this);
            }
            GindWebApplicationException.manageError(e, this);
        }
        return solution;
    }

    @POST
    @Path(value="/cancelSolution")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCloneSyncModelFromStatusResponse cancelSolution(@Auth DWUser user, GJaxbNode solution) throws Exception {
        GJaxbCloneSyncModelFromStatusResponse response = new GJaxbCloneSyncModelFromStatusResponse();
        try {
            JSONArray processInstanceIdsArray = new JSONArray(GenericModelHelper.findProperty((String)"processInstances", (List)solution.getProperty()).getValue());
            for (int i = 0; i < processInstanceIdsArray.length(); ++i) {
                JSONObject processInstanceIdObj = processInstanceIdsArray.getJSONObject(i);
                String processInstanceId = processInstanceIdObj.getString("processInstanceId");
                GJaxbCancel cancelReq = new GJaxbCancel();
                cancelReq.setProcessInstanceId(processInstanceId);
                cancelReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                cancelReq.getSelectedKnowledgeSpace().setCollaborationName(user.getCurrentCollaborationName());
                cancelReq.getSelectedKnowledgeSpace().setKnowledgeName(user.getCurrentKnowledgeSpaceName());
                GJaxbCancelResponse cancelResp = this.process.cancelOrchestration(user, cancelReq);
                LOG.debug("Solution cancelled !!! : " + String.valueOf(cancelReq));
            }
            GenericModelHelper.findProperty((String)"selected", (List)solution.getProperty(), (boolean)true).setValue("false");
            this.core.updateNode(user, solution);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return response;
    }
}

