/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioga;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventcommonsdata.GJaxbPatternType;
import fr.emac.gind.eventtype.GJaxbMonitoringProcessInstanceProgressionEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="/wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOGAMonitoringProcessExchangeNotifierClient
extends AbstractNotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)RIOGAMonitoringProcessExchangeNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;

    public RIOGAMonitoringProcessExchangeNotifierClient(String address, WebsocketCommand WEB_SOCKET_COMMAND) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = WEB_SOCKET_COMMAND;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            GJaxbMonitoringProcessInstanceProgressionEvent me = (GJaxbMonitoringProcessInstanceProgressionEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbMonitoringProcessInstanceProgressionEvent.class);
            String collaborationName = me.getCollaborationName();
            String knowledgeName = me.getKnowledgeSpaceName();
            GJaxbGetResult result = new GJaxbGetResult();
            result.setWebsocketId("/riowa/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode() + "/" + me.getMonitoringInstanceProgression().getProcessInstanceId());
            result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)me.getMonitoringInstanceProgression()));
            if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getPattern().equals((Object)GJaxbPatternType.IN_ONLY)) {
                if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getIn() != null) {
                    this.WEB_SOCKET_COMMAND.getResult(result);
                }
            } else if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getPattern().equals((Object)GJaxbPatternType.IN_OUT)) {
                if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getIn() != null) {
                    this.WEB_SOCKET_COMMAND.getResult(result);
                } else if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getOut() != null) {
                    this.WEB_SOCKET_COMMAND.getResult(result);
                } else if (me.getMonitoringInstanceProgression().getLastExchange().getExchange().getFault() != null) {
                    this.WEB_SOCKET_COMMAND.getResult(result);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

