/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioga;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbAddProcessInstanceEvent;
import fr.emac.gind.eventtype.GJaxbDeleteProcessInstanceEvent;
import fr.emac.gind.eventtype.GJaxbUpdateProcessInstanceEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="/wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOGAMonitoringProcessInstanceEventNotifierClient
extends AbstractNotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)RIOGAMonitoringProcessInstanceEventNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;

    public RIOGAMonitoringProcessInstanceEventNotifierClient(String address, WebsocketCommand WEB_SOCKET_COMMAND) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = WEB_SOCKET_COMMAND;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            GJaxbGetResult result = new GJaxbGetResult();
            if ("addProcessInstanceEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOGA Event] received addProcessInstanceEvent");
                GJaxbAddProcessInstanceEvent me = (GJaxbAddProcessInstanceEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddProcessInstanceEvent.class);
                String collaborationName = me.getCollaborationName();
                String knowledgeName = me.getKnowledgeSpaceName();
                result.setWebsocketId("/riowa/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode() + "/");
                result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)me));
            } else if ("updateProcessInstanceEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOGA Event] received updateProcessInstanceEvent");
                GJaxbUpdateProcessInstanceEvent me = (GJaxbUpdateProcessInstanceEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateProcessInstanceEvent.class);
                String collaborationName = me.getCollaborationName();
                String knowledgeName = me.getKnowledgeSpaceName();
                result.setWebsocketId("/riowa/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode() + "/");
                result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)me));
            } else if ("deleteProcessInstanceEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOGA Event] received deleteProcessInstanceEvent");
                GJaxbDeleteProcessInstanceEvent me = (GJaxbDeleteProcessInstanceEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbDeleteProcessInstanceEvent.class);
                String collaborationName = me.getCollaborationName();
                String knowledgeName = me.getKnowledgeSpaceName();
                result.setWebsocketId("/riowa/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode() + "/");
                result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement((Object)me));
            }
            this.WEB_SOCKET_COMMAND.getResult(result);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

