/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioga;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.ApplicationContext;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.RIODataSourceSensorNotifierClient;
import fr.emac.gind.generic.application.configuration.GenericConfiguration;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.metamodel.GJaxbDomainDefinition;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.r.ioga.DeductionSolutionASyncCallBackSOAPImpl;
import fr.emac.gind.r.ioga.ProcessInstanceASyncCallBackSOAPImpl;
import fr.emac.gind.r.ioga.RIOGAApplicationContext;
import fr.emac.gind.r.ioga.RIOGAMonitoringProcessExchangeNotifierClient;
import fr.emac.gind.r.ioga.RIOGAMonitoringProcessInstanceEventNotifierClient;
import fr.emac.gind.r.ioga.RIOGAProcessDeployerNotifierClient;
import fr.emac.gind.rio.dw.resources.EventBrokerResource;
import fr.emac.gind.rio.dw.resources.gov.CampaignResource;
import fr.emac.gind.rio.dw.resources.gov.InterpretationRulesResource;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import fr.emac.gind.rio.dw.resources.gov.SensorManagerResource;
import fr.emac.gind.rio.dw.resources.gov.SolutionResource;
import fr.emac.gind.usecases.RIOAbstractProject;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import jakarta.xml.ws.Endpoint;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOGAService
extends DWApplicationService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOGAService.class.getName());
    protected InterpretationRulesResource intepretationRules = null;
    protected EventBrokerResource eventBrokerResource = null;
    protected SensorManagerResource sensorManagerResource = null;
    protected ProcessResource processResource = null;
    protected SolutionResource solutionResource = null;
    protected CampaignResource campaignResource = null;
    protected ProjectResource projectResource = null;
    protected static RIOAbstractProject REFERENCE_BASE = null;
    public static NotificationConsumerWebService PROCESS_DEPLOYER_CONSUMER = null;
    public static NotificationConsumerWebService MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER = null;
    public static NotificationConsumerWebService MONITORING_EXCHANGES_CONSUMER = null;
    public static NotificationConsumerWebService SENSOR_MANAGER_CONSUMER = null;
    public static AbstractNotifierClient SENSOR_MANAGER_NOTIFIER = null;
    protected static Endpoint PROCESS_ASYNC_RESPONSE_CALLBACK = null;
    protected static Endpoint DEDUCTION_ASYNC_RESPONSE_CALLBACK = null;

    public RIOGAService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOGAService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-ioga";
    }

    public String getRedirection() {
        return "/rioga";
    }

    public RIOGAApplicationContext createApplicationContext() throws Exception {
        return new RIOGAApplicationContext(this);
    }

    public <T extends ApplicationContext> void initializeApplicationContext(T applicationContext) throws Exception {
        super.initializeApplicationContext(applicationContext);
        RIOGAApplicationContext riogaContext = (RIOGAApplicationContext)applicationContext;
    }

    public void boot(Configuration conf) throws Exception {
        super.boot(conf);
        RIOGAService.init(this.getName(), conf, (RIOGAApplicationContext)this.applicationContext);
    }

    public static void init(String name, Configuration conf, RIOGAApplicationContext context) throws Exception {
        for (GJaxbDomainDefinition domainDef : EffectiveMetaModelPluginManager.getInstance().getDomainsDefinition()) {
            if (domainDef.getPictureUrl() != null) {
                domainDef.setPictureUrl(domainDef.getPictureUrl().replace("##application_name##", name));
            }
            for (GJaxbDomainDefinition.PackageDefinition cd : domainDef.getPackageDefinition()) {
                if (cd.getModeling().getIconUrl() != null) {
                    cd.getModeling().setIconUrl(cd.getModeling().getIconUrl().replace("##application_name##", name));
                }
                for (GJaxbDomainDefinition.PackageDefinition.AdditionalPackageDetected apd : cd.getAdditionalPackageDetected()) {
                    if (apd.getPackageIconUrl() == null) continue;
                    apd.setPackageIconUrl(apd.getPackageIconUrl().replace("##application_name##", name));
                }
            }
        }
    }

    public void doRun(io.dropwizard.core.Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        this.eventBrokerResource = new EventBrokerResource(this.conf, WEB_SOCKET_COMMAND);
        resourcesManager.addResource((Object)this.eventBrokerResource);
        this.intepretationRules = new InterpretationRulesResource(this.conf);
        resourcesManager.addResource((Object)this.intepretationRules);
        this.createEventSensorNotifierToReceiveLog();
        this.sensorManagerResource = new SensorManagerResource(this.conf, this.fileResource, SENSOR_MANAGER_CONSUMER, SENSOR_MANAGER_NOTIFIER, WEB_SOCKET_COMMAND);
        resourcesManager.addResource((Object)this.sensorManagerResource);
        this.createNotifierForDeployProcessEvent();
        this.createNotifierForMonitoringAddProcessInstanceEvent();
        this.createNotifierForMonitoringExchangeEvent();
        this.processResource = new ProcessResource(this.conf, this.coreResource, this.modelsResource, null, ((RIOGAApplicationContext)this.applicationContext).getProcessEffectiveMetaModel(), PROCESS_DEPLOYER_CONSUMER, MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER, MONITORING_EXCHANGES_CONSUMER, this.fileResource);
        this.solutionResource = new SolutionResource(this.conf, this.coreResource, this.processResource, this.modelsResource, null, ((RIOGAApplicationContext)this.applicationContext).getProcessEffectiveMetaModel(), PROCESS_DEPLOYER_CONSUMER, MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER, MONITORING_EXCHANGES_CONSUMER, this.fileResource);
        resourcesManager.addResource((Object)this.processResource);
        resourcesManager.addResource((Object)this.solutionResource);
        ((RIOGAApplicationContext)this.applicationContext).setProcessDeductionStrategies(this.processResource.getProcessDeductionStrategies());
        this.projectResource = new ProjectResource(this.conf, this.getName(), this.systemResource, this.metaModelsResource, this.coreResource, this.modelsResource, this.processResource, this.sensorManagerResource, this.intepretationRules, this.aiChatbotResource, ((RIOGAApplicationContext)this.applicationContext).getProject());
        resourcesManager.addResource((Object)this.projectResource);
        this.processResource.setProject(this.projectResource);
        this.campaignResource = new CampaignResource(this.conf, this.coreResource);
        resourcesManager.addResource((Object)this.campaignResource);
        this.createProcessAsyncResponseServer();
        this.createDeductionAsyncResponseServer();
        this.activatePubSubServerServlet(environment);
    }

    public void initialize(Bootstrap<GenericConfiguration> bootstrap) {
        super.initialize(bootstrap);
    }

    public ProcessResource getProcessResource() {
        return this.processResource;
    }

    public ProjectResource getProjectResource() {
        return this.projectResource;
    }

    private void createProcessAsyncResponseServer() throws Exception {
        if (PROCESS_ASYNC_RESPONSE_CALLBACK == null) {
            PROCESS_ASYNC_RESPONSE_CALLBACK = StaticJettyServer.getInstance().publishJAXWSEndpoint(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("process-async-response-callback-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/ProcessAsyncResponseCallBack"), (Object)new ProcessInstanceASyncCallBackSOAPImpl(WEB_SOCKET_COMMAND));
        }
    }

    private void createDeductionAsyncResponseServer() throws Exception {
        if (DEDUCTION_ASYNC_RESPONSE_CALLBACK == null) {
            DEDUCTION_ASYNC_RESPONSE_CALLBACK = StaticJettyServer.getInstance().publishJAXWSEndpoint(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("deduction-solution-async-response-callback-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/DeductionAsyncResponseCallBack"), (Object)new DeductionSolutionASyncCallBackSOAPImpl(WEB_SOCKET_COMMAND));
        }
    }

    private void createEventSensorNotifierToReceiveLog() throws Exception {
        if (SENSOR_MANAGER_CONSUMER == null) {
            String logNotifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-sensors-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOSENotifierForSensors");
            SENSOR_MANAGER_NOTIFIER = new RIODataSourceSensorNotifierClient(logNotifierClientAddress, WEB_SOCKET_COMMAND);
            SENSOR_MANAGER_CONSUMER = new NotificationConsumerWebService();
            SENSOR_MANAGER_CONSUMER.start((Map)new HashMap<String, Object>(){
                {
                    this.put("host", "0.0.0.0");
                    this.put("port", RIOGAService.this.conf.getProperties().get("notifier-for-sensors-port"));
                    this.put("serviceName", "RIOSENotifierForSensors");
                    this.put("notifierClient", SENSOR_MANAGER_NOTIFIER);
                }
            });
        }
    }

    private void createNotifierForMonitoringExchangeEvent() throws Exception {
        if (MONITORING_EXCHANGES_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("monitoring-exchanges-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/MonitoringExchangeNotifierClient");
            final RIOGAMonitoringProcessExchangeNotifierClient notifier = new RIOGAMonitoringProcessExchangeNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND);
            MONITORING_EXCHANGES_CONSUMER = new NotificationConsumerWebService();
            MONITORING_EXCHANGES_CONSUMER.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ RIOGAService this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", this.this$0.conf.getProperties().get("host"));
                    this.put("port", this.this$0.conf.getProperties().get("monitoring-exchanges-notifier-port"));
                    this.put("serviceName", "MonitoringExchangeNotifierClient");
                    this.put("notifierClient", notifier);
                }
            });
        }
    }

    private void createNotifierForMonitoringAddProcessInstanceEvent() throws Exception {
        if (MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("monitoring-add-process-instance-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/MonitoringAddProcessInstanceNotifierClient");
            final RIOGAMonitoringProcessInstanceEventNotifierClient notifier = new RIOGAMonitoringProcessInstanceEventNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND);
            MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER = new NotificationConsumerWebService();
            MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ RIOGAService this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", this.this$0.conf.getProperties().get("host"));
                    this.put("port", this.this$0.conf.getProperties().get("monitoring-add-process-instance-notifier-port"));
                    this.put("serviceName", "MonitoringAddProcessInstanceNotifierClient");
                    this.put("notifierClient", notifier);
                }
            });
        }
    }

    private void createNotifierForDeployProcessEvent() throws Exception {
        if (PROCESS_DEPLOYER_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("process-deployer-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/ProcessDeployerNotifierClient");
            final RIOGAProcessDeployerNotifierClient notifier = new RIOGAProcessDeployerNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND);
            PROCESS_DEPLOYER_CONSUMER = new NotificationConsumerWebService();
            PROCESS_DEPLOYER_CONSUMER.start((Map)new HashMap<String, Object>(this){
                final /* synthetic */ RIOGAService this$0;
                {
                    this.this$0 = this$0;
                    this.put("host", this.this$0.conf.getProperties().get("host"));
                    this.put("port", this.this$0.conf.getProperties().get("process-deployer-notifier-port"));
                    this.put("serviceName", "ProcessDeployerNotifierClient");
                    this.put("notifierClient", notifier);
                }
            });
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (PROCESS_DEPLOYER_CONSUMER != null) {
            PROCESS_DEPLOYER_CONSUMER.stop();
            PROCESS_DEPLOYER_CONSUMER = null;
        }
        if (MONITORING_EXCHANGES_CONSUMER != null) {
            MONITORING_EXCHANGES_CONSUMER.stop();
            MONITORING_EXCHANGES_CONSUMER = null;
        }
        if (MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER != null) {
            MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER.stop();
            MONITORING_ADD_NEW_PROCESS_INSTANCE_CONSUMER = null;
        }
        if (SENSOR_MANAGER_CONSUMER != null) {
            SENSOR_MANAGER_CONSUMER.stop();
            SENSOR_MANAGER_CONSUMER = null;
        }
        if (PROCESS_ASYNC_RESPONSE_CALLBACK != null) {
            StaticJettyServer.getInstance().unPublishJAXWSEndpoint(PROCESS_ASYNC_RESPONSE_CALLBACK);
            PROCESS_ASYNC_RESPONSE_CALLBACK.stop();
            PROCESS_ASYNC_RESPONSE_CALLBACK = null;
        }
    }
}

