/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.find.gis.client.FindGisClient;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gis.find_gis.FindGis;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLng;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLngResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBox;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBoxResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygon;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygonResponse;
import fr.emac.gind.gis.find_gis.GJaxbPoint;
import fr.emac.gind.gis.find_gis.GJaxbPolygon;
import fr.emac.gind.gis.find_gis.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.gis.store_gis.StoreGis;
import fr.emac.gind.h2gis.gis.H2GisFindGisImpl;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.osm.gis.OsmFindGisImpl;
import fr.emac.gind.rio.dw.resources.bo.FindInOSMRequest;
import fr.emac.gind.rio.dw.resources.bo.GeoLocPointTO;
import fr.emac.gind.store.gis.client.StoreGisClient;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.json.JSONObject;

@Path(value="/{genericApplication}/gis")
@Produces(value={"application/json"})
public class GisResource {
    private StoreGis storeH2GisClient = null;
    private FindGis findH2GisClient = null;
    private FindGis findOSMGisClient = null;
    private Configuration conf = null;

    public GisResource(Configuration conf) throws Exception {
        this.storeH2GisClient = StoreGisClient.createClient((String)((String)conf.getProperties().get("h2gis-server")).replaceAll("h2", "store"));
        this.findH2GisClient = FindGisClient.createClient((String)((String)conf.getProperties().get("h2gis-server")).replaceAll("h2", "find"), H2GisFindGisImpl.class);
        this.findOSMGisClient = FindGisClient.createClient((String)((String)conf.getProperties().get("osm-server")), OsmFindGisImpl.class);
        this.conf = conf;
    }

    @POST
    @Path(value="/findConceptsHere")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String findConceptsHere(@Auth DWUser user, GeoLocPointTO point) throws Exception {
        GJaxbFindConceptsFromLatLngResponse res = null;
        assert (user != null);
        try {
            GJaxbFindConceptsFromLatLng request = new GJaxbFindConceptsFromLatLng();
            request.setPoint(new GJaxbPoint());
            request.getPoint().setLatitude(point.getLat().toString());
            request.getPoint().setLongitude(point.getLng().toString());
            res = this.findH2GisClient.findConceptsFromLatLng(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(res)).get("findConceptsFromLatLngResponse").toString();
    }

    @POST
    @Path(value="/detectConceptsInside")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String detectConceptsInside(@Auth DWUser user, GJaxbNode node) throws Exception {
        GJaxbFindConceptsInsidePolygonResponse queryAreaResp = null;
        assert (user != null);
        try {
            String collaborationName = user.getCurrentCollaborationName();
            String knownledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            GJaxbFindConceptsInsidePolygon queryArea = new GJaxbFindConceptsInsidePolygon();
            queryArea.setCallbackAddress(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-h2gis-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/FindGisCallBack"));
            queryArea.setPolygon(new GJaxbPolygon());
            GJaxbProperty pc = new GJaxbProperty();
            pc.setName("collaborationName");
            pc.setValue(collaborationName);
            queryArea.getProperty().add(pc);
            GJaxbProperty pk = new GJaxbProperty();
            pk.setName("knownledgeSpaceName");
            pk.setValue(knownledgeSpaceName);
            queryArea.getProperty().add(pk);
            GJaxbProperty pp = new GJaxbProperty();
            pp.setName("parentNodeId");
            pp.setValue(node.getId());
            queryArea.getProperty().add(pp);
            for (GJaxbPointType pt : ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getArea().getPoint()) {
                GJaxbPoint newPt = new GJaxbPoint();
                newPt.setLatitude(String.valueOf(pt.getLatitude()));
                newPt.setLongitude(String.valueOf(pt.getLongitude()));
                queryArea.getPolygon().getPoint().add(newPt);
            }
            queryAreaResp = this.findH2GisClient.findConceptsInsidePolygon(queryArea);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(queryAreaResp)).get("findConceptsInsidePolygonResponse").toString();
    }

    @POST
    @Path(value="/findInOSM")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbFindConceptsInsideBBoxResponse findInOSM(@Auth DWUser user, FindInOSMRequest req) throws Exception {
        GJaxbFindConceptsInsideBBoxResponse queryAreaResp = null;
        assert (user != null);
        try {
            String collaborationName = user.getCurrentCollaborationName();
            String knownledgeSpaceName = user.getCurrentKnowledgeSpaceName();
            GJaxbFindConceptsInsideBBox queryBBox = req.getBox();
            queryBBox.setCallbackAddress(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-h2gis-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/FindGisCallBack"));
            queryBBox.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            queryBBox.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            queryBBox.getSelectedKnowledgeSpace().setKnowledgeName(knownledgeSpaceName);
            GJaxbProperty createSubClass = new GJaxbProperty();
            createSubClass.setName("generateSubClass");
            createSubClass.setValue(String.valueOf(req.isGenerateSubClass()));
            queryBBox.getProperty().add(createSubClass);
            GJaxbProperty pc = new GJaxbProperty();
            pc.setName("collaborationName");
            pc.setValue(collaborationName);
            queryBBox.getProperty().add(pc);
            GJaxbProperty pk = new GJaxbProperty();
            pk.setName("knownledgeSpaceName");
            pk.setValue(knownledgeSpaceName);
            queryBBox.getProperty().add(pk);
            queryAreaResp = this.findOSMGisClient.findConceptsInsideBBox(queryBBox);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return queryAreaResp;
    }
}

