/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iored;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.net.IPUtil.TRANSPORT_PROTOCOL;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import jakarta.xml.ws.Endpoint;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOREDService extends RIOGAService {


	private static Logger LOG = LoggerFactory.getLogger(RIOREDService.class.getName());





	public RIOREDService() throws Exception {
		this(new HashMap<String, Object>());
	}

	public RIOREDService(Map<String, Object> context) throws Exception {
		super(context);
	}




	@Override
	public String getName() {
		return "r-iored";
	}

	public String getRedirection() {
		return "/riored";
	}


	@SuppressWarnings("unchecked")
	@Override
	public RIOREDApplicationContext createApplicationContext() throws Exception {
		return new RIOREDApplicationContext(this);
	}


	@Override
	public void doRun(Configuration configuration, Environment environment,
			RestResourceManager resourcesManager) throws Exception {
		super.doRun(configuration, environment, resourcesManager);

		// resourcesManager.addResource(new CEPResource(conf));
		// resourcesManager.addResource(new EventProducerAgentResource(conf));
		resourcesManager.addResource(new TimeSeriesResource(conf));

	}




}
