/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.ioplay;

/*
 * #%L
 * dw-generic-sig
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;

import org.apache.commons.io.FileUtils;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.r.iored.RIOREDService;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOREDAppTest {

	public static void main(String[] args) throws Exception {

		RIOConstant.RESOURCES_FOLDER = "./target/resourcesFolder";
		FileUtils.deleteDirectory(new File("./target/neo4j-db").getCanonicalFile());

		Configuration conf = new Configuration(
				Thread.currentThread().getContextClassLoader().getResource("conf/config.properties"));
		GovernanceWebService collabGovServer = GovernanceWebService.create(10007, conf.getProperties().get("storage"));

		RIOREDService appService = new RIOREDService();

		appService.boot(conf);

		appService.run(new String[] { "serverWithoutLog",
				new File(appService.getYmlConfig().toURI()).getCanonicalFile().toString() });

	}

}
