/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iose;

import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbCreateSensorEvent;
import fr.emac.gind.eventtype.GJaxbEndedDatasetEvent;
import fr.emac.gind.eventtype.GJaxbStartSensorEvent;
import fr.emac.gind.eventtype.GJaxbStopSensorEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;

@WebService(serviceName = "NotifierClientService", portName = "NotifierClientEndpoint", targetNamespace = "http://www.gind.emac.fr/notifier", wsdlLocation = "/wsdl/notifier.wsdl", endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class RIOSENotifierClient extends AbstractNotifierClient {

	private static Logger LOG = LoggerFactory.getLogger(RIOSENotifierClient.class.getName());

	private WebsocketCommand WEB_SOCKET_COMMAND = null;

	public RIOSENotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
		super(address);
		this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
	}

	@Override
	public synchronized void notify(GJaxbNotify notify) {
		try {
			GJaxbGetResult result = null;
			LOG.debug("[RIOSE Event] received notifcation");
			Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);

			String json = null;
			String collaborationName = null;
			String knowledgeName = null;

			if ("createSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
				LOG.debug("[RIOSE Event] received CreateSensorEvent");
				GJaxbCreateSensorEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbCreateSensorEvent.class);
				collaborationName = event.getCollaborationName();
				knowledgeName = event.getKnowledgeSpaceName();
				json = JSONJAXBContext.getInstance().marshallAnyElement(event);
			} else if ("startSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
				LOG.debug("[RIOSE Event] received StartSensorEvent");
				GJaxbStartSensorEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbStartSensorEvent.class);
				collaborationName = event.getCollaborationName();
				knowledgeName = event.getKnowledgeSpaceName();
				json = JSONJAXBContext.getInstance().marshallAnyElement(event);
			} else if ("stopSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
				LOG.debug("[RIOSE Event] received StopSensorEvent");
				GJaxbStopSensorEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbStopSensorEvent.class);
				collaborationName = event.getCollaborationName();
				knowledgeName = event.getKnowledgeSpaceName();
				json = JSONJAXBContext.getInstance().marshallAnyElement(event);
			} 


			if (json != null && collaborationName != null && knowledgeName != null) {
				Map<QName, Element> mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
				JSONObject jsonResult = new JSONObject();
				jsonResult.put("event", new JSONObject(json));
				jsonResult.put("createAt",
						mapInfo.get(new QName("http://www.gind.emac.fr", "createAt")).getTextContent());
				jsonResult.put("sendAt", mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt")).getTextContent());

				GJaxbGetResult request = new GJaxbGetResult();
				request.setWebsocketId(
						"/riose" + "/" + RegExpHelper.toRegexFriendlyName(collaborationName).hashCode() + "/"
								+ RegExpHelper.toRegexFriendlyName(knowledgeName).hashCode());
				request.setJsonResult(jsonResult.toString());

				WEB_SOCKET_COMMAND.getResult(request);
			}
		} catch (Exception e) {
			LOG.warn(e.getMessage(), e);
		}
	}

}
