/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iose;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.net.IPUtil.TRANSPORT_PROTOCOL;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOSEService extends RIOGAService {


	private static Logger LOG = LoggerFactory.getLogger(RIOSEService.class.getName());

	
	public static NotificationConsumerWebService RIOSE_CONSUMER = null;
	public static AbstractNotifierClient RIOSE_NOTIFIER = null;


	
	public RIOSEService() throws Exception {
		this(new HashMap<String, Object>());
	}

	public RIOSEService(Map<String, Object> context) throws Exception {
		super(context);
	}

	@Override
	public String getName() {
		return "r-iose";
	}

	public String getRedirection() {
		return "/riose";
	}


	@SuppressWarnings("unchecked")
	@Override
	public RIOSEApplicationContext createApplicationContext() throws Exception {
		return new RIOSEApplicationContext(this);
	}

	@Override
	public void doRun(Configuration configuration, Environment environment,
			RestResourceManager resourcesManager) throws Exception {
		super.doRun(configuration, environment, resourcesManager);
		activatePubSubServerServlet(environment);

		
		// Receive notification from datasource: LOG in event
		createNotifierToDatasetAndSensorStatusEvent();
		
		resourcesManager.addResource(new TimeSeriesResource(conf));
	}
	
	
	private void createNotifierToDatasetAndSensorStatusEvent() throws Exception {
		if (RIOSE_CONSUMER == null) {
			final String logNotifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP,
					conf.getHost(), Integer.parseInt(conf.getProperties().get("riose-notifier-for-sensors-status-port")), 
					Integer.parseInt(conf.getProperties().get("proxy-port")),
					"/RIOSeNotifierForSensors");
			RIOSE_NOTIFIER = new RIOSENotifierClient(logNotifierClientAddress, WEB_SOCKET_COMMAND);
			RIOSE_CONSUMER = new NotificationConsumerWebService();
			RIOSE_CONSUMER.start(new HashMap<String, Object>() {
				{
					put("host", "0.0.0.0");
					put("port", conf.getProperties().get("riose-notifier-for-sensors-status-port"));
					put("serviceName", "RIOSeNotifierForSensors");
					put("notifierClient", RIOSE_NOTIFIER);
				}
			});
			
			String brokerSubscribeAddress = this.conf.getProperties().get("event-broker");
			RIOSE_NOTIFIER.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allDatasetTopic"));
			
			String sensorManagerSubscriberAddress = this.conf.getProperties().get("sensor-manager-server") + "Subscriber";
			RIOSE_NOTIFIER.subscribeOn(sensorManagerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorTopic"));
		}
	}

	
	@Override
	public void stop() throws Exception {
		if (RIOSE_CONSUMER != null) {
			RIOSE_CONSUMER.stop();
		}

		super.stop();
	}

}
