/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iosemit;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.net.IPUtil.TRANSPORT_PROTOCOL;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.rio.dw.resources.GameMasterResource;
import fr.emac.gind.rio.dw.resources.MockEndpointsManagerResource;
import fr.emac.gind.rio.dw.resources.SensorControlerResource;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOSEMITService extends RIOGAService {

	private static Logger LOG = LoggerFactory.getLogger(RIOSEMITService.class.getName());

	public static NotificationConsumerWebService RIOSEMIT_CONSUMER = null;
	public static AbstractNotifierClient RIOSEMIT_NOTIFIER = null;

	protected SensorControlerResource sensorControlerResource = null;

	public RIOSEMITService() throws Exception {
		this(new HashMap<String, Object>());
	}

	public RIOSEMITService(Map<String, Object> context) throws Exception {
		super(context);
	}

	@Override
	public String getName() {
		return "r-iosemit";
	}

	public String getRedirection() {
		return "/riosemit";
	}

	@SuppressWarnings("unchecked")
	@Override
	public RIOSEMITApplicationContext createApplicationContext() throws Exception {
		return new RIOSEMITApplicationContext(this);
	}

	@Override
	public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager)
			throws Exception {
		super.doRun(configuration, environment, resourcesManager);

		// Receive notification from datasource: LOG in event
		createNotifierToDatasetAndSensorStatusEvent();

		resourcesManager.addResource(new SensorControlerResource(conf, this.fileResource,
				SENSOR_MANAGER_NOTIFIER));
		resourcesManager.addResource(new MockEndpointsManagerResource(conf));
		resourcesManager.addResource(new GameMasterResource(conf, this.fileResource));
		resourcesManager.addResource(new TimeSeriesResource(conf));

		activatePubSubServerServlet(environment);
	}

	private void createNotifierToDatasetAndSensorStatusEvent() throws Exception {
		if (RIOSEMIT_CONSUMER == null) {
			final String logNotifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP,
					conf.getHost(), Integer.parseInt(conf.getProperties().get("riosemit-notifier-for-dataset-sensors-status-port")), 
					Integer.parseInt(conf.getProperties().get("proxy-port")),
					"/RIOSemitNotifierForSensors");
			RIOSEMIT_NOTIFIER = new RIOSEMITNotifierClient(logNotifierClientAddress, WEB_SOCKET_COMMAND);
			RIOSEMIT_CONSUMER = new NotificationConsumerWebService();
			RIOSEMIT_CONSUMER.start(new HashMap<String, Object>() {
				{
					put("host", "0.0.0.0");
					put("port", conf.getProperties().get("riosemit-notifier-for-dataset-sensors-status-port"));
					put("serviceName", "RIOSemitNotifierForSensors");
					put("notifierClient", RIOSEMIT_NOTIFIER);
				}
			});
			
			String sensorControlerSubscriberAddress = this.conf.getProperties().get("sensor-controler-server") + "Subscriber";
			RIOSEMIT_NOTIFIER.subscribeOn(sensorControlerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allDatasetTopic"));
			RIOSEMIT_NOTIFIER.subscribeOn(sensorControlerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorControlerTopic"));
					
			String sensorManagerSubscriberAddress = this.conf.getProperties().get("sensor-manager-server") + "Subscriber";
			RIOSEMIT_NOTIFIER.subscribeOn(sensorManagerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorTopic"));
		}
	}

	@Override
	public void stop() throws Exception {
		if (RIOSEMIT_CONSUMER != null) {
			RIOSEMIT_CONSUMER.stop();
		}

		super.stop();
	}

}
