/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.game_master.GameMasterApi;
import fr.emac.gind.game_master.GameMasterManagerClient;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenario;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenario;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetGameScenarios;
import fr.emac.gind.game_master.data.GJaxbGetGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenario;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenario;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenarioResponse;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/gameMaster")
//@Api("gameMaster")
@Produces(MediaType.APPLICATION_JSON)
public class GameMasterResource {

	private static Logger LOG = LoggerFactory.getLogger(GameMasterResource.class);

	private GameMasterApi gmClient = null;
	private FileResource fileResource = null;

	public GameMasterResource(Configuration conf, FileResource fileResource) throws Exception {
		this.gmClient = GameMasterManagerClient.createClient(conf.getProperties().get("game-master-server").toString());
		this.fileResource = fileResource;
	}

	@POST
	@Path("/setCurrentGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbSetCurrentGameScenarioResponse setCurrentGameScenario(@Auth DWUser user,
			GJaxbSetCurrentGameScenario req) throws Exception {
		GJaxbSetCurrentGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.setCurrentGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	
	@POST
	@Path("/getCurrentGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbGetCurrentGameScenarioResponse getCurrentGameScenario(@Auth DWUser user,
			GJaxbGetCurrentGameScenario req) throws Exception {
		GJaxbGetCurrentGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.getCurrentGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/getGameScenarios")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbGetGameScenariosResponse getGameScenarios(@Auth DWUser user, GJaxbGetGameScenarios req)
			throws Exception {
		GJaxbGetGameScenariosResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.getGameScenarios(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/createGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbCreateGameScenarioResponse createGameScenario(@Auth DWUser user, GJaxbCreateGameScenario req)
			throws Exception {
		GJaxbCreateGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.createGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/updateGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbUpdateGameScenarioResponse updateGameScenario(@Auth DWUser user, GJaxbUpdateGameScenario req)
			throws Exception {
		GJaxbUpdateGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.updateGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/deleteGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbDeleteGameScenarioResponse deleteGameScenario(@Auth DWUser user, GJaxbDeleteGameScenario req)
			throws Exception {
		GJaxbDeleteGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.deleteGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	
	@POST
	@Path("/saveGameScenario")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbSaveGameScenarioResponse saveGameScenario(@Auth DWUser user, GJaxbSaveGameScenario req)
			throws Exception {
		GJaxbSaveGameScenarioResponse response = null;
		try {
			req.setCollaborationName(user.getCurrentCollaborationName());
			req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());

			response = this.gmClient.saveGameScenario(req);
		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}



}