/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.mock.endpoints.manager.FaultMessage;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManager;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerClient;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodId;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodIdResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpoints;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpointsResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpointResponse;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/mockEndpointManager")
//@Api("eventMockEndpoint")
@Produces(MediaType.APPLICATION_JSON)
public class MockEndpointsManagerResource {

	private static Logger LOG = LoggerFactory.getLogger(MockEndpointsManagerResource.class);

	private MockEndpointManager mockEndpointsManagerClient = null;

	private Configuration conf = null;

	public MockEndpointsManagerResource(Configuration conf) throws Exception {
		this.mockEndpointsManagerClient = MockEndpointManagerClient.createClient(conf.getProperties().get("mock-endpoints-manager-server"));
		
		this.conf = conf;
	}

	@POST
	@Path("/createMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbCreateMockEndpointResponse createMockEndpoint(@Auth DWUser user, GJaxbCreateMockEndpoint req) throws Exception {
		GJaxbCreateMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}
			
			response = this.mockEndpointsManagerClient.createMockEndpoint(req);

			
		} catch (Exception e) {

			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}


	@POST
	@Path("/startMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbStartMockEndpointResponse startMockEndpoint(@Auth DWUser user, GJaxbStartMockEndpoint req) throws Exception {
		GJaxbStartMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.startMockEndpoint(req);

		} catch (Exception e) {

			GindWebApplicationException.manageError(e, this);
		}
		LOG.debug("Start mock endpoint at url: " + response.getMockEndpoint().getAddress());
		return response;
	}


	@POST
	@Path("/stopMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbStopMockEndpointResponse stopMockEndpoint(@Auth DWUser user, GJaxbStopMockEndpoint req) throws Exception {

		GJaxbStopMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = this.mockEndpointsManagerClient.stopMockEndpoint(req);
			
		} catch (Exception e) {

			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/deleteMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbDeleteMockEndpointResponse deleteMockEndpoint(@Auth DWUser user, GJaxbDeleteMockEndpoint req)
			throws Exception {
		GJaxbDeleteMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.deleteMockEndpoint(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		LOG.debug("Delete mock endpoint with id: " + req.getId());
		return response;
	}


	@GET
	@Path("/getMockEndpoints")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbGetMockEndpointsResponse getMockEndpoints(@Auth DWUser user) throws Exception {

		GJaxbGetMockEndpointsResponse response = null;
		try {
			GJaxbGetMockEndpoints request = new GJaxbGetMockEndpoints();
			request.setCollaborationName(user.getCurrentCollaborationName());
			request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			response = this.mockEndpointsManagerClient.getMockEndpoints(request);
			
		} catch (Exception e) {
			e.printStackTrace();
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	

	@POST
	@Path("/findMockEndpointByGoodId")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbFindMockEndpointByGoodIdResponse findMockEndpointByGoodId(@Auth DWUser user, GJaxbFindMockEndpointByGoodId req)
			throws Exception {
		GJaxbFindMockEndpointByGoodIdResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.findMockEndpointByGoodId(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	
	
	@POST
	@Path("/runActuatorOnMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbRunActuatorOnMockEndpointResponse runActuatorOnMockEndpoint(@Auth DWUser user, GJaxbRunActuatorOnMockEndpoint req)
			throws Exception {
		GJaxbRunActuatorOnMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.runActuatorOnMockEndpoint(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	
	@POST
	@Path("/addExchangeOnMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbAddExchangeOnMockEndpointResponse addExchangeOnMockEndpoint(@Auth DWUser user, GJaxbAddExchangeOnMockEndpoint req)
			throws Exception {
		GJaxbAddExchangeOnMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.addExchangeOnMockEndpoint(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

	@POST
	@Path("/deleteExchangeOnMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbDeleteExchangeOnMockEndpointResponse deleteExchangeOnMockEndpoint(
			@Auth DWUser user, GJaxbDeleteExchangeOnMockEndpoint req) throws Exception {
		GJaxbDeleteExchangeOnMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.deleteExchangeOnMockEndpoint(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}
	
	@POST
	@Path("/playExchangeOnMockEndpoint")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public GJaxbPlayExchangeOnMockEndpointResponse playExchangeOnMockEndpoint(
			@Auth DWUser user, GJaxbPlayExchangeOnMockEndpoint req) throws Exception {
		GJaxbPlayExchangeOnMockEndpointResponse response = null;
		try {
			if (req.getCollaborationName() == null) {
				req.setCollaborationName(user.getCurrentCollaborationName());
			}
			if (req.getKnowledgeSpaceName() == null) {
				req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			}

			response = mockEndpointsManagerClient.playExchangeOnMockEndpoint(req);

		} catch (Exception e) {
			GindWebApplicationException.manageError(e, this);
		}
		return response;
	}

}