/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import org.apache.poi.openxml4j.util.ZipSecureFile;

import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaignResponse;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbGlobalCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaignSolution;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.workflow.AbstractProcessGenerator;
import fr.emac.gind.campaign.manager.CampaignManagerItf;

/*
 * #%L
 * dw-logistics-modeler
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/r-iosepe/campaign/json")
//@Api("json")
@Consumes(MediaType.APPLICATION_JSON)
public class JsonResource {


  private CampaignManagerItf campaignClient = null;
  
  private List<AbstractProcessGenerator> processGenerators = new ArrayList<AbstractProcessGenerator>();


  public JsonResource(Configuration conf) throws Exception {
    if(conf != null) {
      this.campaignClient = CampaignManagerClient.createClient((String) conf.getProperties().get("campaign-manager"));
    }
    this.initProcessGenerator();
  }
  
  public void initProcessGenerator() {
    ServiceLoader<AbstractProcessGenerator> processGeneratorLoader = ServiceLoader.load(AbstractProcessGenerator.class);
    // Discover and register the available commands
    processGenerators.clear();
    processGeneratorLoader.reload();
    Iterator<AbstractProcessGenerator> processGeneratorsIterator = processGeneratorLoader.iterator();
    while (processGeneratorsIterator.hasNext()) {
      AbstractProcessGenerator processGenerator = processGeneratorsIterator.next();

      this.processGenerators.add(processGenerator);
    }
  }


  @POST @Path("/exportCampaign")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_OCTET_STREAM)
  public Response exportAsExcel(@Auth DWUser user, String campaignId) throws Exception {
    Response res = null;
    try {


      GJaxbGetCampaign request = new GJaxbGetCampaign();
      request.setCampaignId(campaignId);
      GJaxbGetCampaignResponse response = this.campaignClient.getCampaign(request);

      GJaxbCampaign campaign = response.getCampaign();


      GJaxbGetSolutionsFromCampaign getParam = new GJaxbGetSolutionsFromCampaign();
      getParam.setCampaignId(campaign.getCampaignId());
      GJaxbGetSolutionsFromCampaignResponse responseGet = this.campaignClient.getSolutionsFromCampaign(getParam);


      GJaxbGlobalCampaign globalCampaign = new GJaxbGlobalCampaign();
      globalCampaign.setCampaign(campaign);
      globalCampaign.getCampaignSolution().addAll(responseGet.getCampaignSolution());
      
      String json = JSONJAXBContext.getInstance().marshallAnyElement(globalCampaign, true);

      ZipSecureFile.setMinInflateRatio(-1.0d);
      res = Response.ok(new ByteArrayInputStream(json.getBytes()), MediaType.APPLICATION_OCTET_STREAM).build();
    } catch(Exception e) {
      e.printStackTrace();
      GindWebApplicationException.manageError(e, this);
    }
    return res;
  }

  
  @POST @Path("/exportSolutions")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_OCTET_STREAM)
  public Response exportAsExcel(@Auth DWUser user, List<GJaxbCampaignSolution> Solutions) throws Exception {
    Response res = null;
    try {


      GJaxbGlobalCampaign globalCampaign = new GJaxbGlobalCampaign();
      globalCampaign.getCampaignSolution().addAll(Solutions);
      
      String json = JSONJAXBContext.getInstance().marshallAnyElement(globalCampaign, true);

      ZipSecureFile.setMinInflateRatio(-1.0d);
      res = Response.ok(new ByteArrayInputStream(json.getBytes()), MediaType.APPLICATION_OCTET_STREAM).build();
    } catch(Exception e) {
      e.printStackTrace();
      GindWebApplicationException.manageError(e, this);
    }
    return res;
  }


}
