/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iota;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

import org.json.JSONObject;

import fr.emac.gind.detectiongeneratorinstance.GJaxbDetectionGeneratorInstance;
import fr.emac.gind.detectiongeneratorinstance.GJaxbDetectionGeneratorInstances;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.monitoring.detection.AbstractDetection;
import fr.emac.gind.r.ioda.RIODAApplicationContext;

public class RIOTAApplicationContext extends RIODAApplicationContext {

	static {
		try {
			JSONJAXBContext.getInstance().addOtherObjectFactory(fr.emac.gind.detectiongeneratorinstance.ObjectFactory.class);
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	private GJaxbDetectionGeneratorInstances additionnalDetectionGeneratorInstances = null;
	
	@SuppressWarnings("rawtypes")
	private ServiceLoader<AbstractDetection> detectionStrategiesLoader = ServiceLoader.load(AbstractDetection.class);
	private Map<String, AbstractDetection<?>> detectionStrategies = new HashMap<String, AbstractDetection<?>>();


	public RIOTAApplicationContext(DWApplicationService applicationService) throws Exception {
		super(applicationService);
		this.additionnalDetectionGeneratorInstances = initDetectionStrategies();
	}

	@SuppressWarnings("rawtypes")
	private GJaxbDetectionGeneratorInstances initDetectionStrategies() throws Exception {
		GJaxbDetectionGeneratorInstances res = new GJaxbDetectionGeneratorInstances();
		// Discover and register the available commands
		detectionStrategies.clear();
		detectionStrategiesLoader.reload();
		Iterator<AbstractDetection> processGeneratorsIterator = detectionStrategiesLoader.iterator();
		while (processGeneratorsIterator.hasNext()) {
			AbstractDetection<?> detectionStrategy = processGeneratorsIterator.next();
			// detectionStrategy.setCoreClient(coreClient);
			detectionStrategies.put(detectionStrategy.getClass().getName(), detectionStrategy);
			GJaxbDetectionGeneratorInstance gen = new GJaxbDetectionGeneratorInstance();
			gen.setName(detectionStrategy.getName());
			gen.setClazz(detectionStrategy.getClass().getName());
			gen.setDescription(detectionStrategy.getDescription());
			gen.setInputNgClickFunction(detectionStrategy.getInputJavascriptFunctionToCall());
			gen.setOutputNgClickFunction(detectionStrategy.getOutputJavascriptFunctionToCall());

			res.getDetectionGeneratorInstance().add(gen);
		}
		return res;
	}


	@Override
	public JSONObject toJSON() throws Exception {
		JSONObject context = super.toJSON();
		context.put("detectionMethods", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(additionnalDetectionGeneratorInstances).toString()));
		context.put("lightControlerActivable", ((RIOTAService)this.applicationService).getLightControlerResource().isActivated());
		return context;
	}


}
