/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iota;

import java.util.Map;

import javax.xml.namespace.QName;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbAddEdgeEvent;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveEdgeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveNodeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateEdgeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateNodeEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;


@WebService(
    serviceName = "NotifierClientService",
    portName = "NotifierClientEndpoint",
    targetNamespace = "http://www.gind.emac.fr/notifier",
    wsdlLocation = "/wsdl/notifier.wsdl",
    endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class RIOTACoreGovNotifierClient extends AbstractNotifierClient {
  
  private static Logger LOG = LoggerFactory.getLogger(RIOTACoreGovNotifierClient.class.getName());
  
  private WebsocketCommand WEB_SOCKET_COMMAND = null;
  private String name = null;
  private CoreResource coreResource = null;
  private ModelsResource modelsResource = null;

  public RIOTACoreGovNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name, CoreResource coreResource, ModelsResource modelsResource) throws Exception {
    super(address);
    this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
    this.name = name;
    this.coreResource = coreResource;
    this.modelsResource = modelsResource;
  }

  @Override
  public void notify(GJaxbNotify notify) {
    try {
      
      Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);

      String json = null;
      String collaborationName = null;
      String knowledgeName = null;
      if(doc.getDocumentElement().getLocalName().equals("addNodeEvent")) {
        GJaxbAddNodeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddNodeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else if(doc.getDocumentElement().getLocalName().equals("updateNodeEvent")) {
        GJaxbUpdateNodeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateNodeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else if(doc.getDocumentElement().getLocalName().equals("removeNodeEvent")) {
        GJaxbRemoveNodeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbRemoveNodeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else if(doc.getDocumentElement().getLocalName().equals("addEdgeEvent")) {
        GJaxbAddEdgeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddEdgeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else if(doc.getDocumentElement().getLocalName().equals("updateEdgeEvent")) {
        GJaxbUpdateEdgeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateEdgeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else if(doc.getDocumentElement().getLocalName().equals("removeEdgeEvent")) {
        GJaxbRemoveEdgeEvent event = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbRemoveEdgeEvent.class);
        collaborationName = event.getCollaborationName();
        knowledgeName = event.getKnowledgeSpaceName();
        json = JSONJAXBContext.getInstance().marshallAnyElement(event);
      } else {
        LOG.warn("Event not take into a charge: " + doc.getDocumentElement().getLocalName());
      }

      if(json != null && collaborationName != null && knowledgeName != null) {
        String cleanJson = json.replace("##application_name##", this.name);

        Map<QName, Element> mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
        JSONObject jsonResult = new JSONObject();
        jsonResult.put("event", cleanJson);
        jsonResult.put("createAt", mapInfo.get(new QName("http://www.gind.emac.fr", "createAt")).getTextContent());
        jsonResult.put("sendAt", mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt")).getTextContent());

        GJaxbGetResult request = new GJaxbGetResult();
        request.setWebsocketId("/riota" + "/" + RegExpHelper.toRegexFriendlyName(collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName(knowledgeName).hashCode());
        request.setJsonResult(jsonResult.toString());

        WEB_SOCKET_COMMAND.getResult(request);
      }

    } catch (Exception e) {
      LOG.warn(e.getMessage(), e);
    }
  }

}
