/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iota;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import javax.xml.namespace.QName;

import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventcommonsdata.GJaxbProcessStatusType;
import fr.emac.gind.eventtype.GJaxbMonitoringProcessInstanceProgressionEvent;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.models_gov.GJaxbConnexionModeType;
import fr.emac.gind.gov.models_gov.GJaxbOptionalParameters;
import fr.emac.gind.gov.models_gov.GJaxbOptionalParameters.Publication;
import fr.emac.gind.gov.models_gov.GJaxbPublishMode;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbNode.BrokenEdges.BrokenEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.SolutionResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.websocket.command.WebsocketCommand;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;

@WebService(serviceName = "NotifierClientService", portName = "NotifierClientEndpoint", targetNamespace = "http://www.gind.emac.fr/notifier", wsdlLocation = "/wsdl/notifier.wsdl", endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class RIOTAMonitoringNotifierClient extends AbstractNotifierClient {

	private static Logger LOG = LoggerFactory.getLogger(RIOTAMonitoringNotifierClient.class.getName());

	private WebsocketCommand WEB_SOCKET_COMMAND = null;
	private String name = null;
	private CoreResource coreResource = null;
	private ModelsResource modelsResource = null;
	private SystemResource systemResource = null;
	private SolutionResource solutionResource = null;

	public RIOTAMonitoringNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name,
			CoreResource coreResource, ModelsResource modelsResource, SystemResource systemResource, SolutionResource solutionResource) throws Exception {
		super(address);
		this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
		this.name = name;
		this.coreResource = coreResource;
		this.modelsResource = modelsResource;
		this.systemResource = systemResource;
		this.solutionResource = solutionResource;
	}

	@Override
	public void notify(GJaxbNotify notify) {
		try {
			LOG.debug("[R-IOTA Event] Received notif on R-IOTA");
			System.out.println("[R-IOTA Event] Received notif on R-IOTA");
			Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
			GJaxbMonitoringProcessInstanceProgressionEvent me = XMLJAXBContext.getInstance().unmarshallDocument(doc,
					GJaxbMonitoringProcessInstanceProgressionEvent.class);

			if (me.getMonitoringInstanceProgression().getProcessStatus() == GJaxbProcessStatusType.RUNNING
					&& me.getMonitoringInstanceProgression().getLastExchange().getExchange().getOut() != null) {
				LOG.debug("[R-IOTA Event] process running and get last exchange ended");
				System.out.println("[R-IOTA Event] process running and get last exchange ended");
				// find and delete objective satisfied
				String taskId = me.getMonitoringInstanceProgression().getLastExchange().getExchange().getTaskId();
				String collaborationName = RegExpHelper.toRegexFriendlyName(
						me.getMonitoringInstanceProgression().getLastExchange().getExchange().getCollaborationName());
				String knowledgeName = RegExpHelper.toRegexFriendlyName(
						me.getMonitoringInstanceProgression().getLastExchange().getExchange().getKnowledgeSpaceName());
				DWUser fictiveUser = new DWUser(new GJaxbNode(), true, this.systemResource.getSystemClient());
				fictiveUser.setCurrentCollaborationName(collaborationName);
				fictiveUser.setCurrentKnowledgeSpaceName(knowledgeName);

				GJaxbGetNode req = new GJaxbGetNode();
				req.setId(taskId);
				GJaxbNode task = this.coreResource.getNode(fictiveUser, req).getNode();
				LOG.debug("[R-IOTA Event] task ended: " + GenericModelHelper.getName(task));
				System.out.println("[R-IOTA Event] task ended: " + GenericModelHelper.getName(task));

				GJaxbGenericModel objModel = null;
				if (task.getBrokenEdges() != null) {
					Optional<BrokenEdge> beo = task.getBrokenEdges().getBrokenEdge().stream()
							.filter(be -> be.getEdge().getType()
									.equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Created_By")))
							.findFirst();
					if (beo.isPresent()) {
						GJaxbProperty satisfies = GenericModelHelper.findProperty("satisfies",
								beo.get().getEdge().getProperty());
						if (satisfies != null) {
							List<List<GJaxbProperty>> props_table = GenericModelHelper
									.convertJSONArrayToTable(new JSONArray(satisfies.getValue()));
							for (List<GJaxbProperty> props : props_table) {
								String objId = GenericModelHelper.findProperty("id", props).getValue();
								
								GJaxbNode selectedSolution = this.solutionResource._findSelectedSolution(fictiveUser);
								
								String expectedObjId = "expected_freeze" + "##"
										+ selectedSolution.getId()+ "##" + objId
										+ "_c__" + RegExpHelper.toRegexFriendlyName(collaborationName) + "_k__"
										+ RegExpHelper.toRegexFriendlyName(knowledgeName);
								String objQuery = "match (o:EXPECTED_FREEZE:" + Neo4JReqConstant.collab("Objective")
										+ " { modelNodeId: '" + expectedObjId + "' })-[r:"
										+ Neo4JReqConstant.collab("Treats") + "|" + Neo4JReqConstant.collab("Prevents")
										+ "]->(ap) return distinct o, ap, r ";
								objModel = this.modelsResource.query(fictiveUser, objQuery, null);

								if (objModel != null && objModel.getNode() != null && !objModel.getNode().isEmpty()) {
									GJaxbNode actOrPot = GenericModelHelper
											.findNodesByType(GenericModelHelper.collab("Actuality"), objModel.getNode())
											.get(0);
									if (actOrPot == null) {
										actOrPot = GenericModelHelper.findNodesByType(
												GenericModelHelper.collab("Potentiality"), objModel.getNode()).get(0);
									}
									final String actOrPotId = actOrPot.getId();
									String actQuery = "match (ap:EXPECTED_FREEZE" + " { modelNodeId: '"
											+ Neo4JId.createIdUsingCollaboration(actOrPotId, collaborationName, knowledgeName)
											+ "' })<-[r:" + Neo4JReqConstant.collab("Treats") + "|"
											+ Neo4JReqConstant.collab("Prevents") + "]-(o:"
											+ Neo4JReqConstant.collab("Objective") + ") return distinct o";
									GJaxbGenericModel actModel = this.modelsResource.query(fictiveUser, actQuery, null);

									List<GJaxbNode> objectivesAssociatedToActOrPot = GenericModelHelper.findNodesByType(
											GenericModelHelper.collab("Objective"), actModel.getNode());

									GJaxbGenericModel modelToDelete = objModel;
									if (objectivesAssociatedToActOrPot.size() > 1) {
										modelToDelete.getNode().removeIf((n) -> {
											return n.getId().equals(actOrPotId);
										});
									}
									LOG.debug("[R-IOTA Event] unpublish start ");
									System.out.println("[R-IOTA Event] unpublish start ");
									if (!objModel.getNode().isEmpty()) {
										
										GJaxbOptionalParameters gJaxbOptionalParameters = new GJaxbOptionalParameters();
										gJaxbOptionalParameters.setPublication(new Publication());
										gJaxbOptionalParameters.getPublication().setMode(GJaxbConnexionModeType.SYNC);
										gJaxbOptionalParameters.getPublication().setPublishOptions(new GJaxbPublishOptions());
										gJaxbOptionalParameters.getPublication().getPublishOptions().setPublishMode(GJaxbPublishMode.COMPLETE_TRANSACTION);
										gJaxbOptionalParameters.getPublication().getPublishOptions().setNotification(new GJaxbNotification());
										gJaxbOptionalParameters.getPublication().getPublishOptions().getNotification().setActivateNotification(true);
										gJaxbOptionalParameters.getPublication().getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
										gJaxbOptionalParameters.getPublication().getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
										this.modelsResource.unpublish(collaborationName, knowledgeName, modelToDelete,
												gJaxbOptionalParameters,
												Arrays.asList(
														me.getMonitoringInstanceProgression().getProcessInstanceId(),
														CoreGovImpl.DEFAULT_INSTANCE_NODE_LABEL,
														selectedSolution.getId()));
										LOG.debug("[R-IOTA Event] unpublish ended ");
										System.out.println("[R-IOTA Event] unpublish ended ");
									}
								}

							}
						}
					}
				}
				if (objModel == null || objModel.getNode().isEmpty()) {
					LOG.debug("[R-IOTA Event] No objective to delete corresponding to task: "
							+ GenericModelHelper.getName(task));
					System.out.println("[R-IOTA Event] No objective to delete corresponding to task: "
							+ GenericModelHelper.getName(task));

				} else {
					String msg = "";
					for (GJaxbNode n : objModel.getNode()) {
						msg = msg + "'" + GenericModelHelper.getName(n) + "' " + " ('" + n.getType().getLocalPart()
								+ "')" + ", ";
					}
					if (msg.length() > 0) {
						msg = msg.substring(0, msg.length() - ", ".length());
					}
					LOG.debug("[R-IOTA Event] Nodes deleted from task '" + GenericModelHelper.getName(task) + "' : "
							+ msg);
					System.out.println("[R-IOTA Event] Nodes deleted from task '" + GenericModelHelper.getName(task)
							+ "' : " + msg);

				}

			}

			// send progression to browser
			// don't sent message beacuse is already sent in
			// RIOGAMonitoringProcessExchangeNotifierClient

		} catch (Exception e) {
			LOG.warn(e.getMessage(), e);
		}
	}

}
