/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iota;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.net.IPUtil.TRANSPORT_PROTOCOL;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.monitoring.server.MonitoringWebService;
import fr.emac.gind.r.ioda.RIODAService;
import fr.emac.gind.rio.dw.resources.DetectionResource;
import fr.emac.gind.rio.dw.resources.LightControlerResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOTAService extends RIODAService {


	private static Logger LOG = LoggerFactory.getLogger(RIOTAService.class.getName());

	private NotificationConsumerWebService monitoringConsumer = null;
	private NotificationConsumerWebService governanceConsumer = null;
	private LightControlerResource lightControlerResource = null;
	
	public static NotificationConsumerWebService IOT_REFLEX_CONSUMER = null;
	public static AbstractNotifierClient IOT_REFLEX_NOTIFIER = null;


	public RIOTAService() throws Exception {
		this(new HashMap<String, Object>());
	}

	public RIOTAService(Map<String, Object> context) throws Exception {
		super(context);
	}




	@Override
	public String getName() {
		return "r-iota";
	}

	public String getRedirection() {
		return "/riota";
	}


	@SuppressWarnings("unchecked")
	@Override
	public RIOTAApplicationContext createApplicationContext() throws Exception {
		return new RIOTAApplicationContext(this);
	}

	@Override
	public void doRun(Configuration configuration, Environment environment,
			RestResourceManager resourcesManager) throws Exception {
		super.doRun(configuration, environment, resourcesManager);

		
		this.lightControlerResource = new LightControlerResource(conf);
		
	//	resourcesManager.addResource(new EventProducerAgentResource(conf, this.fileResource, null, null, RIOGAService.WEB_SOCKET_COMMAND));
		resourcesManager.addResource(new DetectionResource(conf, (RIOTAApplicationContext) this.getApplicationContext(), this.projectResource, this.fileResource));
		resourcesManager.addResource(this.lightControlerResource);


		createNotifierForMonitoringEvent();
		createNotifierForCoreGovEvent();
		createNotifierForIOTReflexEvent();
	}
	

	public LightControlerResource getLightControlerResource() {
		return lightControlerResource;
	}

	/**
	private void createNotifierForIOTReflexEvent() throws Exception {
		final String notifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP, conf.getHost(), Integer.parseInt(conf.getProperties().get("riota-iot-reflex-notifier-port")),
				Integer.parseInt(conf.getProperties().get("proxy-port")), "/RIOTANotifierForIOTReflex");
		final AbstractNotifierClient notifier = new RIOTAIOTReflexNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, getName(), this.coreResource, this.modelsResource);
		this.governanceConsumer = new NotificationConsumerWebService();
		this.governanceConsumer.start(new HashMap<String, Object>(){{put("host",conf.getProperties().get("host")); put("port", conf.getProperties().get("riota-iot-reflex-notifier-port")); put("serviceName", "RIOTANotifierForIOTReflex"); put("notifierClient", notifier); }});

		if(LocalRegistry.getInstance().findWS(GovernanceWebService.class) != null) {
			GovernanceWebService governanceWebService = LocalRegistry.getInstance().findWS(GovernanceWebService.class);
			NotificationManagerImpl governanceNotifier = governanceWebService.getImplementation(NotificationManagerImpl.class);
			notifier.subscribeOn(governanceNotifier, new QName("http://www.gind.emac.fr/EventType", "reflexTopic"));
		} else {
			String governanceSubscribeAddress = this.conf.getProperties().get("governance").replace("/gov", "/GovCoreSubscriber");
			notifier.subscribeOn(governanceSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "reflexTopic"));
		}
	}
	*/
	
	
	private void createNotifierForIOTReflexEvent() throws Exception {
		if (IOT_REFLEX_CONSUMER == null) {
			final String notifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP,
					conf.getHost(), Integer.parseInt(conf.getProperties().get("riota-iot-reflex-notifier-port")), 
					Integer.parseInt(conf.getProperties().get("proxy-port")),
					"/RIOTANotifierForIOTReflex");
			IOT_REFLEX_NOTIFIER = new RIOTAIOTReflexNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, getName(), this.coreResource, this.modelsResource);
			IOT_REFLEX_CONSUMER = new NotificationConsumerWebService();
			IOT_REFLEX_CONSUMER.start(new HashMap<String, Object>() {
				{
					put("host", "0.0.0.0");
					put("port", conf.getProperties().get("riota-iot-reflex-notifier-port"));
					put("serviceName", "RIOTANotifierForIOTReflex");
					put("notifierClient", IOT_REFLEX_NOTIFIER);
				}
			});
			
			String brokerSubscribeAddress = this.conf.getProperties().get("event-broker");
			IOT_REFLEX_NOTIFIER.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "reflexTopic"));
		}
	}

	

	private void createNotifierForMonitoringEvent() throws Exception {

		final String notifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP, conf.getHost(), Integer.parseInt(conf.getProperties().get("riota-monitoring-notifier-port")),
				Integer.parseInt(conf.getProperties().get("proxy-port")), "/RIOTANotifierForMonitoring");
		final AbstractNotifierClient notifier = new RIOTAMonitoringNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, getName(), this.coreResource, this.modelsResource, this.systemResource, this.solutionResource);
		this.monitoringConsumer = new NotificationConsumerWebService();
		this.monitoringConsumer.start(new HashMap<String, Object>(){{put("host",conf.getProperties().get("host")); put("port", conf.getProperties().get("riota-monitoring-notifier-port")); put("serviceName", "RIOTANotifierForMonitoring"); put("notifierClient", notifier); }});

		if(LocalRegistry.getInstance().findWS(MonitoringWebService.class) != null) {
			MonitoringWebService monitoringWebService = LocalRegistry.getInstance().findWS(MonitoringWebService.class);
			NotificationManagerImpl monitoringProducer =  monitoringWebService.getImplementation(NotificationManagerImpl.class);
			notifier.subscribeOn(monitoringProducer, new QName("http://www.gind.emac.fr/EventType", "monitoringProcessInstanceProgressionTopic"));

		} else {
			String monitoringSubscribeAddress = this.conf.getProperties().get("monitoring-server").replace("ProcessMonitoring", "ProcessMonitoringSubscriber");
			notifier.subscribeOn(monitoringSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "monitoringProcessInstanceProgressionTopic"));
		}
	}


	private void createNotifierForCoreGovEvent() throws Exception {

		final String notifierClientAddress = SPIWebServicePrimitives.createAddress(TRANSPORT_PROTOCOL.HTTP, conf.getHost(), Integer.parseInt(conf.getProperties().get("riota-core-gov-notifier-port")),
				Integer.parseInt(conf.getProperties().get("proxy-port")), "/RIOTaNotifierForGovernance");
		final AbstractNotifierClient notifier = new RIOTACoreGovNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, getName(), this.coreResource, this.modelsResource);
		this.governanceConsumer = new NotificationConsumerWebService();
		this.governanceConsumer.start(new HashMap<String, Object>(){{put("host",conf.getProperties().get("host")); put("port", conf.getProperties().get("riota-core-gov-notifier-port")); put("serviceName", "RIOTaNotifierForGovernance"); put("notifierClient", notifier); }});

		if(LocalRegistry.getInstance().findWS(GovernanceWebService.class) != null) {
			GovernanceWebService governanceWebService = LocalRegistry.getInstance().findWS(GovernanceWebService.class);
			NotificationManagerImpl governanceNotifier = governanceWebService.getImplementation(NotificationManagerImpl.class);
			notifier.subscribeOn(governanceNotifier, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
		} else {
			String governanceSubscribeAddress = this.conf.getProperties().get("governance").replace("/gov", "/GovCoreSubscriber");
			notifier.subscribeOn(governanceSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
		}
	}

	@Override
	public void stop() throws Exception {
		super.stop();
		if(this.governanceConsumer != null) {
			this.governanceConsumer.stop();
		}
		if(this.monitoringConsumer != null) {
			this.monitoringConsumer.stop();
		}
	}

}
