/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.monitoring.detection.GJaxbDetect;
import fr.emac.gind.monitoring.detection.GJaxbDetect.InputData;
import fr.emac.gind.monitoring.detection.GJaxbDetectResponse;
import fr.emac.gind.monitoring.detection.client.DetectionClient;
import fr.emac.gind.monitoring.detectionReport.GJaxbModelsComparison;
import fr.emac.gind.r.iota.RIOTAApplicationContext;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.monitoring.detection.Detection;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/r-iota/detection")
//@Api("detection")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class DetectionResource {

  private static final Logger LOG = LoggerFactory.getLogger(DetectionResource.class.getName());


  private Configuration conf = null;


  private CoreGov coreClient = null;

  private Detection detectionClient = null;

  private ProjectResource projectResource = null;

  private FileResource fileResource = null;


  public DetectionResource(Configuration conf, RIOTAApplicationContext context, ProjectResource projectResource, FileResource fileResource) throws Exception {
    this.conf = conf;
    this.coreClient = CoreGovClient.createClient(conf.getProperties().get("governance").replace("/gov", "/GovCore"));
    this.detectionClient = DetectionClient.createClient(this.conf.getProperties().get("detection-server"));
    this.projectResource = projectResource;
    this.fileResource = fileResource;
  }


  @POST @Path("/detect")
  public GJaxbDetectResponse detect(@Auth DWUser user, GJaxbDetect request) throws Exception {
    request.setCurrentCollaborationName(user.getCurrentCollaborationName());
    request.setCurrentKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
    String expected_labels = "EXPECTED_FREEZE:`" + request.getSolutionId() + "`"; 
    GJaxbGenericModel expectedModel = CoreGovClient.singleQuery(this.coreClient, "match (n:instance:" + expected_labels + ") optional match (n:instance:" + expected_labels + ")-[r]-(n1:instance:" + expected_labels + ") where "
        + "not n:" + Neo4JReqConstant.system("User") + " and not n:"+ Neo4JReqConstant.system("Collaboration") +" and not n:"+ Neo4JReqConstant.project("Project") +" and "
        + "not n1:" + Neo4JReqConstant.system("User") + "  and not n1:"+ Neo4JReqConstant.system("Collaboration") +" and not n1:"+ Neo4JReqConstant.project("Project") +" return distinct n, n1, r", user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName());
    GJaxbGenericModel activeModel = CoreGovClient.singleQuery(this.coreClient, "match (n:instance:" + "ACTIVE" + ") optional match (n:instance:" + "ACTIVE" + ")-[r]-(n1:instance:" + "ACTIVE" + ") where "
        + "not n:" + Neo4JReqConstant.system("User") + "  and not n:"+ Neo4JReqConstant.system("Collaboration") +" and not n:"+ Neo4JReqConstant.project("Project") +" and "
        + "not n1:" + Neo4JReqConstant.system("User") + "  and not n1:"+ Neo4JReqConstant.system("Collaboration") +" and not n1:"+ Neo4JReqConstant.project("Project") + " return distinct n, n1, r", user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName());
    if(expectedModel != null) {
      expectedModel.getNode().forEach(n -> {
        try {
          if(n.getId().lastIndexOf("##")>=0) {
            n.setId(n.getId().substring(n.getId().lastIndexOf("##") + "##".length()));
          }

          GJaxbNode parent  = GenericModelHelper.findFirstParent(n, expectedModel);

          if(parent != null) {
            if(parent.getId().lastIndexOf("##")>=0) {
              parent.setId(parent.getId().substring(parent.getId().lastIndexOf("##") + "##".length()));
            }
          }
        } catch (Exception e1) {
          e1.printStackTrace();
          throw new RuntimeException(e1);
        }
      });
      expectedModel.getEdge().forEach(e -> {
        e.setId(e.getId().substring(e.getId().lastIndexOf("##") + "##".length()));
        if(e.isSetSource()) {
          if(e.getSource().getId().lastIndexOf("##") >= 0) {
            e.getSource().setId(e.getSource().getId().substring(e.getSource().getId().lastIndexOf("##") + "##".length()));
          }
        }
        if(e.isSetTarget()) {
          if(e.getTarget().getId().lastIndexOf("##") >= 0) {
            e.getTarget().setId(e.getTarget().getId().substring(e.getTarget().getId().lastIndexOf("##") + "##".length()));
          }
        }
      });
    }
    if(request.getDetectionGeneratorInstance().getName().toLowerCase().equals("D3Strategy detection".toLowerCase())) {
      GJaxbNode project = this.projectResource.getProjectByNameInCollaboration(user, user.getCurrentKnowledgeSpaceName(), user.getCurrentCollaborationName());
      GJaxbProperty d3MatrixProp = GenericModelHelper.findProperty("d3 matrix", project.getProperty());

      String matrixBuffer = this.fileResource.download(user, d3MatrixProp.getValue());
      request.setInputData(new InputData());
      GJaxbProperty entry = new GJaxbProperty();
      entry.setName("conceptsMatrix");
      entry.setValue(matrixBuffer);
      request.getInputData().getProperty().add(entry);
    }
    GJaxbModelsComparison compare = new GJaxbModelsComparison();
    compare.setExpectedModel(new GJaxbModelsComparison.ExpectedModel());
    compare.getExpectedModel().setGenericModel(expectedModel);
    compare.setFieldModel(new GJaxbModelsComparison.FieldModel());
    compare.getFieldModel().setGenericModel(activeModel);
    compare.setCategory(null);
    request.getModelsComparison().add(compare);
    GJaxbDetectResponse detectResponse = this.detectionClient.detect(request);
    return detectResponse;
  }

}
