/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.dw.resources;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.rio.dw.resources.bo.LightInput;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Path("/{app}/r-iota/lightcontroler")
@Produces(MediaType.APPLICATION_JSON)
public class LightControlerResource {

	private static Logger LOG = LoggerFactory.getLogger(LightControlerResource.class.getName());

	private String philips_hue_ip_brigde = null;
	private String philips_hue_light_id = null;

	private static String PHILIPS_HUE_APPLICATION_KEY = null;

	private boolean lightErrorDetected = false;

	public LightControlerResource(Configuration conf) throws Exception {

		if (conf.getProperties().get("philips_hue_ip_brigde") != null) {
			philips_hue_ip_brigde = conf.getProperties().get("philips_hue_ip_brigde");
		}
		if (conf.getProperties().get("philips_hue_light_id") != null) {
			philips_hue_light_id = conf.getProperties().get("philips_hue_light_id");
		}
		if (System.getenv("PHILIPS_HUE_APPLICATION_KEY") != null) {
			PHILIPS_HUE_APPLICATION_KEY = System.getenv().get("PHILIPS_HUE_APPLICATION_KEY");
		}
	}

	public boolean isActivated() {
		if (philips_hue_ip_brigde != null && PHILIPS_HUE_APPLICATION_KEY != null && philips_hue_light_id != null) {
			return true;
		}
		return false;
	}

	@PUT
	@Path("/controlLight")
	@Consumes(MediaType.APPLICATION_JSON)
	public String controlLight(@Auth DWUser user, LightInput parameters) throws Exception {
		JSONObject res = new JSONObject();
		if (!this.lightErrorDetected) {
			try {
				if (isActivated()) {
					String address = "https://<bridge ip address>/clip/v2/resource/light/<id>";
					address = address.replace("<bridge ip address>", philips_hue_ip_brigde);
					address = address.replace("<id>", philips_hue_light_id);

					JSONObject payload = new JSONObject();

					JSONObject on = new JSONObject();
					on.put("on", true);
					payload.put("on", on);

					JSONObject dimming = new JSONObject();
					dimming.put("brightness", parameters.getBrightness());
					payload.put("dimming", dimming);

					JSONObject color = new JSONObject();
					JSONObject xy = new JSONObject();
					xy.put("x", parameters.getColorX());
					xy.put("y", parameters.getColorY());
					color.put("xy", xy);
					payload.put("color", color);

					// Créer un TrustManager qui n'effectue aucune validation de certificats
					TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
						@Override
						public void checkClientTrusted(X509Certificate[] chain, String authType) {
						}

						@Override
						public void checkServerTrusted(X509Certificate[] chain, String authType) {
						}

						@Override
						public X509Certificate[] getAcceptedIssuers() {
							return null;
						}
					} };

					// Initialiser le SSLContext avec notre TrustManager qui ignore les certificats
					SSLContext sslContext = SSLContext.getInstance("SSL");
					sslContext.init(null, trustAllCerts, new java.security.SecureRandom());

					HttpsURLConnection urlConnection = (HttpsURLConnection) new URL(address).openConnection();
					urlConnection.setSSLSocketFactory(sslContext.getSocketFactory());
					urlConnection.setRequestProperty("hue-application-key", PHILIPS_HUE_APPLICATION_KEY.trim());
					urlConnection.setDoOutput(true);
					urlConnection.setRequestMethod("PUT");
					urlConnection.setUseCaches(false);
					urlConnection.setHostnameVerifier(new HostnameVerifier() {
						@Override
						public boolean verify(String hostname, SSLSession sslSession) {
							return true;
						}
					});

					// set payload
					try (OutputStream os = urlConnection.getOutputStream()) {
						byte[] input = payload.toString().getBytes("utf-8");
						os.write(input, 0, input.length);
					}

					// connect
					LOG.debug("Change light:  (color: [x:" + parameters.getColorX() + ", y:" + parameters.getColorY()
							+ "]");
					System.out.println("Change light:  (color: [x:" + parameters.getColorX() + ", y:"
							+ parameters.getColorY() + "]");
					urlConnection.connect();

					// get response
					int responseCode = urlConnection.getResponseCode();
					if (responseCode == HttpURLConnection.HTTP_OK) {
						try (BufferedReader reader = new BufferedReader(
								new InputStreamReader(urlConnection.getInputStream(), "utf-8"))) {

							StringBuffer stringBuffer = new StringBuffer();
							String line = "";
							while ((line = reader.readLine()) != null) {
								stringBuffer.append(line);
							}
							String content = stringBuffer.toString();
							System.out.println(content);
						}
					} else {
						LOG.warn("HTTP Error: " + responseCode + " (color: [x:" + parameters.getColorX() + ", y:"
								+ parameters.getColorY() + "]");
					}

				} else {
					LOG.warn("Light controler (Philips hue not correctly configured) !!!");
				}
			} catch (Throwable e) {
				LOG.error("Light controler (Philips hue not correctly configured) !!!", e);
				res.put("error", "Light controler (Philips hue not correctly configured) !!!: " + e.getMessage());
				this.lightErrorDetected = true;
			}
		}
		return res.toString();
	}

}