/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iote;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOTEService extends RIOGAService {


	private static Logger LOG = LoggerFactory.getLogger(DWApplicationService.class.getName());


	public RIOTEService() throws Exception {
		this(new HashMap<String, Object>());
	}

	public RIOTEService(Map<String, Object> context) throws Exception {
		super(context);
	}

	@Override
	public String getName() {
		return "r-iote";
	}

	public String getRedirection() {
		return "/riote";
	}

	@SuppressWarnings("unchecked")
	@Override
	public RIOTEApplicationContext createApplicationContext() throws Exception {
		return new RIOTEApplicationContext(this);
	}
	
	
	@Override
	public void doRun(Configuration configuration, Environment environment,
			RestResourceManager resourcesManager) throws Exception {
		super.doRun(configuration, environment, resourcesManager);
		activatePubSubServerServlet(environment);


	}

}
