/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.r.iowa;

import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.r.ioda.RIODAApplicationContext;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.workflow.engine.ProcessClient;

public class RIOWAApplicationContext extends RIODAApplicationContext {
  
  private JSONArray workflowEngines = new JSONArray();
  
  public RIOWAApplicationContext(DWApplicationService applicationService) throws Exception {
    super(applicationService);
  }
  
  public void setWorkflowEngines(ProcessResource processResource) throws Exception {
      for(Entry<String, ProcessClient> entry : processResource.getDispatcher().getWorkflowEngines().entrySet()) {
        JSONObject we = new JSONObject();
        we.put("name", entry.getKey());
        we.put("url", entry.getValue().getServerAddress());
        workflowEngines.put(we);
      }
  }
  
  @Override
  public JSONObject toJSON() throws Exception {
    JSONObject context = super.toJSON();
    context.put("workflowEngines", this.workflowEngines.toString());
    return context;
  }


}
