/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */

/**
 * Please modify this class to meet your needs
 * This class is not complete
 */

package fr.emac.gind.generic.application.soap;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2016 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.event.pubsub.GJaxbContentType;
import fr.emac.gind.event.pubsub.GJaxbMessage;
import fr.emac.gind.event.pubsub.GJaxbMessageDirection;
import fr.emac.gind.event.pubsub.GJaxbMessageType;
import fr.emac.gind.generic.application.websocket.pubsub.PubSubEndpoint;
import fr.emac.gind.generic.application.websocket.pubsub.TopicManager;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.websocket.command.GetResultFault;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import fr.emac.gind.websocket.command.data.GJaxbGetResultResponse;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;

/**
 * This class was generated by Apache CXF 3.1.1
 * 2016-05-23T23:33:48.667+02:00
 * Generated source version: 3.1.1
 * 
 */

@WebService(portName = "websocketCommandSOAPEndpoint", serviceName = "websocketCommandService", targetNamespace = "http://www.gind.emac.fr/websocket/command/", wsdlLocation = "wsdl/websocketCommand.wsdl", endpointInterface = "fr.emac.gind.websocket.command.WebsocketCommand")
@BindingType("http://schemas.xmlsoap.org/wsdl/soap/http")
public class WebsocketCommandImpl implements WebsocketCommand {

  private static final Logger LOG = LoggerFactory.getLogger(WebsocketCommandImpl.class.getName());


  private static int WEBSOCKET_MAXTEXTSIZE = 8192;

  private String host = "localhost";
  private int port = -1;

  public WebsocketCommandImpl(int port) {
    this.port = port;
  }

  /* (non-Javadoc)
   * @see fr.emac.gind.websocket.command.WebsocketCommand#getResult(fr.emac.gind.websocket.command.GJaxbGetResult  parameters )*
   */
  public GJaxbGetResultResponse getResult(GJaxbGetResult parameters) throws GetResultFault    { 
    LOG.debug("Executing operation getResult");
    
    GJaxbGetResultResponse _return = new GJaxbGetResultResponse();
    try {
      final List<PubSubEndpoint> endpoints = TopicManager.getInstance().findTopic(parameters.getWebsocketId().trim());
      if(endpoints == null || endpoints.isEmpty()) {
        LOG.trace("Impossible to find topic corresponding to: " + parameters.getWebsocketId() + ". Perhaps, it has not been created from the browser" + " - stored keys: " + TopicManager.getInstance().getTopicsMap());
      } else {

        // broadcast event
        final GJaxbMessage message = new GJaxbMessage();
        message.setId(UUID.randomUUID().toString());
        message.setContentType(GJaxbContentType.JSON);
        message.setContent(JSONJAXBContext.getInstance().marshallAnyElement(parameters));
        message.setAuthor(this.getClass().getSimpleName());
        message.setEmissionDate(new Date().getTime());
        message.setMessageType(GJaxbMessageType.IN_ONLY);
        message.setMessageDirection(GJaxbMessageDirection.IN);

        TopicManager.getInstance().broadcastMessage(parameters.getWebsocketId(), JSONJAXBContext.getInstance().marshallAnyElement(message));

      }
      return _return;
    } catch (java.lang.Exception ex) {
      ex.printStackTrace();
      throw new GetResultFault(ex.getMessage(), null, ex);
    }
  }

}
