/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.websocket.chat;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


/**
 *
 *
 * @author Nicolas Salatge
 */
import java.io.IOException;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class ChatEndpoint {
    private Session session_;

    public Session getSession() {
        return session_;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session_ = session;
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.register(this);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) throws IOException {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.broadcastMessage(message);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        cause.printStackTrace(System.err);
    }
}
