/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2016 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.event.pubsub.GJaxbMessage;
import fr.emac.gind.event.pubsub.GJaxbMessageDirection;
import fr.emac.gind.marshaller.JSONJAXBContext;

@WebSocket
public class PubSubEndpoint {
  private Session session_;
  private static Logger LOG = LoggerFactory.getLogger(PubSubEndpoint.class.getName());

  public Session getSession() {
    return session_;
  }

  @OnWebSocketConnect
  public void onConnect(Session session) {
    this.session_ = session;
    EndpointHandler handler = EndpointHandler.getInstance();
    TopicManager.getInstance().addTopic(this);
    handler.register(this);
  }

  @OnWebSocketMessage
  public void onMessage(Session session, String message) throws Exception {
    EndpointHandler handler = EndpointHandler.getInstance();

    
    GJaxbMessage msg = JSONJAXBContext.getInstance().unmarshall("{ \"message\" : " + message + "}", GJaxbMessage.class);
    if(msg.getMessageDirection() == GJaxbMessageDirection.OUT) {
      LOG.info("msg.getId = " + msg.getId());
      MessageLocker locker = TopicManager.getInstance().getMessageLockersMap().get(msg.getId());
      assert locker != null : "locker cannot be null: " + msg;
      synchronized (locker) {
        locker.setMessage(msg);
        locker.notify();
      }
    }

    handler.broadcastMessage(message);
  }

  @OnWebSocketClose
  public void onClose(int statusCode, String reason) {
    
    EndpointHandler handler = EndpointHandler.getInstance();
    handler.removeByInstance(this);
    TopicManager.getInstance().removeEndpoint(this);
  }

  @OnWebSocketError
  public void onError(Throwable cause) {
    EndpointHandler handler = EndpointHandler.getInstance();
    handler.removeByInstance(this);
    TopicManager.getInstance().removeEndpoint(this);
    cause.printStackTrace(System.err);
  }
}
