/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.websocket.sockjs;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


/**
 *
 *
 * @author Nicolas Salatge
 */
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EndpointHandler {
    public static class EndpointHandlerBuilder {
        public static void buildEndpointHandler() {
            instance_ = new EndpointHandler();
        }
    }

    private static EndpointHandler instance_;

    public static EndpointHandler getInstance() {
        return instance_;
    }

    private Map<String, SockjsEndpoint> endpoints_ = new ConcurrentHashMap<>();

    public void register(SockjsEndpoint endpoint) {
        endpoints_.put(String.valueOf(endpoint.hashCode()), endpoint);
    }

    public SockjsEndpoint remove(String sessionId) {
        return endpoints_.remove(sessionId);
    }

    public SockjsEndpoint removeByInstance(SockjsEndpoint endpoint) {
        return remove(String.valueOf(endpoint.hashCode()));
    }

    public SockjsEndpoint get(String sessionId) {
        return endpoints_.get(sessionId);
    }

    public void broadcastMessage(String message) {
        endpoints_.values().forEach(p -> {
            try {
                p.getSession().getRemote().sendString(message);
            } catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}
