/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.soap;

import fr.emac.gind.event.pubsub.GJaxbContentType;
import fr.emac.gind.event.pubsub.GJaxbMessage;
import fr.emac.gind.event.pubsub.GJaxbMessageDirection;
import fr.emac.gind.event.pubsub.GJaxbMessageType;
import fr.emac.gind.generic.application.websocket.pubsub.PubSubEndpoint;
import fr.emac.gind.generic.application.websocket.pubsub.TopicManager;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.websocket.command.GetResultFault;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import fr.emac.gind.websocket.command.data.GJaxbGetResultResponse;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="websocketCommandSOAPEndpoint", serviceName="websocketCommandService", targetNamespace="http://www.gind.emac.fr/websocket/command/", wsdlLocation="wsdl/websocketCommand.wsdl", endpointInterface="fr.emac.gind.websocket.command.WebsocketCommand")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class WebsocketCommandImpl
implements WebsocketCommand {
    private static final Logger LOG = LoggerFactory.getLogger((String)WebsocketCommandImpl.class.getName());
    private static int WEBSOCKET_MAXTEXTSIZE = 8192;
    private String host = "localhost";
    private int port = -1;

    public WebsocketCommandImpl(int port) {
        this.port = port;
    }

    public GJaxbGetResultResponse getResult(GJaxbGetResult parameters) throws GetResultFault {
        LOG.debug("Executing operation getResult");
        GJaxbGetResultResponse _return = new GJaxbGetResultResponse();
        try {
            List<PubSubEndpoint> endpoints = TopicManager.getInstance().findTopic(parameters.getWebsocketId().trim());
            if (endpoints == null || endpoints.isEmpty()) {
                LOG.trace("Impossible to find topic corresponding to: " + parameters.getWebsocketId() + ". Perhaps, it has not been created from the browser - stored keys: " + String.valueOf(TopicManager.getInstance().getTopicsMap()));
            } else {
                GJaxbMessage message = new GJaxbMessage();
                message.setId(UUID.randomUUID().toString());
                message.setContentType(GJaxbContentType.JSON);
                message.setContent(JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters));
                message.setAuthor(this.getClass().getSimpleName());
                message.setEmissionDate(new Date().getTime());
                message.setMessageType(GJaxbMessageType.IN_ONLY);
                message.setMessageDirection(GJaxbMessageDirection.IN);
                TopicManager.getInstance().broadcastMessage(parameters.getWebsocketId(), JSONJAXBContext.getInstance().marshallAnyElement((Object)message));
            }
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new GetResultFault(ex.getMessage(), null, (Throwable)ex);
        }
    }
}

