/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.chat;

import fr.emac.gind.generic.application.websocket.chat.EndpointHandler;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class ChatEndpoint {
    private Session session_;

    public Session getSession() {
        return this.session_;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session_ = session;
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.register(this);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) throws IOException {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.broadcastMessage(message);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        cause.printStackTrace(System.err);
    }
}

