/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.chat;

import fr.emac.gind.generic.application.websocket.chat.ChatEndpoint;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EndpointHandler {
    private static EndpointHandler instance_;
    private Map<String, ChatEndpoint> endpoints_ = new ConcurrentHashMap<String, ChatEndpoint>();

    public static EndpointHandler getInstance() {
        return instance_;
    }

    public void register(ChatEndpoint endpoint) {
        this.endpoints_.put(String.valueOf(endpoint.hashCode()), endpoint);
    }

    public ChatEndpoint remove(String sessionId) {
        return this.endpoints_.remove(sessionId);
    }

    public ChatEndpoint removeByInstance(ChatEndpoint endpoint) {
        return this.remove(String.valueOf(endpoint.hashCode()));
    }

    public ChatEndpoint get(String sessionId) {
        return this.endpoints_.get(sessionId);
    }

    public void broadcastMessage(String message) {
        this.endpoints_.values().forEach(p -> {
            try {
                p.getSession().getRemote().sendString(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static class EndpointHandlerBuilder {
        public static void buildEndpointHandler() {
            instance_ = new EndpointHandler();
        }
    }
}

